/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.BlockDeviceDriverFactory;
import com.github.mjdev.libaums.driver.scsi.UnitNotReady;
import com.github.mjdev.libaums.partition.Partition;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import com.github.mjdev.libaums.partition.PartitionTableFactory;
import com.github.mjdev.libaums.usb.UsbCommunication;
import com.github.mjdev.libaums.usb.UsbCommunicationFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/mjdev/libaums/UsbMassStorageDevice;", "", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "inEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "outEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "inited", "", "partitions", "Ljava/util/ArrayList;", "Lcom/github/mjdev/libaums/partition/Partition;", "getUsbDevice", "()Landroid/hardware/usb/UsbDevice;", "close", "", "getPartitions", "", "init", "initPartitions", "partitionTable", "Lcom/github/mjdev/libaums/partition/PartitionTable;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "setupDevice", "Companion", "libaums_release"})
public final class UsbMassStorageDevice {
    private UsbDeviceConnection deviceConnection;
    private final ArrayList<Partition> partitions;
    private boolean inited;
    private final UsbManager usbManager;
    @NotNull
    private final UsbDevice usbDevice;
    private final UsbInterface usbInterface;
    private final UsbEndpoint inEndpoint;
    private final UsbEndpoint outEndpoint;
    private static final String TAG;
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;
    public static final Companion Companion;

    public final void init() throws IOException {
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            throw (Throwable)new IllegalStateException("Missing permission to access usb device: " + this.usbDevice);
        }
        this.setupDevice();
        this.inited = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupDevice() throws IOException {
        UsbDeviceConnection deviceConnection;
        Log.d((String)TAG, (String)"setup device");
        UsbDeviceConnection usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        if (usbDeviceConnection == null) {
            throw (Throwable)new IOException("deviceConnection is null!");
        }
        this.deviceConnection = deviceConnection = usbDeviceConnection;
        boolean claim = deviceConnection.claimInterface(this.usbInterface, true);
        if (!claim) {
            throw (Throwable)new IOException("could not claim interface!");
        }
        UsbCommunication communication = UsbCommunicationFactory.INSTANCE.createUsbCommunication(deviceConnection, this.outEndpoint, this.inEndpoint);
        byte[] maxLun = new byte[1];
        deviceConnection.controlTransfer(161, 254, 0, this.usbInterface.getId(), maxLun, 1, 5000);
        Log.i((String)TAG, (String)("MAX LUN " + maxLun[0]));
        int n = 0;
        int n2 = maxLun[0] + 1;
        while (n < n2) {
            void i;
            block6: {
                BlockDeviceDriver blockDevice = BlockDeviceDriverFactory.INSTANCE.createBlockDevice(communication, (byte)i);
                try {
                    blockDevice.init();
                }
                catch (UnitNotReady e) {
                    if (maxLun[0] == (byte)0) {
                        throw (Throwable)e;
                    }
                    break block6;
                }
                PartitionTable partitionTable = PartitionTableFactory.INSTANCE.createPartitionTable(blockDevice);
                ArrayList<Partition> partitions = this.initPartitions(partitionTable, blockDevice);
                this.partitions.addAll((Collection<Partition>)partitions);
            }
            ++i;
        }
    }

    private final ArrayList<Partition> initPartitions(PartitionTable partitionTable, BlockDeviceDriver blockDevice) throws IOException {
        List<PartitionTableEntry> partitionEntrys = partitionTable.getPartitionTableEntries();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (PartitionTableEntry entry : partitionEntrys) {
            Partition partition;
            Partition partition2 = Partition.Companion.createPartition(entry, blockDevice);
            if (partition2 == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            Partition it = partition;
            boolean bl3 = false;
            partitions.add(it);
        }
        return partitions;
    }

    public final void close() {
        UsbDeviceConnection usbDeviceConnection;
        block5: {
            block4: {
                Log.d((String)TAG, (String)"close device");
                usbDeviceConnection = this.deviceConnection;
                if (usbDeviceConnection == null) break block4;
                UsbDeviceConnection usbDeviceConnection2 = usbDeviceConnection;
                boolean bl = false;
                boolean bl2 = false;
                UsbDeviceConnection it = usbDeviceConnection2;
                boolean bl3 = false;
                usbDeviceConnection = it;
                if (usbDeviceConnection != null) break block5;
            }
            return;
        }
        UsbDeviceConnection deviceConnection = usbDeviceConnection;
        boolean release = deviceConnection.releaseInterface(this.usbInterface);
        if (!release) {
            Log.e((String)TAG, (String)"could not release interface!");
        }
        deviceConnection.close();
        this.inited = false;
    }

    @NotNull
    public final List<Partition> getPartitions() {
        return this.partitions;
    }

    @NotNull
    public final UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    private UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.inEndpoint = inEndpoint;
        this.outEndpoint = outEndpoint;
        this.partitions = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        TAG = UsbMassStorageDevice.class.getSimpleName();
    }

    public /* synthetic */ UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint, DefaultConstructorMarker $constructor_marker) {
        this(usbManager, usbDevice, usbInterface, inEndpoint, outEndpoint);
    }

    @JvmStatic
    @NotNull
    public static final UsbMassStorageDevice[] getMassStorageDevices(@NotNull Context context) {
        return Companion.getMassStorageDevices(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/mjdev/libaums/UsbMassStorageDevice$Companion;", "", "()V", "INTERFACE_PROTOCOL", "", "INTERFACE_SUBCLASS", "TAG", "", "kotlin.jvm.PlatformType", "getMassStorageDevices", "", "Lcom/github/mjdev/libaums/UsbMassStorageDevice;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)[Lcom/github/mjdev/libaums/UsbMassStorageDevice;", "libaums_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final UsbMassStorageDevice[] getMassStorageDevices(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("usb");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.usb.UsbManager");
            }
            UsbManager usbManager = (UsbManager)object;
            ArrayList<UsbMassStorageDevice> result = new ArrayList<UsbMassStorageDevice>();
            for (UsbDevice device : usbManager.getDeviceList().values()) {
                Log.i((String)TAG, (String)("found usb device: " + device));
                int n = 0;
                UsbDevice usbDevice = device;
                Intrinsics.checkExpressionValueIsNotNull((Object)usbDevice, (String)"device");
                int n2 = usbDevice.getInterfaceCount();
                while (n < n2) {
                    void i;
                    UsbInterface usbInterface = device.getInterface((int)i);
                    Log.i((String)TAG, (String)("found usb interface: " + usbInterface));
                    UsbInterface usbInterface2 = usbInterface;
                    Intrinsics.checkExpressionValueIsNotNull((Object)usbInterface2, (String)"usbInterface");
                    if (usbInterface2.getInterfaceClass() != 8 || usbInterface.getInterfaceSubclass() != 6 || usbInterface.getInterfaceProtocol() != 80) {
                        Log.i((String)TAG, (String)"device interface not suitable!");
                    } else {
                        int endpointCount = usbInterface.getEndpointCount();
                        if (endpointCount != 2) {
                            Log.w((String)TAG, (String)"inteface endpoint count != 2");
                        }
                        UsbEndpoint outEndpoint = null;
                        UsbEndpoint inEndpoint = null;
                        int n3 = 0;
                        int n4 = endpointCount;
                        while (n3 < n4) {
                            void j;
                            UsbEndpoint endpoint = usbInterface.getEndpoint((int)j);
                            Log.i((String)TAG, (String)("found usb endpoint: " + endpoint));
                            UsbEndpoint usbEndpoint = endpoint;
                            Intrinsics.checkExpressionValueIsNotNull((Object)usbEndpoint, (String)"endpoint");
                            if (usbEndpoint.getType() == 2) {
                                if (endpoint.getDirection() == 0) {
                                    outEndpoint = endpoint;
                                } else {
                                    inEndpoint = endpoint;
                                }
                            }
                            ++j;
                        }
                        if (outEndpoint == null || inEndpoint == null) {
                            Log.e((String)TAG, (String)"Not all needed endpoints found!");
                        } else {
                            result.add(new UsbMassStorageDevice(usbManager, device, usbInterface, inEndpoint, outEndpoint, null));
                        }
                    }
                    ++i;
                }
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            UsbMassStorageDevice[] usbMassStorageDeviceArray = thisCollection$iv.toArray(new UsbMassStorageDevice[0]);
            if (usbMassStorageDeviceArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return usbMassStorageDeviceArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

