/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import androidx.annotation.Nullable;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.fs.FileSystemPartitionTableCreator;
import com.github.mjdev.libaums.partition.mbr.MasterBootRecordCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PartitionTableFactory {
    private static List<PartitionTableCreator> partitionTables = new ArrayList<PartitionTableCreator>();

    public static PartitionTable createPartitionTable(BlockDeviceDriver blockDevice) throws IOException {
        for (PartitionTableCreator creator : partitionTables) {
            PartitionTable table = creator.read(blockDevice);
            if (table == null) continue;
            return table;
        }
        throw new UnsupportedPartitionTableException();
    }

    public static synchronized void registerPartitionTable(PartitionTableCreator creator) {
        partitionTables.add(creator);
    }

    static {
        PartitionTableFactory.registerPartitionTable(new FileSystemPartitionTableCreator());
        PartitionTableFactory.registerPartitionTable(new MasterBootRecordCreator());
    }

    public static interface PartitionTableCreator {
        @Nullable
        public PartitionTable read(BlockDeviceDriver var1) throws IOException;
    }

    public static class UnsupportedPartitionTableException
    extends IOException {
    }
}

