/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi;

import android.util.Log;
import com.github.mjdev.libaums.UsbCommunication;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.scsi.commands.CommandBlockWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.CommandStatusWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiry;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiryResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiRead10;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacity;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacityResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiTestUnitReady;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiWrite10;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ScsiBlockDevice
implements BlockDeviceDriver {
    private static final String TAG = ScsiBlockDevice.class.getSimpleName();
    private UsbCommunication usbCommunication;
    private ByteBuffer outBuffer;
    private byte[] cswBuffer;
    private int blockSize;
    private int lastBlockAddress;

    public ScsiBlockDevice(UsbCommunication usbCommunication) {
        this.usbCommunication = usbCommunication;
        this.outBuffer = ByteBuffer.allocate(31);
        this.cswBuffer = new byte[13];
    }

    @Override
    public void init() throws IOException {
        ByteBuffer inBuffer = ByteBuffer.allocate(36);
        ScsiInquiry inquiry = new ScsiInquiry((byte)inBuffer.array().length);
        this.transferCommand(inquiry, inBuffer);
        ScsiInquiryResponse inquiryResponse = ScsiInquiryResponse.read(inBuffer);
        Log.d((String)TAG, (String)("inquiry response: " + inquiryResponse));
        if (inquiryResponse.getPeripheralQualifier() != 0 || inquiryResponse.getPeripheralDeviceType() != 0) {
            throw new IOException("unsupported PeripheralQualifier or PeripheralDeviceType");
        }
        ScsiTestUnitReady testUnit = new ScsiTestUnitReady();
        if (!this.transferCommand(testUnit, null)) {
            Log.w((String)TAG, (String)"unit not ready!");
        }
        ScsiReadCapacity readCapacity = new ScsiReadCapacity();
        this.transferCommand(readCapacity, inBuffer);
        ScsiReadCapacityResponse readCapacityResponse = ScsiReadCapacityResponse.read(inBuffer);
        this.blockSize = readCapacityResponse.getBlockLength();
        this.lastBlockAddress = readCapacityResponse.getLogicalBlockAddress();
        Log.i((String)TAG, (String)("Block size: " + this.blockSize));
        Log.i((String)TAG, (String)("Last block address: " + this.lastBlockAddress));
    }

    private boolean transferCommand(CommandBlockWrapper command, ByteBuffer inBuffer) throws IOException {
        CommandStatusWrapper csw;
        byte[] outArray = this.outBuffer.array();
        this.outBuffer.clear();
        Arrays.fill(outArray, (byte)0);
        command.serialize(this.outBuffer);
        int written = this.usbCommunication.bulkOutTransfer(outArray, outArray.length);
        if (written != outArray.length) {
            Log.e((String)TAG, (String)("Writing all bytes on command " + command + " failed!"));
        }
        int transferLength = command.getdCbwDataTransferLength();
        int read = 0;
        if (transferLength > 0) {
            byte[] inArray = inBuffer.array();
            if (command.getDirection() == CommandBlockWrapper.Direction.IN) {
                int tmp;
                do {
                    if ((tmp = this.usbCommunication.bulkInTransfer(inArray, read + inBuffer.position(), inBuffer.remaining() - read)) != -1) continue;
                    throw new IOException("reading failed!");
                } while ((read += tmp) < transferLength);
                if (read != transferLength) {
                    throw new IOException("Unexpected command size (" + read + ") on response to " + command);
                }
            } else {
                int tmp;
                written = 0;
                do {
                    if ((tmp = this.usbCommunication.bulkOutTransfer(inArray, written + inBuffer.position(), inBuffer.remaining() - written)) != -1) continue;
                    throw new IOException("writing failed!");
                } while ((written += tmp) < transferLength);
                if (written != transferLength) {
                    throw new IOException("Could not write all bytes: " + command);
                }
            }
        }
        if ((read = this.usbCommunication.bulkInTransfer(this.cswBuffer, this.cswBuffer.length)) != 13) {
            Log.e((String)TAG, (String)"Unexpected command size while expecting csw");
        }
        if ((csw = CommandStatusWrapper.read(ByteBuffer.wrap(this.cswBuffer))).getbCswStatus() != 0) {
            Log.e((String)TAG, (String)("Unsuccessful Csw status: " + csw.getbCswStatus()));
        }
        if (csw.getdCswTag() != command.getdCbwTag()) {
            Log.e((String)TAG, (String)"wrong csw tag!");
        }
        return csw.getbCswStatus() == 0;
    }

    @Override
    public synchronized void read(long devOffset, ByteBuffer dest) throws IOException {
        ByteBuffer buffer;
        if (dest.remaining() % this.blockSize != 0) {
            Log.w((String)TAG, (String)"we have to round up size to next block sector");
            int rounded = this.blockSize - dest.remaining() % this.blockSize + dest.remaining();
            buffer = ByteBuffer.allocate(rounded);
            buffer.limit(rounded);
        } else {
            buffer = dest;
        }
        ScsiRead10 read = new ScsiRead10((int)devOffset, buffer.remaining(), this.blockSize);
        this.transferCommand(read, buffer);
        if (dest.remaining() % this.blockSize != 0) {
            System.arraycopy(buffer.array(), 0, dest.array(), dest.position(), dest.remaining());
        }
        dest.position(dest.limit());
    }

    @Override
    public synchronized void write(long devOffset, ByteBuffer src) throws IOException {
        ByteBuffer buffer;
        if (src.remaining() % this.blockSize != 0) {
            Log.w((String)TAG, (String)"we have to round up size to next block sector");
            int rounded = this.blockSize - src.remaining() % this.blockSize + src.remaining();
            buffer = ByteBuffer.allocate(rounded);
            buffer.limit(rounded);
            System.arraycopy(src.array(), src.position(), buffer.array(), 0, src.remaining());
        } else {
            buffer = src;
        }
        ScsiWrite10 write = new ScsiWrite10((int)devOffset, buffer.remaining(), this.blockSize);
        this.transferCommand(write, buffer);
        src.position(src.limit());
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }
}

