/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.server.http;

import android.support.annotation.NonNull;
import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.UsbFileInputStream;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;

public class UsbFileHttpServer
extends NanoHTTPD {
    private static final String TAG = UsbFile.class.getSimpleName();
    private UsbFile rootFile;

    public UsbFileHttpServer(String hostname, int port, @NonNull UsbFile file) {
        super(hostname, port);
        this.rootFile = file;
    }

    public UsbFileHttpServer(int port, @NonNull UsbFile file) {
        super(port);
        this.rootFile = file;
    }

    public UsbFileHttpServer(@NonNull UsbFile file) {
        super(8000);
        this.rootFile = file;
    }

    public String getBaseUrl() {
        String hostname = this.getHostname();
        if (hostname == null) {
            hostname = "localhost";
        }
        return "http://" + hostname + ":" + this.getListeningPort() + "/";
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        UsbFile fileToServe;
        String uri;
        try {
            uri = URLDecoder.decode(session.getUri(), "Unicode");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"could not decode URL", (Throwable)e);
            return UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/html", (String)"Unable to decode URL");
        }
        Log.d((String)TAG, (String)("Request: " + uri));
        Map headers = session.getHeaders();
        String range = (String)headers.get("range");
        if (!this.rootFile.isDirectory()) {
            Log.d((String)TAG, (String)"Serving root file");
            if (!"/".equals(uri) && !("/" + this.rootFile.getName()).equals(uri)) {
                Log.d((String)TAG, (String)"Invalid request, respond with 404");
                return super.serve(session);
            }
            fileToServe = this.rootFile;
        } else {
            try {
                fileToServe = this.rootFile.search(uri.substring(1));
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IOException", (Throwable)e);
                return UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN, (String)"text/html", (String)"IOException");
            }
        }
        if (fileToServe == null) {
            Log.d((String)TAG, (String)"fileToServe == null");
            return super.serve(session);
        }
        if (fileToServe.isDirectory()) {
            return UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/html", (String)"Directory listing not supported");
        }
        if (range == null) {
            return this.serveCompleteFile(fileToServe);
        }
        try {
            return this.serveRangeOfFile(fileToServe, range);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException", (Throwable)e);
            return UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN, (String)"text/html", (String)"IOException");
        }
    }

    private NanoHTTPD.Response serveCompleteFile(UsbFile file) {
        Log.d((String)TAG, (String)"Serving complete file");
        String mimeType = UsbFileHttpServer.getMimeTypeForFile((String)file.getName());
        NanoHTTPD.Response res = UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)new UsbFileInputStream(file), (long)file.getLength());
        res.addHeader("Accept-Ranges", "bytes");
        return res;
    }

    private NanoHTTPD.Response serveRangeOfFile(UsbFile file, String range) throws IOException {
        long contentLength;
        Log.d((String)TAG, (String)("Serving range of file " + range));
        String mimeType = UsbFileHttpServer.getMimeTypeForFile((String)file.getName());
        long start = 0L;
        long end = -1L;
        long length = file.getLength();
        if (range.startsWith("bytes=")) {
            range = range.substring("bytes=".length());
            int minus = range.indexOf(45);
            try {
                if (minus > 0) {
                    start = Long.parseLong(range.substring(0, minus));
                    end = Long.parseLong(range.substring(minus + 1));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            return UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/html", (String)"Range header invalid");
        }
        if (start < 0L || end >= length) {
            return UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE, (String)"text/html", (String)"Start < 0 or end >= actual length");
        }
        if (end < 0L) {
            end = length - 1L;
        }
        if ((contentLength = end - start + 1L) < 0L) {
            contentLength = 0L;
        }
        Log.d((String)TAG, (String)("Serving file from " + start + " to " + end + ", Content-Length: " + contentLength));
        UsbFileInputStream stream = new UsbFileInputStream(file);
        stream.skip(start);
        NanoHTTPD.Response res = UsbFileHttpServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.PARTIAL_CONTENT, (String)mimeType, (InputStream)stream, (long)contentLength);
        res.addHeader("Accept-Ranges", "bytes");
        res.addHeader("Content-Length", "" + contentLength);
        res.addHeader("Content-Range", "bytes " + start + "-" + end + "/" + length);
        return res;
    }
}

