/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizool.technology.tableaccess.business;

import com.github.mizool.technology.typemapping.business.DataType;
import java.io.Serializable;
import lombok.NonNull;

public final class Column
implements Serializable {
    @NonNull
    private final String name;
    @NonNull
    private final DataType type;

    Column(@NonNull String name, @NonNull DataType type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.name = name;
        this.type = type;
    }

    public static ColumnBuilder builder() {
        return new ColumnBuilder();
    }

    public ColumnBuilder toBuilder() {
        return new ColumnBuilder().name(this.name).type(this.type);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public DataType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DataType this$type = this.getType();
        DataType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", type=" + this.getType() + ")";
    }

    public static class ColumnBuilder {
        private String name;
        private DataType type;

        ColumnBuilder() {
        }

        public ColumnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder type(DataType type) {
            this.type = type;
            return this;
        }

        public Column build() {
            return new Column(this.name, this.type);
        }

        public String toString() {
            return "Column.ColumnBuilder(name=" + this.name + ", type=" + this.type + ")";
        }
    }
}

