/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.PubSub;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.database.Transaction;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.protocal.AbstractOperation;
import com.github.microwww.redis.protocal.RedisArgumentsException;
import com.github.microwww.redis.protocal.RedisOutputProtocol;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.operation.ConnectionOperation;
import com.github.microwww.redis.protocal.operation.HashOperation;
import com.github.microwww.redis.protocal.operation.HyperLogLog;
import com.github.microwww.redis.protocal.operation.KeyOperation;
import com.github.microwww.redis.protocal.operation.ListOperation;
import com.github.microwww.redis.protocal.operation.PubSubOperation;
import com.github.microwww.redis.protocal.operation.ScriptOperation;
import com.github.microwww.redis.protocal.operation.ServerOperation;
import com.github.microwww.redis.protocal.operation.SetOperation;
import com.github.microwww.redis.protocal.operation.SortedSetOperation;
import com.github.microwww.redis.protocal.operation.StringOperation;
import com.github.microwww.redis.protocal.operation.TransactionOperation;
import com.github.microwww.redis.util.Assert;
import com.github.microwww.redis.util.StringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Schema
implements Closeable {
    private static final Logger log = LogFactory.getLogger(Schema.class);
    private static final ExecutorService pool = Executors.newFixedThreadPool(1);
    public static final int DEFAULT_SCHEMA_SIZE = 16;
    private static final AbstractOperation[] SUPPORT_OPERATION = new AbstractOperation[]{new ConnectionOperation(), new HashOperation(), new HyperLogLog(), new KeyOperation(), new ListOperation(), new PubSubOperation(), new ScriptOperation(), new ServerOperation(), new SetOperation(), new SortedSetOperation(), new StringOperation(), new TransactionOperation()};
    private final Map<String, Invoker> invokers = new ConcurrentHashMap<String, Invoker>();
    private final int size;
    private final RedisDatabase[] redisDatabases;
    private final List<AbstractOperation> operations;
    private final PubSub pubSub = new PubSub();

    public Schema(int size, AbstractOperation ... operations) {
        Assert.isTrue(size > 0, "Database SIZE > 0");
        this.size = size;
        this.redisDatabases = new RedisDatabase[size];
        this.operations = this.ops(operations);
        this.init();
    }

    private List<AbstractOperation> ops(AbstractOperation[] operations) {
        ArrayList<AbstractOperation> list = new ArrayList<AbstractOperation>();
        list.addAll(Arrays.asList(operations));
        list.addAll(Arrays.asList(SUPPORT_OPERATION));
        return Collections.unmodifiableList(list);
    }

    private void init() {
        for (int i = 0; i < this.redisDatabases.length; ++i) {
            this.redisDatabases[i] = new RedisDatabase();
        }
    }

    public RedisDatabase getRedisDatabases(int i) {
        return this.redisDatabases[i];
    }

    public PubSub getPubSub() {
        return this.pubSub;
    }

    public int getSize() {
        return this.size;
    }

    public List<AbstractOperation> getOperations() {
        return this.operations;
    }

    public void submit(Runnable run) {
        pool.execute(run);
    }

    public void execute(RedisRequest request) throws IOException {
        log.debug("Wait thread to run {}, {}", request.getCommand(), request.getContext().getRemoteHost());
        Future<String> submit = pool.submit(() -> {
            log.debug("Get thread to run {}, {}", request.getCommand(), request.getContext().getRemoteHost());
            Optional<Transaction> tx = Transaction.ifTransaction(request.getContext());
            if (tx.isPresent() && tx.get().isEnable()) {
                log.debug("Transaction run {}", request.getCommand());
                tx.get().exec(request);
            } else {
                this.run(request);
            }
            return request.getCommand();
        });
        try {
            submit.get();
            request.getNext().run();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                log.error("Run command {} error", request.getCommand(), cause);
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new RuntimeException(cause);
            }
            throw new RuntimeException(e);
        }
    }

    public void run(RedisRequest request) throws IOException {
        String cmd = request.getCommand();
        try {
            this.execute(cmd, request);
        }
        catch (RedisArgumentsException error) {
            request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, error.getMessage());
        }
        catch (RuntimeException e) {
            String message = StringUtil.redisErrorMessage(e);
            log.error("Server error ! {}", message, e);
            request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, String.format("Server run error ! : %s, %s", e.getClass().getName(), message));
        }
    }

    void execute(String cmd, RedisRequest request) throws IOException {
        Invoker invoker = this.invokers.get(cmd);
        if (invoker == null) {
            this.tryInvoke(cmd);
            invoker = this.invokers.get(cmd);
        }
        invoker.invoke(request);
    }

    public synchronized void tryInvoke(String cmd) {
        if (this.invokers.get(cmd) != null) {
            return;
        }
        for (AbstractOperation protocol : this.operations) {
            try {
                Method method = protocol.getClass().getMethod(cmd.toLowerCase(), RedisRequest.class);
                this.invokers.put(cmd, new Invoker(protocol, method));
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            Method method = this.getClass().getMethod("unsupportedOperation", RedisRequest.class);
            this.invokers.put(cmd, new Invoker(this, method));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("This class must has unsupportedOperation method", e);
        }
    }

    public void unsupportedOperation(RedisRequest request) throws IOException {
        request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, "unknown command '" + request.getCommand() + "'");
    }

    public synchronized void clearDatabase() {
        for (RedisDatabase db : this.redisDatabases) {
            db.clear();
        }
    }

    @Override
    public void close() {
        for (RedisDatabase r : this.redisDatabases) {
            try {
                r.close();
            }
            catch (Exception e) {
                log.error("RedisDatabase close error", e);
            }
        }
        pool.shutdown();
    }

    public static class Invoker {
        public final Object instance;
        public final Method method;

        public Invoker(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
            method.setAccessible(true);
        }

        public void invoke(Object ... args) throws IOException {
            try {
                this.method.invoke(this.instance, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (e.getCause() != null) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }
}

