/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.QualitativeValue;
import com.google.schemaorg.core.Seat;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class SeatImpl
extends IntangibleImpl
implements Seat {
    private static final ImmutableSet<String> PROPERTY_SET = SeatImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seatingType");
        builder.add((Object)"http://schema.org/seatNumber");
        builder.add((Object)"http://schema.org/seatRow");
        builder.add((Object)"http://schema.org/seatSection");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public SeatImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Seat";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeatingTypeList() {
        return this.getProperty("http://schema.org/seatingType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeatNumberList() {
        return this.getProperty("http://schema.org/seatNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeatRowList() {
        return this.getProperty("http://schema.org/seatRow");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeatSectionList() {
        return this.getProperty("http://schema.org/seatSection");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Seat.Builder>
    implements Seat.Builder {
        BuilderImpl() {
        }

        @Override
        public Seat.Builder addAdditionalType(URL value) {
            return (Seat.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Seat.Builder addAdditionalType(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Seat.Builder addAlternateName(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Seat.Builder addAlternateName(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Seat.Builder addDescription(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Seat.Builder addDescription(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Seat.Builder addImage(ImageObject value) {
            return (Seat.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Seat.Builder addImage(ImageObject.Builder value) {
            return (Seat.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Seat.Builder addImage(URL value) {
            return (Seat.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Seat.Builder addImage(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Seat.Builder addMainEntityOfPage(CreativeWork value) {
            return (Seat.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Seat.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Seat.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Seat.Builder addMainEntityOfPage(URL value) {
            return (Seat.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Seat.Builder addMainEntityOfPage(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Seat.Builder addName(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Seat.Builder addName(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Seat.Builder addPotentialAction(Action value) {
            return (Seat.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Seat.Builder addPotentialAction(Action.Builder value) {
            return (Seat.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Seat.Builder addPotentialAction(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Seat.Builder addSameAs(URL value) {
            return (Seat.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Seat.Builder addSameAs(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Seat.Builder addSeatingType(QualitativeValue value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatingType", value);
        }

        @Override
        public Seat.Builder addSeatingType(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatingType", value);
        }

        @Override
        public Seat.Builder addSeatingType(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatingType", Text.of(value));
        }

        @Override
        public Seat.Builder addSeatNumber(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatNumber", value);
        }

        @Override
        public Seat.Builder addSeatNumber(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatNumber", Text.of(value));
        }

        @Override
        public Seat.Builder addSeatRow(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatRow", value);
        }

        @Override
        public Seat.Builder addSeatRow(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatRow", Text.of(value));
        }

        @Override
        public Seat.Builder addSeatSection(Text value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatSection", value);
        }

        @Override
        public Seat.Builder addSeatSection(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/seatSection", Text.of(value));
        }

        @Override
        public Seat.Builder addUrl(URL value) {
            return (Seat.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Seat.Builder addUrl(String value) {
            return (Seat.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Seat.Builder addDetailedDescription(Article value) {
            return (Seat.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Seat.Builder addDetailedDescription(Article.Builder value) {
            return (Seat.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Seat.Builder addDetailedDescription(String value) {
            return (Seat.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Seat.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Seat.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Seat.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Seat.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Seat.Builder addPopularityScore(String value) {
            return (Seat.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Seat build() {
            return new SeatImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

