/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.ItemListImpl;
import com.google.schemaorg.core.ItemListOrderType;
import com.google.schemaorg.core.ListItem;
import com.google.schemaorg.core.OfferCatalog;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class OfferCatalogImpl
extends ItemListImpl
implements OfferCatalog {
    private static final ImmutableSet<String> PROPERTY_SET = OfferCatalogImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/itemListElement");
        builder.add((Object)"http://schema.org/itemListOrder");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numberOfItems");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public OfferCatalogImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/OfferCatalog";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<OfferCatalog.Builder>
    implements OfferCatalog.Builder {
        BuilderImpl() {
        }

        @Override
        public OfferCatalog.Builder addAdditionalType(URL value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public OfferCatalog.Builder addAdditionalType(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addAlternateName(Text value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public OfferCatalog.Builder addAlternateName(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addDescription(Text value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public OfferCatalog.Builder addDescription(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addImage(ImageObject value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public OfferCatalog.Builder addImage(ImageObject.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public OfferCatalog.Builder addImage(URL value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public OfferCatalog.Builder addImage(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addItemListElement(ListItem value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public OfferCatalog.Builder addItemListElement(ListItem.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListElement", value.build());
        }

        @Override
        public OfferCatalog.Builder addItemListElement(Text value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public OfferCatalog.Builder addItemListElement(Thing value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public OfferCatalog.Builder addItemListElement(Thing.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListElement", value.build());
        }

        @Override
        public OfferCatalog.Builder addItemListElement(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListElement", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addItemListOrder(ItemListOrderType value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListOrder", value);
        }

        @Override
        public OfferCatalog.Builder addItemListOrder(Text value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListOrder", value);
        }

        @Override
        public OfferCatalog.Builder addItemListOrder(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/itemListOrder", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addMainEntityOfPage(CreativeWork value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public OfferCatalog.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public OfferCatalog.Builder addMainEntityOfPage(URL value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public OfferCatalog.Builder addMainEntityOfPage(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addName(Text value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public OfferCatalog.Builder addName(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addNumberOfItems(Integer value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/numberOfItems", value);
        }

        @Override
        public OfferCatalog.Builder addNumberOfItems(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/numberOfItems", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addPotentialAction(Action value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public OfferCatalog.Builder addPotentialAction(Action.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public OfferCatalog.Builder addPotentialAction(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addSameAs(URL value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public OfferCatalog.Builder addSameAs(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addUrl(URL value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public OfferCatalog.Builder addUrl(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addDetailedDescription(Article value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public OfferCatalog.Builder addDetailedDescription(Article.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public OfferCatalog.Builder addDetailedDescription(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public OfferCatalog.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public OfferCatalog.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public OfferCatalog.Builder addPopularityScore(String value) {
            return (OfferCatalog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public OfferCatalog build() {
            return new OfferCatalogImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

