/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalEvidenceLevel;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalGuidelineImpl
extends MedicalEntityImpl
implements MedicalGuideline {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalGuidelineImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/evidenceLevel");
        builder.add((Object)"http://schema.org/evidenceOrigin");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/guidelineDate");
        builder.add((Object)"http://schema.org/guidelineSubject");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalGuidelineImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalGuideline";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getEvidenceLevelList() {
        return this.getProperty("http://schema.org/evidenceLevel");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEvidenceOriginList() {
        return this.getProperty("http://schema.org/evidenceOrigin");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGuidelineDateList() {
        return this.getProperty("http://schema.org/guidelineDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGuidelineSubjectList() {
        return this.getProperty("http://schema.org/guidelineSubject");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalGuideline.Builder>
    implements MedicalGuideline.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalGuideline.Builder addAdditionalType(URL value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalGuideline.Builder addAdditionalType(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addAlternateName(Text value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalGuideline.Builder addAlternateName(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addCode(MedicalCode value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalGuideline.Builder addCode(MedicalCode.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalGuideline.Builder addCode(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addDescription(Text value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalGuideline.Builder addDescription(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addEvidenceLevel(MedicalEvidenceLevel value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/evidenceLevel", value);
        }

        @Override
        public MedicalGuideline.Builder addEvidenceLevel(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/evidenceLevel", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addEvidenceOrigin(Text value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/evidenceOrigin", value);
        }

        @Override
        public MedicalGuideline.Builder addEvidenceOrigin(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/evidenceOrigin", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addGuideline(MedicalGuideline value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalGuideline.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalGuideline.Builder addGuideline(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addGuidelineDate(Date value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guidelineDate", value);
        }

        @Override
        public MedicalGuideline.Builder addGuidelineDate(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guidelineDate", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addGuidelineSubject(MedicalEntity value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guidelineSubject", value);
        }

        @Override
        public MedicalGuideline.Builder addGuidelineSubject(MedicalEntity.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guidelineSubject", value.build());
        }

        @Override
        public MedicalGuideline.Builder addGuidelineSubject(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/guidelineSubject", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addImage(ImageObject value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalGuideline.Builder addImage(ImageObject.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalGuideline.Builder addImage(URL value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalGuideline.Builder addImage(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalGuideline.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalGuideline.Builder addMainEntityOfPage(URL value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalGuideline.Builder addMainEntityOfPage(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalGuideline.Builder addMedicineSystem(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addName(Text value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalGuideline.Builder addName(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addPotentialAction(Action value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalGuideline.Builder addPotentialAction(Action.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalGuideline.Builder addPotentialAction(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addRecognizingAuthority(Organization value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalGuideline.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalGuideline.Builder addRecognizingAuthority(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalGuideline.Builder addRelevantSpecialty(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addSameAs(URL value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalGuideline.Builder addSameAs(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addStudy(MedicalStudy value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalGuideline.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalGuideline.Builder addStudy(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addUrl(URL value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalGuideline.Builder addUrl(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addDetailedDescription(Article value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalGuideline.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalGuideline.Builder addDetailedDescription(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalGuideline.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalGuideline.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalGuideline.Builder addPopularityScore(String value) {
            return (MedicalGuideline.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalGuideline build() {
            return new MedicalGuidelineImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

