/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalDevicePurpose;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalDeviceImpl
extends MedicalEntityImpl
implements MedicalDevice {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalDeviceImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/adverseOutcome");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/contraindication");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/indication");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/postOp");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/preOp");
        builder.add((Object)"http://schema.org/procedure");
        builder.add((Object)"http://schema.org/purpose");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seriousAdverseOutcome");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalDeviceImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalDevice";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdverseOutcomeList() {
        return this.getProperty("http://schema.org/adverseOutcome");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContraindicationList() {
        return this.getProperty("http://schema.org/contraindication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIndicationList() {
        return this.getProperty("http://schema.org/indication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPostOpList() {
        return this.getProperty("http://schema.org/postOp");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPreOpList() {
        return this.getProperty("http://schema.org/preOp");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProcedureList() {
        return this.getProperty("http://schema.org/procedure");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPurposeList() {
        return this.getProperty("http://schema.org/purpose");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeriousAdverseOutcomeList() {
        return this.getProperty("http://schema.org/seriousAdverseOutcome");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalDevice.Builder>
    implements MedicalDevice.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalDevice.Builder addAdditionalType(URL value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalDevice.Builder addAdditionalType(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addAdverseOutcome(MedicalEntity value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/adverseOutcome", value);
        }

        @Override
        public MedicalDevice.Builder addAdverseOutcome(MedicalEntity.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/adverseOutcome", value.build());
        }

        @Override
        public MedicalDevice.Builder addAdverseOutcome(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/adverseOutcome", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addAlternateName(Text value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalDevice.Builder addAlternateName(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addCode(MedicalCode value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalDevice.Builder addCode(MedicalCode.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalDevice.Builder addCode(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addContraindication(MedicalContraindication value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/contraindication", value);
        }

        @Override
        public MedicalDevice.Builder addContraindication(MedicalContraindication.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/contraindication", value.build());
        }

        @Override
        public MedicalDevice.Builder addContraindication(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/contraindication", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addDescription(Text value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalDevice.Builder addDescription(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addGuideline(MedicalGuideline value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalDevice.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalDevice.Builder addGuideline(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addImage(ImageObject value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalDevice.Builder addImage(ImageObject.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalDevice.Builder addImage(URL value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalDevice.Builder addImage(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addIndication(MedicalIndication value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/indication", value);
        }

        @Override
        public MedicalDevice.Builder addIndication(MedicalIndication.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/indication", value.build());
        }

        @Override
        public MedicalDevice.Builder addIndication(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/indication", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalDevice.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalDevice.Builder addMainEntityOfPage(URL value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalDevice.Builder addMainEntityOfPage(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalDevice.Builder addMedicineSystem(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addName(Text value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalDevice.Builder addName(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addPostOp(Text value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/postOp", value);
        }

        @Override
        public MedicalDevice.Builder addPostOp(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/postOp", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addPotentialAction(Action value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalDevice.Builder addPotentialAction(Action.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalDevice.Builder addPotentialAction(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addPreOp(Text value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/preOp", value);
        }

        @Override
        public MedicalDevice.Builder addPreOp(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/preOp", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addProcedure(Text value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/procedure", value);
        }

        @Override
        public MedicalDevice.Builder addProcedure(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/procedure", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addPurpose(MedicalDevicePurpose value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/purpose", value);
        }

        @Override
        public MedicalDevice.Builder addPurpose(Thing value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/purpose", value);
        }

        @Override
        public MedicalDevice.Builder addPurpose(Thing.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/purpose", value.build());
        }

        @Override
        public MedicalDevice.Builder addPurpose(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/purpose", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addRecognizingAuthority(Organization value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalDevice.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalDevice.Builder addRecognizingAuthority(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalDevice.Builder addRelevantSpecialty(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addSameAs(URL value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalDevice.Builder addSameAs(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addSeriousAdverseOutcome(MedicalEntity value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value);
        }

        @Override
        public MedicalDevice.Builder addSeriousAdverseOutcome(MedicalEntity.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value.build());
        }

        @Override
        public MedicalDevice.Builder addSeriousAdverseOutcome(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addStudy(MedicalStudy value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalDevice.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalDevice.Builder addStudy(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addUrl(URL value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalDevice.Builder addUrl(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addDetailedDescription(Article value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalDevice.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalDevice.Builder addDetailedDescription(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalDevice.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalDevice.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalDevice.Builder addPopularityScore(String value) {
            return (MedicalDevice.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalDevice build() {
            return new MedicalDeviceImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

