/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalContraindicationImpl
extends MedicalEntityImpl
implements MedicalContraindication {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalContraindicationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalContraindicationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalContraindication";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalContraindication.Builder>
    implements MedicalContraindication.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalContraindication.Builder addAdditionalType(URL value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalContraindication.Builder addAdditionalType(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addAlternateName(Text value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalContraindication.Builder addAlternateName(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addCode(MedicalCode value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalContraindication.Builder addCode(MedicalCode.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalContraindication.Builder addCode(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addDescription(Text value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalContraindication.Builder addDescription(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addGuideline(MedicalGuideline value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalContraindication.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalContraindication.Builder addGuideline(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addImage(ImageObject value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalContraindication.Builder addImage(ImageObject.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalContraindication.Builder addImage(URL value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalContraindication.Builder addImage(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalContraindication.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalContraindication.Builder addMainEntityOfPage(URL value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalContraindication.Builder addMainEntityOfPage(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalContraindication.Builder addMedicineSystem(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addName(Text value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalContraindication.Builder addName(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addPotentialAction(Action value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalContraindication.Builder addPotentialAction(Action.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalContraindication.Builder addPotentialAction(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addRecognizingAuthority(Organization value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalContraindication.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalContraindication.Builder addRecognizingAuthority(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalContraindication.Builder addRelevantSpecialty(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addSameAs(URL value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalContraindication.Builder addSameAs(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addStudy(MedicalStudy value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalContraindication.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalContraindication.Builder addStudy(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addUrl(URL value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalContraindication.Builder addUrl(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addDetailedDescription(Article value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalContraindication.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalContraindication.Builder addDetailedDescription(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalContraindication.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalContraindication.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalContraindication.Builder addPopularityScore(String value) {
            return (MedicalContraindication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalContraindication build() {
            return new MedicalContraindicationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

