/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Country;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.GeoCoordinates;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class GeoCoordinatesImpl
extends StructuredValueImpl
implements GeoCoordinates {
    private static final ImmutableSet<String> PROPERTY_SET = GeoCoordinatesImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/address");
        builder.add((Object)"http://schema.org/addressCountry");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/elevation");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/latitude");
        builder.add((Object)"http://schema.org/longitude");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/postalCode");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public GeoCoordinatesImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/GeoCoordinates";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressList() {
        return this.getProperty("http://schema.org/address");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressCountryList() {
        return this.getProperty("http://schema.org/addressCountry");
    }

    @Override
    public ImmutableList<SchemaOrgType> getElevationList() {
        return this.getProperty("http://schema.org/elevation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLatitudeList() {
        return this.getProperty("http://schema.org/latitude");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLongitudeList() {
        return this.getProperty("http://schema.org/longitude");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPostalCodeList() {
        return this.getProperty("http://schema.org/postalCode");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<GeoCoordinates.Builder>
    implements GeoCoordinates.Builder {
        BuilderImpl() {
        }

        @Override
        public GeoCoordinates.Builder addAdditionalType(URL value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public GeoCoordinates.Builder addAdditionalType(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addAddress(PostalAddress value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/address", value);
        }

        @Override
        public GeoCoordinates.Builder addAddress(PostalAddress.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/address", value.build());
        }

        @Override
        public GeoCoordinates.Builder addAddress(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/address", value);
        }

        @Override
        public GeoCoordinates.Builder addAddress(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/address", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addAddressCountry(Country value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/addressCountry", value);
        }

        @Override
        public GeoCoordinates.Builder addAddressCountry(Country.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/addressCountry", value.build());
        }

        @Override
        public GeoCoordinates.Builder addAddressCountry(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/addressCountry", value);
        }

        @Override
        public GeoCoordinates.Builder addAddressCountry(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/addressCountry", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addAlternateName(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public GeoCoordinates.Builder addAlternateName(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addDescription(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public GeoCoordinates.Builder addDescription(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addElevation(Number value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/elevation", value);
        }

        @Override
        public GeoCoordinates.Builder addElevation(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/elevation", value);
        }

        @Override
        public GeoCoordinates.Builder addElevation(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/elevation", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addImage(ImageObject value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public GeoCoordinates.Builder addImage(ImageObject.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public GeoCoordinates.Builder addImage(URL value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public GeoCoordinates.Builder addImage(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addLatitude(Number value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/latitude", value);
        }

        @Override
        public GeoCoordinates.Builder addLatitude(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/latitude", value);
        }

        @Override
        public GeoCoordinates.Builder addLatitude(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/latitude", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addLongitude(Number value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/longitude", value);
        }

        @Override
        public GeoCoordinates.Builder addLongitude(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/longitude", value);
        }

        @Override
        public GeoCoordinates.Builder addLongitude(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/longitude", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addMainEntityOfPage(CreativeWork value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public GeoCoordinates.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public GeoCoordinates.Builder addMainEntityOfPage(URL value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public GeoCoordinates.Builder addMainEntityOfPage(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addName(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public GeoCoordinates.Builder addName(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addPostalCode(Text value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/postalCode", value);
        }

        @Override
        public GeoCoordinates.Builder addPostalCode(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/postalCode", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addPotentialAction(Action value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public GeoCoordinates.Builder addPotentialAction(Action.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public GeoCoordinates.Builder addPotentialAction(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addSameAs(URL value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public GeoCoordinates.Builder addSameAs(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addUrl(URL value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public GeoCoordinates.Builder addUrl(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addDetailedDescription(Article value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public GeoCoordinates.Builder addDetailedDescription(Article.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public GeoCoordinates.Builder addDetailedDescription(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public GeoCoordinates.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public GeoCoordinates.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public GeoCoordinates.Builder addPopularityScore(String value) {
            return (GeoCoordinates.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public GeoCoordinates build() {
            return new GeoCoordinatesImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

