/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Code;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class CodeImpl
extends CreativeWorkImpl
implements Code {
    private static final ImmutableSet<String> PROPERTY_SET = CodeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public CodeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Code";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Code.Builder>
    implements Code.Builder {
        BuilderImpl() {
        }

        @Override
        public Code.Builder addAbout(Thing value) {
            return (Code.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Code.Builder addAbout(Thing.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Code.Builder addAbout(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Code.Builder addAccessibilityAPI(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Code.Builder addAccessibilityAPI(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Code.Builder addAccessibilityControl(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Code.Builder addAccessibilityControl(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Code.Builder addAccessibilityFeature(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Code.Builder addAccessibilityFeature(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Code.Builder addAccessibilityHazard(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Code.Builder addAccessibilityHazard(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Code.Builder addAccountablePerson(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Code.Builder addAccountablePerson(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Code.Builder addAccountablePerson(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Code.Builder addAdditionalType(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Code.Builder addAdditionalType(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Code.Builder addAggregateRating(AggregateRating value) {
            return (Code.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Code.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Code.Builder addAggregateRating(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Code.Builder addAlternateName(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Code.Builder addAlternateName(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Code.Builder addAlternativeHeadline(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Code.Builder addAlternativeHeadline(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Code.Builder addAssociatedMedia(MediaObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Code.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Code.Builder addAssociatedMedia(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Code.Builder addAudience(Audience value) {
            return (Code.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Code.Builder addAudience(Audience.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Code.Builder addAudience(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Code.Builder addAudio(AudioObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Code.Builder addAudio(AudioObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Code.Builder addAudio(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Code.Builder addAuthor(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Code.Builder addAuthor(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Code.Builder addAuthor(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Code.Builder addAuthor(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Code.Builder addAuthor(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Code.Builder addAward(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Code.Builder addAward(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Code.Builder addAwards(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Code.Builder addAwards(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Code.Builder addCharacter(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Code.Builder addCharacter(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Code.Builder addCharacter(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Code.Builder addCitation(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Code.Builder addCitation(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Code.Builder addCitation(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Code.Builder addCitation(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Code.Builder addComment(Comment value) {
            return (Code.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Code.Builder addComment(Comment.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Code.Builder addComment(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Code.Builder addCommentCount(Integer value) {
            return (Code.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Code.Builder addCommentCount(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Code.Builder addContentLocation(Place value) {
            return (Code.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Code.Builder addContentLocation(Place.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Code.Builder addContentLocation(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Code.Builder addContentRating(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Code.Builder addContentRating(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Code.Builder addContributor(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Code.Builder addContributor(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Code.Builder addContributor(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Code.Builder addContributor(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Code.Builder addContributor(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Code.Builder addCopyrightHolder(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Code.Builder addCopyrightHolder(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Code.Builder addCopyrightHolder(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Code.Builder addCopyrightHolder(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Code.Builder addCopyrightHolder(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Code.Builder addCopyrightYear(Number value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Code.Builder addCopyrightYear(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Code.Builder addCreator(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Code.Builder addCreator(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Code.Builder addCreator(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Code.Builder addCreator(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Code.Builder addCreator(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Code.Builder addDateCreated(Date value) {
            return (Code.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Code.Builder addDateCreated(DateTime value) {
            return (Code.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Code.Builder addDateCreated(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Code.Builder addDateModified(Date value) {
            return (Code.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Code.Builder addDateModified(DateTime value) {
            return (Code.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Code.Builder addDateModified(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Code.Builder addDatePublished(Date value) {
            return (Code.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Code.Builder addDatePublished(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Code.Builder addDescription(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Code.Builder addDescription(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Code.Builder addDiscussionUrl(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Code.Builder addDiscussionUrl(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Code.Builder addEditor(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Code.Builder addEditor(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Code.Builder addEditor(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Code.Builder addEducationalAlignment(AlignmentObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Code.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Code.Builder addEducationalAlignment(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Code.Builder addEducationalUse(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Code.Builder addEducationalUse(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Code.Builder addEncoding(MediaObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Code.Builder addEncoding(MediaObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Code.Builder addEncoding(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Code.Builder addEncodings(MediaObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Code.Builder addEncodings(MediaObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Code.Builder addEncodings(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Code.Builder addExampleOfWork(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Code.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Code.Builder addExampleOfWork(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Code.Builder addFileFormat(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Code.Builder addFileFormat(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Code.Builder addGenre(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Code.Builder addGenre(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Code.Builder addGenre(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Code.Builder addHasPart(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Code.Builder addHasPart(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Code.Builder addHasPart(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Code.Builder addHeadline(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Code.Builder addHeadline(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Code.Builder addImage(ImageObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Code.Builder addImage(ImageObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Code.Builder addImage(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Code.Builder addImage(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Code.Builder addInLanguage(Language value) {
            return (Code.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Code.Builder addInLanguage(Language.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Code.Builder addInLanguage(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Code.Builder addInLanguage(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Code.Builder addInteractionStatistic(InteractionCounter value) {
            return (Code.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Code.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Code.Builder addInteractionStatistic(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Code.Builder addInteractivityType(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Code.Builder addInteractivityType(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Code.Builder addIsBasedOnUrl(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Code.Builder addIsBasedOnUrl(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Code.Builder addIsFamilyFriendly(Boolean value) {
            return (Code.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Code.Builder addIsFamilyFriendly(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Code.Builder addIsPartOf(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Code.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Code.Builder addIsPartOf(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Code.Builder addKeywords(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Code.Builder addKeywords(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Code.Builder addLearningResourceType(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Code.Builder addLearningResourceType(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Code.Builder addLicense(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Code.Builder addLicense(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Code.Builder addLicense(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Code.Builder addLicense(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Code.Builder addLocationCreated(Place value) {
            return (Code.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Code.Builder addLocationCreated(Place.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Code.Builder addLocationCreated(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Code.Builder addMainEntity(Thing value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Code.Builder addMainEntity(Thing.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Code.Builder addMainEntity(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Code.Builder addMainEntityOfPage(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Code.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Code.Builder addMainEntityOfPage(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Code.Builder addMainEntityOfPage(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Code.Builder addMentions(Thing value) {
            return (Code.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Code.Builder addMentions(Thing.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Code.Builder addMentions(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Code.Builder addName(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Code.Builder addName(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Code.Builder addOffers(Offer value) {
            return (Code.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Code.Builder addOffers(Offer.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Code.Builder addOffers(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Code.Builder addPosition(Integer value) {
            return (Code.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Code.Builder addPosition(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Code.Builder addPosition(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Code.Builder addPotentialAction(Action value) {
            return (Code.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Code.Builder addPotentialAction(Action.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Code.Builder addPotentialAction(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Code.Builder addProducer(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Code.Builder addProducer(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Code.Builder addProducer(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Code.Builder addProducer(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Code.Builder addProducer(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Code.Builder addProvider(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Code.Builder addProvider(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Code.Builder addProvider(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Code.Builder addProvider(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Code.Builder addProvider(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Code.Builder addPublication(PublicationEvent value) {
            return (Code.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Code.Builder addPublication(PublicationEvent.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Code.Builder addPublication(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Code.Builder addPublisher(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Code.Builder addPublisher(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Code.Builder addPublisher(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Code.Builder addPublisher(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Code.Builder addPublisher(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Code.Builder addPublishingPrinciples(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Code.Builder addPublishingPrinciples(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Code.Builder addRecordedAt(Event value) {
            return (Code.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Code.Builder addRecordedAt(Event.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Code.Builder addRecordedAt(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Code.Builder addReleasedEvent(PublicationEvent value) {
            return (Code.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Code.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Code.Builder addReleasedEvent(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Code.Builder addReview(Review value) {
            return (Code.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Code.Builder addReview(Review.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Code.Builder addReview(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Code.Builder addReviews(Review value) {
            return (Code.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Code.Builder addReviews(Review.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Code.Builder addReviews(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Code.Builder addSameAs(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Code.Builder addSameAs(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Code.Builder addSchemaVersion(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Code.Builder addSchemaVersion(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Code.Builder addSchemaVersion(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Code.Builder addSourceOrganization(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Code.Builder addSourceOrganization(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Code.Builder addSourceOrganization(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Code.Builder addText(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Code.Builder addText(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Code.Builder addThumbnailUrl(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Code.Builder addThumbnailUrl(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Code.Builder addTimeRequired(Duration value) {
            return (Code.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Code.Builder addTimeRequired(Duration.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Code.Builder addTimeRequired(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Code.Builder addTranslator(Organization value) {
            return (Code.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Code.Builder addTranslator(Organization.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Code.Builder addTranslator(Person value) {
            return (Code.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Code.Builder addTranslator(Person.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Code.Builder addTranslator(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Code.Builder addTypicalAgeRange(Text value) {
            return (Code.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Code.Builder addTypicalAgeRange(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Code.Builder addUrl(URL value) {
            return (Code.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Code.Builder addUrl(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Code.Builder addVersion(Number value) {
            return (Code.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Code.Builder addVersion(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Code.Builder addVideo(VideoObject value) {
            return (Code.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Code.Builder addVideo(VideoObject.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Code.Builder addVideo(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Code.Builder addWorkExample(CreativeWork value) {
            return (Code.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Code.Builder addWorkExample(CreativeWork.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Code.Builder addWorkExample(String value) {
            return (Code.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Code.Builder addDetailedDescription(Article value) {
            return (Code.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Code.Builder addDetailedDescription(Article.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Code.Builder addDetailedDescription(String value) {
            return (Code.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Code.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Code.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Code.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Code.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Code.Builder addPopularityScore(String value) {
            return (Code.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Code build() {
            return new CodeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

