/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BusStation;
import com.google.schemaorg.core.BusStop;
import com.google.schemaorg.core.BusTrip;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BusTripImpl
extends IntangibleImpl
implements BusTrip {
    private static final ImmutableSet<String> PROPERTY_SET = BusTripImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/arrivalBusStop");
        builder.add((Object)"http://schema.org/arrivalTime");
        builder.add((Object)"http://schema.org/busName");
        builder.add((Object)"http://schema.org/busNumber");
        builder.add((Object)"http://schema.org/departureBusStop");
        builder.add((Object)"http://schema.org/departureTime");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BusTripImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BusTrip";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalBusStopList() {
        return this.getProperty("http://schema.org/arrivalBusStop");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalTimeList() {
        return this.getProperty("http://schema.org/arrivalTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBusNameList() {
        return this.getProperty("http://schema.org/busName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBusNumberList() {
        return this.getProperty("http://schema.org/busNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureBusStopList() {
        return this.getProperty("http://schema.org/departureBusStop");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureTimeList() {
        return this.getProperty("http://schema.org/departureTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BusTrip.Builder>
    implements BusTrip.Builder {
        BuilderImpl() {
        }

        @Override
        public BusTrip.Builder addAdditionalType(URL value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BusTrip.Builder addAdditionalType(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BusTrip.Builder addAlternateName(Text value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BusTrip.Builder addAlternateName(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BusTrip.Builder addArrivalBusStop(BusStation value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalBusStop", value);
        }

        @Override
        public BusTrip.Builder addArrivalBusStop(BusStation.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalBusStop", value.build());
        }

        @Override
        public BusTrip.Builder addArrivalBusStop(BusStop value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalBusStop", value);
        }

        @Override
        public BusTrip.Builder addArrivalBusStop(BusStop.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalBusStop", value.build());
        }

        @Override
        public BusTrip.Builder addArrivalBusStop(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalBusStop", Text.of(value));
        }

        @Override
        public BusTrip.Builder addArrivalTime(DateTime value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalTime", value);
        }

        @Override
        public BusTrip.Builder addArrivalTime(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/arrivalTime", Text.of(value));
        }

        @Override
        public BusTrip.Builder addBusName(Text value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/busName", value);
        }

        @Override
        public BusTrip.Builder addBusName(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/busName", Text.of(value));
        }

        @Override
        public BusTrip.Builder addBusNumber(Text value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/busNumber", value);
        }

        @Override
        public BusTrip.Builder addBusNumber(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/busNumber", Text.of(value));
        }

        @Override
        public BusTrip.Builder addDepartureBusStop(BusStation value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureBusStop", value);
        }

        @Override
        public BusTrip.Builder addDepartureBusStop(BusStation.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureBusStop", value.build());
        }

        @Override
        public BusTrip.Builder addDepartureBusStop(BusStop value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureBusStop", value);
        }

        @Override
        public BusTrip.Builder addDepartureBusStop(BusStop.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureBusStop", value.build());
        }

        @Override
        public BusTrip.Builder addDepartureBusStop(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureBusStop", Text.of(value));
        }

        @Override
        public BusTrip.Builder addDepartureTime(DateTime value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureTime", value);
        }

        @Override
        public BusTrip.Builder addDepartureTime(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/departureTime", Text.of(value));
        }

        @Override
        public BusTrip.Builder addDescription(Text value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BusTrip.Builder addDescription(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BusTrip.Builder addImage(ImageObject value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BusTrip.Builder addImage(ImageObject.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BusTrip.Builder addImage(URL value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BusTrip.Builder addImage(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BusTrip.Builder addMainEntityOfPage(CreativeWork value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BusTrip.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BusTrip.Builder addMainEntityOfPage(URL value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BusTrip.Builder addMainEntityOfPage(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BusTrip.Builder addName(Text value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BusTrip.Builder addName(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BusTrip.Builder addPotentialAction(Action value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BusTrip.Builder addPotentialAction(Action.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BusTrip.Builder addPotentialAction(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BusTrip.Builder addProvider(Organization value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public BusTrip.Builder addProvider(Organization.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public BusTrip.Builder addProvider(Person value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public BusTrip.Builder addProvider(Person.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public BusTrip.Builder addProvider(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public BusTrip.Builder addSameAs(URL value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BusTrip.Builder addSameAs(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BusTrip.Builder addUrl(URL value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BusTrip.Builder addUrl(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BusTrip.Builder addDetailedDescription(Article value) {
            return (BusTrip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BusTrip.Builder addDetailedDescription(Article.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BusTrip.Builder addDetailedDescription(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BusTrip.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BusTrip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BusTrip.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BusTrip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BusTrip.Builder addPopularityScore(String value) {
            return (BusTrip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BusTrip build() {
            return new BusTripImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

