/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.goog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.StructuredValue;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PopularityScoreSpecificationImpl
extends IntangibleImpl
implements PopularityScoreSpecification {
    private static final ImmutableSet<String> PROPERTY_SET = PopularityScoreSpecificationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/eligibleRegion");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/value");
        builder.add((Object)"http://schema.googleapis.com/applicableKeywordOrGenre");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PopularityScoreSpecificationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.googleapis.com/PopularityScoreSpecification";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleRegionList() {
        return this.getProperty("http://schema.org/eligibleRegion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValueList() {
        return this.getProperty("http://schema.org/value");
    }

    @Override
    public ImmutableList<SchemaOrgType> getApplicableKeywordOrGenreList() {
        return this.getProperty("http://schema.googleapis.com/applicableKeywordOrGenre");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PopularityScoreSpecification.Builder>
    implements PopularityScoreSpecification.Builder {
        BuilderImpl() {
        }

        @Override
        public PopularityScoreSpecification.Builder addAdditionalType(URL value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addAdditionalType(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addAlternateName(Text value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addAlternateName(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addDescription(Text value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addDescription(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addEligibleRegion(GeoShape value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addEligibleRegion(GeoShape.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/eligibleRegion", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addEligibleRegion(Place value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addEligibleRegion(Place.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/eligibleRegion", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addEligibleRegion(Text value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addEligibleRegion(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/eligibleRegion", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addImage(ImageObject value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addImage(ImageObject.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addImage(URL value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addImage(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addMainEntityOfPage(CreativeWork value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addMainEntityOfPage(URL value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addMainEntityOfPage(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addName(Text value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addName(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addPotentialAction(Action value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addPotentialAction(Action.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addPotentialAction(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addSameAs(URL value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addSameAs(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addUrl(URL value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addUrl(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addValue(Boolean value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addValue(Number value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addValue(StructuredValue value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addValue(StructuredValue.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/value", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addValue(Text value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/value", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addValue(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.org/value", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addApplicableKeywordOrGenre(Text value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/applicableKeywordOrGenre", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addApplicableKeywordOrGenre(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/applicableKeywordOrGenre", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addDetailedDescription(Article value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addDetailedDescription(Article.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addDetailedDescription(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PopularityScoreSpecification.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PopularityScoreSpecification.Builder addPopularityScore(String value) {
            return (PopularityScoreSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PopularityScoreSpecification build() {
            return new PopularityScoreSpecificationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

