/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.goog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.EntitySearchResult;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EntitySearchResultImpl
extends IntangibleImpl
implements EntitySearchResult {
    private static final ImmutableSet<String> PROPERTY_SET = EntitySearchResultImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        builder.add((Object)"http://schema.googleapis.com/resultScore");
        return builder.build();
    }

    public EntitySearchResultImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.googleapis.com/EntitySearchResult";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getResultScoreList() {
        return this.getProperty("http://schema.googleapis.com/resultScore");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<EntitySearchResult.Builder>
    implements EntitySearchResult.Builder {
        BuilderImpl() {
        }

        @Override
        public EntitySearchResult.Builder addAdditionalType(URL value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public EntitySearchResult.Builder addAdditionalType(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addAlternateName(Text value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public EntitySearchResult.Builder addAlternateName(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addDescription(Text value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public EntitySearchResult.Builder addDescription(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addImage(ImageObject value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EntitySearchResult.Builder addImage(ImageObject.Builder value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public EntitySearchResult.Builder addImage(URL value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EntitySearchResult.Builder addImage(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addMainEntityOfPage(CreativeWork value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EntitySearchResult.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public EntitySearchResult.Builder addMainEntityOfPage(URL value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EntitySearchResult.Builder addMainEntityOfPage(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addName(Text value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public EntitySearchResult.Builder addName(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addPotentialAction(Action value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public EntitySearchResult.Builder addPotentialAction(Action.Builder value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public EntitySearchResult.Builder addPotentialAction(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addSameAs(URL value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public EntitySearchResult.Builder addSameAs(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addUrl(URL value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public EntitySearchResult.Builder addUrl(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addDetailedDescription(Article value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public EntitySearchResult.Builder addDetailedDescription(Article.Builder value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public EntitySearchResult.Builder addDetailedDescription(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public EntitySearchResult.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public EntitySearchResult.Builder addPopularityScore(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public EntitySearchResult.Builder addResultScore(Number value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/resultScore", value);
        }

        @Override
        public EntitySearchResult.Builder addResultScore(String value) {
            return (EntitySearchResult.Builder)this.addProperty("http://schema.googleapis.com/resultScore", Text.of(value));
        }

        @Override
        public EntitySearchResult build() {
            return new EntitySearchResultImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

