/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.BreadcrumbList;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Specialty;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.WebPage;
import com.google.schemaorg.core.WebPageElement;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class WebPageImpl
extends CreativeWorkImpl
implements WebPage {
    private static final ImmutableSet<String> PROPERTY_SET = WebPageImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/breadcrumb");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/lastReviewed");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainContentOfPage");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/primaryImageOfPage");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/relatedLink");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviewedBy");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/significantLink");
        builder.add((Object)"http://schema.org/significantLinks");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/specialty");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public WebPageImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/WebPage";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBreadcrumbList() {
        return this.getProperty("http://schema.org/breadcrumb");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLastReviewedList() {
        return this.getProperty("http://schema.org/lastReviewed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMainContentOfPageList() {
        return this.getProperty("http://schema.org/mainContentOfPage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrimaryImageOfPageList() {
        return this.getProperty("http://schema.org/primaryImageOfPage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedLinkList() {
        return this.getProperty("http://schema.org/relatedLink");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewedByList() {
        return this.getProperty("http://schema.org/reviewedBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSignificantLinkList() {
        return this.getProperty("http://schema.org/significantLink");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSignificantLinksList() {
        return this.getProperty("http://schema.org/significantLinks");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSpecialtyList() {
        return this.getProperty("http://schema.org/specialty");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<WebPage.Builder>
    implements WebPage.Builder {
        BuilderImpl() {
        }

        @Override
        public WebPage.Builder addAbout(Thing value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public WebPage.Builder addAbout(Thing.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public WebPage.Builder addAbout(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public WebPage.Builder addAccessibilityAPI(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public WebPage.Builder addAccessibilityAPI(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public WebPage.Builder addAccessibilityControl(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public WebPage.Builder addAccessibilityControl(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public WebPage.Builder addAccessibilityFeature(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public WebPage.Builder addAccessibilityFeature(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public WebPage.Builder addAccessibilityHazard(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public WebPage.Builder addAccessibilityHazard(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public WebPage.Builder addAccountablePerson(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public WebPage.Builder addAccountablePerson(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public WebPage.Builder addAccountablePerson(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public WebPage.Builder addAdditionalType(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public WebPage.Builder addAdditionalType(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public WebPage.Builder addAggregateRating(AggregateRating value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public WebPage.Builder addAggregateRating(AggregateRating.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public WebPage.Builder addAggregateRating(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public WebPage.Builder addAlternateName(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public WebPage.Builder addAlternateName(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public WebPage.Builder addAlternativeHeadline(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public WebPage.Builder addAlternativeHeadline(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public WebPage.Builder addAssociatedMedia(MediaObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public WebPage.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public WebPage.Builder addAssociatedMedia(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public WebPage.Builder addAudience(Audience value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public WebPage.Builder addAudience(Audience.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public WebPage.Builder addAudience(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public WebPage.Builder addAudio(AudioObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public WebPage.Builder addAudio(AudioObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public WebPage.Builder addAudio(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public WebPage.Builder addAuthor(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public WebPage.Builder addAuthor(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public WebPage.Builder addAuthor(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public WebPage.Builder addAuthor(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public WebPage.Builder addAuthor(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public WebPage.Builder addAward(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public WebPage.Builder addAward(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public WebPage.Builder addAwards(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public WebPage.Builder addAwards(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public WebPage.Builder addBreadcrumb(BreadcrumbList value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/breadcrumb", value);
        }

        @Override
        public WebPage.Builder addBreadcrumb(BreadcrumbList.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/breadcrumb", value.build());
        }

        @Override
        public WebPage.Builder addBreadcrumb(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/breadcrumb", value);
        }

        @Override
        public WebPage.Builder addBreadcrumb(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/breadcrumb", Text.of(value));
        }

        @Override
        public WebPage.Builder addCharacter(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public WebPage.Builder addCharacter(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public WebPage.Builder addCharacter(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public WebPage.Builder addCitation(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public WebPage.Builder addCitation(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public WebPage.Builder addCitation(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public WebPage.Builder addCitation(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public WebPage.Builder addComment(Comment value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public WebPage.Builder addComment(Comment.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public WebPage.Builder addComment(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public WebPage.Builder addCommentCount(Integer value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public WebPage.Builder addCommentCount(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public WebPage.Builder addContentLocation(Place value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public WebPage.Builder addContentLocation(Place.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public WebPage.Builder addContentLocation(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public WebPage.Builder addContentRating(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public WebPage.Builder addContentRating(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public WebPage.Builder addContributor(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public WebPage.Builder addContributor(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public WebPage.Builder addContributor(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public WebPage.Builder addContributor(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public WebPage.Builder addContributor(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public WebPage.Builder addCopyrightHolder(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public WebPage.Builder addCopyrightHolder(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public WebPage.Builder addCopyrightHolder(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public WebPage.Builder addCopyrightHolder(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public WebPage.Builder addCopyrightHolder(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public WebPage.Builder addCopyrightYear(Number value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public WebPage.Builder addCopyrightYear(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public WebPage.Builder addCreator(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public WebPage.Builder addCreator(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public WebPage.Builder addCreator(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public WebPage.Builder addCreator(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public WebPage.Builder addCreator(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public WebPage.Builder addDateCreated(Date value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public WebPage.Builder addDateCreated(DateTime value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public WebPage.Builder addDateCreated(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public WebPage.Builder addDateModified(Date value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public WebPage.Builder addDateModified(DateTime value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public WebPage.Builder addDateModified(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public WebPage.Builder addDatePublished(Date value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public WebPage.Builder addDatePublished(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public WebPage.Builder addDescription(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public WebPage.Builder addDescription(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public WebPage.Builder addDiscussionUrl(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public WebPage.Builder addDiscussionUrl(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public WebPage.Builder addEditor(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public WebPage.Builder addEditor(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public WebPage.Builder addEditor(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public WebPage.Builder addEducationalAlignment(AlignmentObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public WebPage.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public WebPage.Builder addEducationalAlignment(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public WebPage.Builder addEducationalUse(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public WebPage.Builder addEducationalUse(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public WebPage.Builder addEncoding(MediaObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public WebPage.Builder addEncoding(MediaObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public WebPage.Builder addEncoding(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public WebPage.Builder addEncodings(MediaObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public WebPage.Builder addEncodings(MediaObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public WebPage.Builder addEncodings(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public WebPage.Builder addExampleOfWork(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public WebPage.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public WebPage.Builder addExampleOfWork(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public WebPage.Builder addFileFormat(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public WebPage.Builder addFileFormat(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public WebPage.Builder addGenre(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public WebPage.Builder addGenre(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public WebPage.Builder addGenre(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public WebPage.Builder addHasPart(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public WebPage.Builder addHasPart(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public WebPage.Builder addHasPart(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public WebPage.Builder addHeadline(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public WebPage.Builder addHeadline(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public WebPage.Builder addImage(ImageObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public WebPage.Builder addImage(ImageObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public WebPage.Builder addImage(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public WebPage.Builder addImage(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public WebPage.Builder addInLanguage(Language value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public WebPage.Builder addInLanguage(Language.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public WebPage.Builder addInLanguage(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public WebPage.Builder addInLanguage(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public WebPage.Builder addInteractionStatistic(InteractionCounter value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public WebPage.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public WebPage.Builder addInteractionStatistic(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public WebPage.Builder addInteractivityType(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public WebPage.Builder addInteractivityType(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public WebPage.Builder addIsBasedOnUrl(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public WebPage.Builder addIsBasedOnUrl(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public WebPage.Builder addIsFamilyFriendly(Boolean value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public WebPage.Builder addIsFamilyFriendly(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public WebPage.Builder addIsPartOf(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public WebPage.Builder addIsPartOf(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public WebPage.Builder addIsPartOf(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public WebPage.Builder addKeywords(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public WebPage.Builder addKeywords(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public WebPage.Builder addLastReviewed(Date value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/lastReviewed", value);
        }

        @Override
        public WebPage.Builder addLastReviewed(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/lastReviewed", Text.of(value));
        }

        @Override
        public WebPage.Builder addLearningResourceType(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public WebPage.Builder addLearningResourceType(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public WebPage.Builder addLicense(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public WebPage.Builder addLicense(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public WebPage.Builder addLicense(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public WebPage.Builder addLicense(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public WebPage.Builder addLocationCreated(Place value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public WebPage.Builder addLocationCreated(Place.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public WebPage.Builder addLocationCreated(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public WebPage.Builder addMainContentOfPage(WebPageElement value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainContentOfPage", value);
        }

        @Override
        public WebPage.Builder addMainContentOfPage(WebPageElement.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainContentOfPage", value.build());
        }

        @Override
        public WebPage.Builder addMainContentOfPage(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainContentOfPage", Text.of(value));
        }

        @Override
        public WebPage.Builder addMainEntity(Thing value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public WebPage.Builder addMainEntity(Thing.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public WebPage.Builder addMainEntity(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public WebPage.Builder addMainEntityOfPage(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public WebPage.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public WebPage.Builder addMainEntityOfPage(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public WebPage.Builder addMainEntityOfPage(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public WebPage.Builder addMentions(Thing value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public WebPage.Builder addMentions(Thing.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public WebPage.Builder addMentions(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public WebPage.Builder addName(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public WebPage.Builder addName(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public WebPage.Builder addOffers(Offer value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public WebPage.Builder addOffers(Offer.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public WebPage.Builder addOffers(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public WebPage.Builder addPosition(Integer value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public WebPage.Builder addPosition(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public WebPage.Builder addPosition(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public WebPage.Builder addPotentialAction(Action value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public WebPage.Builder addPotentialAction(Action.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public WebPage.Builder addPotentialAction(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public WebPage.Builder addPrimaryImageOfPage(ImageObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/primaryImageOfPage", value);
        }

        @Override
        public WebPage.Builder addPrimaryImageOfPage(ImageObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/primaryImageOfPage", value.build());
        }

        @Override
        public WebPage.Builder addPrimaryImageOfPage(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/primaryImageOfPage", Text.of(value));
        }

        @Override
        public WebPage.Builder addProducer(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public WebPage.Builder addProducer(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public WebPage.Builder addProducer(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public WebPage.Builder addProducer(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public WebPage.Builder addProducer(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public WebPage.Builder addProvider(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public WebPage.Builder addProvider(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public WebPage.Builder addProvider(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public WebPage.Builder addProvider(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public WebPage.Builder addProvider(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public WebPage.Builder addPublication(PublicationEvent value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public WebPage.Builder addPublication(PublicationEvent.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public WebPage.Builder addPublication(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public WebPage.Builder addPublisher(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public WebPage.Builder addPublisher(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public WebPage.Builder addPublisher(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public WebPage.Builder addPublisher(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public WebPage.Builder addPublisher(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public WebPage.Builder addPublishingPrinciples(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public WebPage.Builder addPublishingPrinciples(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public WebPage.Builder addRecordedAt(Event value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public WebPage.Builder addRecordedAt(Event.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public WebPage.Builder addRecordedAt(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public WebPage.Builder addRelatedLink(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/relatedLink", value);
        }

        @Override
        public WebPage.Builder addRelatedLink(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/relatedLink", Text.of(value));
        }

        @Override
        public WebPage.Builder addReleasedEvent(PublicationEvent value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public WebPage.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public WebPage.Builder addReleasedEvent(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public WebPage.Builder addReview(Review value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public WebPage.Builder addReview(Review.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public WebPage.Builder addReview(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public WebPage.Builder addReviewedBy(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviewedBy", value);
        }

        @Override
        public WebPage.Builder addReviewedBy(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviewedBy", value.build());
        }

        @Override
        public WebPage.Builder addReviewedBy(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviewedBy", value);
        }

        @Override
        public WebPage.Builder addReviewedBy(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviewedBy", value.build());
        }

        @Override
        public WebPage.Builder addReviewedBy(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviewedBy", Text.of(value));
        }

        @Override
        public WebPage.Builder addReviews(Review value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public WebPage.Builder addReviews(Review.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public WebPage.Builder addReviews(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public WebPage.Builder addSameAs(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public WebPage.Builder addSameAs(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public WebPage.Builder addSchemaVersion(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public WebPage.Builder addSchemaVersion(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public WebPage.Builder addSchemaVersion(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public WebPage.Builder addSignificantLink(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/significantLink", value);
        }

        @Override
        public WebPage.Builder addSignificantLink(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/significantLink", Text.of(value));
        }

        @Override
        public WebPage.Builder addSignificantLinks(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/significantLinks", value);
        }

        @Override
        public WebPage.Builder addSignificantLinks(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/significantLinks", Text.of(value));
        }

        @Override
        public WebPage.Builder addSourceOrganization(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public WebPage.Builder addSourceOrganization(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public WebPage.Builder addSourceOrganization(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public WebPage.Builder addSpecialty(Specialty value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/specialty", value);
        }

        @Override
        public WebPage.Builder addSpecialty(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/specialty", Text.of(value));
        }

        @Override
        public WebPage.Builder addText(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public WebPage.Builder addText(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public WebPage.Builder addThumbnailUrl(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public WebPage.Builder addThumbnailUrl(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public WebPage.Builder addTimeRequired(Duration value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public WebPage.Builder addTimeRequired(Duration.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public WebPage.Builder addTimeRequired(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public WebPage.Builder addTranslator(Organization value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public WebPage.Builder addTranslator(Organization.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public WebPage.Builder addTranslator(Person value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public WebPage.Builder addTranslator(Person.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public WebPage.Builder addTranslator(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public WebPage.Builder addTypicalAgeRange(Text value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public WebPage.Builder addTypicalAgeRange(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public WebPage.Builder addUrl(URL value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public WebPage.Builder addUrl(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public WebPage.Builder addVersion(Number value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public WebPage.Builder addVersion(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public WebPage.Builder addVideo(VideoObject value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public WebPage.Builder addVideo(VideoObject.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public WebPage.Builder addVideo(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public WebPage.Builder addWorkExample(CreativeWork value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public WebPage.Builder addWorkExample(CreativeWork.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public WebPage.Builder addWorkExample(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public WebPage.Builder addDetailedDescription(Article value) {
            return (WebPage.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public WebPage.Builder addDetailedDescription(Article.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public WebPage.Builder addDetailedDescription(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public WebPage.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (WebPage.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public WebPage.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (WebPage.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public WebPage.Builder addPopularityScore(String value) {
            return (WebPage.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public WebPage build() {
            return new WebPageImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

