/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Distance;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.VisualArtwork;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class VisualArtworkImpl
extends CreativeWorkImpl
implements VisualArtwork {
    private static final ImmutableSet<String> PROPERTY_SET = VisualArtworkImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/artEdition");
        builder.add((Object)"http://schema.org/artform");
        builder.add((Object)"http://schema.org/artMedium");
        builder.add((Object)"http://schema.org/artworkSurface");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/depth");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/height");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/material");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/surface");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/width");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public VisualArtworkImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/VisualArtwork";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getArtEditionList() {
        return this.getProperty("http://schema.org/artEdition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArtformList() {
        return this.getProperty("http://schema.org/artform");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArtMediumList() {
        return this.getProperty("http://schema.org/artMedium");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArtworkSurfaceList() {
        return this.getProperty("http://schema.org/artworkSurface");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepthList() {
        return this.getProperty("http://schema.org/depth");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHeightList() {
        return this.getProperty("http://schema.org/height");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMaterialList() {
        return this.getProperty("http://schema.org/material");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSurfaceList() {
        return this.getProperty("http://schema.org/surface");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWidthList() {
        return this.getProperty("http://schema.org/width");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<VisualArtwork.Builder>
    implements VisualArtwork.Builder {
        BuilderImpl() {
        }

        @Override
        public VisualArtwork.Builder addAbout(Thing value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public VisualArtwork.Builder addAbout(Thing.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public VisualArtwork.Builder addAbout(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAccessibilityAPI(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public VisualArtwork.Builder addAccessibilityAPI(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAccessibilityControl(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public VisualArtwork.Builder addAccessibilityControl(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAccessibilityFeature(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public VisualArtwork.Builder addAccessibilityFeature(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAccessibilityHazard(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public VisualArtwork.Builder addAccessibilityHazard(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAccountablePerson(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public VisualArtwork.Builder addAccountablePerson(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public VisualArtwork.Builder addAccountablePerson(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAdditionalType(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public VisualArtwork.Builder addAdditionalType(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAggregateRating(AggregateRating value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public VisualArtwork.Builder addAggregateRating(AggregateRating.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public VisualArtwork.Builder addAggregateRating(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAlternateName(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public VisualArtwork.Builder addAlternateName(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAlternativeHeadline(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public VisualArtwork.Builder addAlternativeHeadline(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addArtEdition(Integer value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artEdition", value);
        }

        @Override
        public VisualArtwork.Builder addArtEdition(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artEdition", value);
        }

        @Override
        public VisualArtwork.Builder addArtEdition(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artEdition", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addArtform(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artform", value);
        }

        @Override
        public VisualArtwork.Builder addArtform(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artform", value);
        }

        @Override
        public VisualArtwork.Builder addArtform(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artform", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addArtMedium(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artMedium", value);
        }

        @Override
        public VisualArtwork.Builder addArtMedium(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artMedium", value);
        }

        @Override
        public VisualArtwork.Builder addArtMedium(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artMedium", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addArtworkSurface(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artworkSurface", value);
        }

        @Override
        public VisualArtwork.Builder addArtworkSurface(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artworkSurface", value);
        }

        @Override
        public VisualArtwork.Builder addArtworkSurface(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/artworkSurface", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAssociatedMedia(MediaObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public VisualArtwork.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public VisualArtwork.Builder addAssociatedMedia(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAudience(Audience value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public VisualArtwork.Builder addAudience(Audience.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public VisualArtwork.Builder addAudience(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAudio(AudioObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public VisualArtwork.Builder addAudio(AudioObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public VisualArtwork.Builder addAudio(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAuthor(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public VisualArtwork.Builder addAuthor(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public VisualArtwork.Builder addAuthor(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public VisualArtwork.Builder addAuthor(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public VisualArtwork.Builder addAuthor(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAward(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public VisualArtwork.Builder addAward(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addAwards(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public VisualArtwork.Builder addAwards(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addCharacter(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public VisualArtwork.Builder addCharacter(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public VisualArtwork.Builder addCharacter(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addCitation(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public VisualArtwork.Builder addCitation(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public VisualArtwork.Builder addCitation(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public VisualArtwork.Builder addCitation(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addComment(Comment value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public VisualArtwork.Builder addComment(Comment.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public VisualArtwork.Builder addComment(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addCommentCount(Integer value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public VisualArtwork.Builder addCommentCount(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addContentLocation(Place value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public VisualArtwork.Builder addContentLocation(Place.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public VisualArtwork.Builder addContentLocation(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addContentRating(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public VisualArtwork.Builder addContentRating(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addContributor(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public VisualArtwork.Builder addContributor(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public VisualArtwork.Builder addContributor(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public VisualArtwork.Builder addContributor(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public VisualArtwork.Builder addContributor(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addCopyrightHolder(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public VisualArtwork.Builder addCopyrightHolder(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public VisualArtwork.Builder addCopyrightHolder(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public VisualArtwork.Builder addCopyrightHolder(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public VisualArtwork.Builder addCopyrightHolder(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addCopyrightYear(Number value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public VisualArtwork.Builder addCopyrightYear(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addCreator(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public VisualArtwork.Builder addCreator(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public VisualArtwork.Builder addCreator(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public VisualArtwork.Builder addCreator(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public VisualArtwork.Builder addCreator(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDateCreated(Date value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public VisualArtwork.Builder addDateCreated(DateTime value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public VisualArtwork.Builder addDateCreated(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDateModified(Date value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public VisualArtwork.Builder addDateModified(DateTime value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public VisualArtwork.Builder addDateModified(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDatePublished(Date value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public VisualArtwork.Builder addDatePublished(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDepth(Distance value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/depth", value);
        }

        @Override
        public VisualArtwork.Builder addDepth(Distance.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/depth", value.build());
        }

        @Override
        public VisualArtwork.Builder addDepth(QuantitativeValue value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/depth", value);
        }

        @Override
        public VisualArtwork.Builder addDepth(QuantitativeValue.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/depth", value.build());
        }

        @Override
        public VisualArtwork.Builder addDepth(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/depth", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDescription(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public VisualArtwork.Builder addDescription(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDiscussionUrl(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public VisualArtwork.Builder addDiscussionUrl(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addEditor(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public VisualArtwork.Builder addEditor(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public VisualArtwork.Builder addEditor(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addEducationalAlignment(AlignmentObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public VisualArtwork.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public VisualArtwork.Builder addEducationalAlignment(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addEducationalUse(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public VisualArtwork.Builder addEducationalUse(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addEncoding(MediaObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public VisualArtwork.Builder addEncoding(MediaObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public VisualArtwork.Builder addEncoding(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addEncodings(MediaObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public VisualArtwork.Builder addEncodings(MediaObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public VisualArtwork.Builder addEncodings(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addExampleOfWork(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public VisualArtwork.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public VisualArtwork.Builder addExampleOfWork(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addFileFormat(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public VisualArtwork.Builder addFileFormat(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addGenre(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public VisualArtwork.Builder addGenre(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public VisualArtwork.Builder addGenre(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addHasPart(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public VisualArtwork.Builder addHasPart(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public VisualArtwork.Builder addHasPart(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addHeadline(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public VisualArtwork.Builder addHeadline(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addHeight(Distance value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public VisualArtwork.Builder addHeight(Distance.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public VisualArtwork.Builder addHeight(QuantitativeValue value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public VisualArtwork.Builder addHeight(QuantitativeValue.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public VisualArtwork.Builder addHeight(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/height", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addImage(ImageObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public VisualArtwork.Builder addImage(ImageObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public VisualArtwork.Builder addImage(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public VisualArtwork.Builder addImage(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addInLanguage(Language value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public VisualArtwork.Builder addInLanguage(Language.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public VisualArtwork.Builder addInLanguage(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public VisualArtwork.Builder addInLanguage(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addInteractionStatistic(InteractionCounter value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public VisualArtwork.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public VisualArtwork.Builder addInteractionStatistic(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addInteractivityType(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public VisualArtwork.Builder addInteractivityType(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addIsBasedOnUrl(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public VisualArtwork.Builder addIsBasedOnUrl(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addIsFamilyFriendly(Boolean value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public VisualArtwork.Builder addIsFamilyFriendly(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addIsPartOf(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public VisualArtwork.Builder addIsPartOf(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public VisualArtwork.Builder addIsPartOf(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addKeywords(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public VisualArtwork.Builder addKeywords(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addLearningResourceType(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public VisualArtwork.Builder addLearningResourceType(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addLicense(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public VisualArtwork.Builder addLicense(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public VisualArtwork.Builder addLicense(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public VisualArtwork.Builder addLicense(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addLocationCreated(Place value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public VisualArtwork.Builder addLocationCreated(Place.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public VisualArtwork.Builder addLocationCreated(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addMainEntity(Thing value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public VisualArtwork.Builder addMainEntity(Thing.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public VisualArtwork.Builder addMainEntity(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addMainEntityOfPage(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public VisualArtwork.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public VisualArtwork.Builder addMainEntityOfPage(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public VisualArtwork.Builder addMainEntityOfPage(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addMaterial(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/material", value);
        }

        @Override
        public VisualArtwork.Builder addMaterial(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/material", value);
        }

        @Override
        public VisualArtwork.Builder addMaterial(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/material", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addMentions(Thing value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public VisualArtwork.Builder addMentions(Thing.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public VisualArtwork.Builder addMentions(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addName(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public VisualArtwork.Builder addName(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addOffers(Offer value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public VisualArtwork.Builder addOffers(Offer.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public VisualArtwork.Builder addOffers(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addPosition(Integer value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public VisualArtwork.Builder addPosition(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public VisualArtwork.Builder addPosition(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addPotentialAction(Action value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public VisualArtwork.Builder addPotentialAction(Action.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public VisualArtwork.Builder addPotentialAction(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addProducer(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public VisualArtwork.Builder addProducer(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public VisualArtwork.Builder addProducer(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public VisualArtwork.Builder addProducer(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public VisualArtwork.Builder addProducer(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addProvider(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public VisualArtwork.Builder addProvider(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public VisualArtwork.Builder addProvider(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public VisualArtwork.Builder addProvider(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public VisualArtwork.Builder addProvider(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addPublication(PublicationEvent value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public VisualArtwork.Builder addPublication(PublicationEvent.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public VisualArtwork.Builder addPublication(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addPublisher(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public VisualArtwork.Builder addPublisher(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public VisualArtwork.Builder addPublisher(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public VisualArtwork.Builder addPublisher(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public VisualArtwork.Builder addPublisher(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addPublishingPrinciples(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public VisualArtwork.Builder addPublishingPrinciples(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addRecordedAt(Event value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public VisualArtwork.Builder addRecordedAt(Event.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public VisualArtwork.Builder addRecordedAt(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addReleasedEvent(PublicationEvent value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public VisualArtwork.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public VisualArtwork.Builder addReleasedEvent(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addReview(Review value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public VisualArtwork.Builder addReview(Review.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public VisualArtwork.Builder addReview(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addReviews(Review value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public VisualArtwork.Builder addReviews(Review.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public VisualArtwork.Builder addReviews(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addSameAs(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public VisualArtwork.Builder addSameAs(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addSchemaVersion(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public VisualArtwork.Builder addSchemaVersion(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public VisualArtwork.Builder addSchemaVersion(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addSourceOrganization(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public VisualArtwork.Builder addSourceOrganization(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public VisualArtwork.Builder addSourceOrganization(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addSurface(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/surface", value);
        }

        @Override
        public VisualArtwork.Builder addSurface(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/surface", value);
        }

        @Override
        public VisualArtwork.Builder addSurface(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/surface", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addText(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public VisualArtwork.Builder addText(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addThumbnailUrl(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public VisualArtwork.Builder addThumbnailUrl(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addTimeRequired(Duration value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public VisualArtwork.Builder addTimeRequired(Duration.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public VisualArtwork.Builder addTimeRequired(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addTranslator(Organization value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public VisualArtwork.Builder addTranslator(Organization.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public VisualArtwork.Builder addTranslator(Person value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public VisualArtwork.Builder addTranslator(Person.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public VisualArtwork.Builder addTranslator(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addTypicalAgeRange(Text value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public VisualArtwork.Builder addTypicalAgeRange(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addUrl(URL value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public VisualArtwork.Builder addUrl(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addVersion(Number value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public VisualArtwork.Builder addVersion(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addVideo(VideoObject value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public VisualArtwork.Builder addVideo(VideoObject.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public VisualArtwork.Builder addVideo(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addWidth(Distance value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public VisualArtwork.Builder addWidth(Distance.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public VisualArtwork.Builder addWidth(QuantitativeValue value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public VisualArtwork.Builder addWidth(QuantitativeValue.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public VisualArtwork.Builder addWidth(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/width", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addWorkExample(CreativeWork value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public VisualArtwork.Builder addWorkExample(CreativeWork.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public VisualArtwork.Builder addWorkExample(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addDetailedDescription(Article value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public VisualArtwork.Builder addDetailedDescription(Article.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public VisualArtwork.Builder addDetailedDescription(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public VisualArtwork.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public VisualArtwork.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public VisualArtwork.Builder addPopularityScore(String value) {
            return (VisualArtwork.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public VisualArtwork build() {
            return new VisualArtworkImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

