/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BusinessFunction;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.TypeAndQuantityNode;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TypeAndQuantityNodeImpl
extends StructuredValueImpl
implements TypeAndQuantityNode {
    private static final ImmutableSet<String> PROPERTY_SET = TypeAndQuantityNodeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/amountOfThisGood");
        builder.add((Object)"http://schema.org/businessFunction");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/typeOfGood");
        builder.add((Object)"http://schema.org/unitCode");
        builder.add((Object)"http://schema.org/unitText");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TypeAndQuantityNodeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/TypeAndQuantityNode";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAmountOfThisGoodList() {
        return this.getProperty("http://schema.org/amountOfThisGood");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBusinessFunctionList() {
        return this.getProperty("http://schema.org/businessFunction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTypeOfGoodList() {
        return this.getProperty("http://schema.org/typeOfGood");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnitCodeList() {
        return this.getProperty("http://schema.org/unitCode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnitTextList() {
        return this.getProperty("http://schema.org/unitText");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<TypeAndQuantityNode.Builder>
    implements TypeAndQuantityNode.Builder {
        BuilderImpl() {
        }

        @Override
        public TypeAndQuantityNode.Builder addAdditionalType(URL value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addAdditionalType(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addAlternateName(Text value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addAlternateName(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addAmountOfThisGood(Number value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/amountOfThisGood", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addAmountOfThisGood(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/amountOfThisGood", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addBusinessFunction(BusinessFunction value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/businessFunction", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addBusinessFunction(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/businessFunction", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addDescription(Text value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addDescription(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addImage(ImageObject value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addImage(ImageObject.Builder value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public TypeAndQuantityNode.Builder addImage(URL value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addImage(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addMainEntityOfPage(CreativeWork value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public TypeAndQuantityNode.Builder addMainEntityOfPage(URL value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addMainEntityOfPage(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addName(Text value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addName(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addPotentialAction(Action value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addPotentialAction(Action.Builder value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public TypeAndQuantityNode.Builder addPotentialAction(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addSameAs(URL value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addSameAs(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addTypeOfGood(Product value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/typeOfGood", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addTypeOfGood(Product.Builder value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/typeOfGood", value.build());
        }

        @Override
        public TypeAndQuantityNode.Builder addTypeOfGood(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/typeOfGood", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addUnitCode(Text value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/unitCode", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addUnitCode(URL value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/unitCode", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addUnitCode(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/unitCode", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addUnitText(Text value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/unitText", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addUnitText(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/unitText", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addUrl(URL value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addUrl(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addDetailedDescription(Article value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addDetailedDescription(Article.Builder value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public TypeAndQuantityNode.Builder addDetailedDescription(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public TypeAndQuantityNode.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public TypeAndQuantityNode.Builder addPopularityScore(String value) {
            return (TypeAndQuantityNode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public TypeAndQuantityNode build() {
            return new TypeAndQuantityNodeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

