/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.PriceSpecification;
import com.google.schemaorg.core.Seat;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.Ticket;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TicketImpl
extends IntangibleImpl
implements Ticket {
    private static final ImmutableSet<String> PROPERTY_SET = TicketImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/dateIssued");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/issuedBy");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/priceCurrency");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/ticketedSeat");
        builder.add((Object)"http://schema.org/ticketNumber");
        builder.add((Object)"http://schema.org/ticketToken");
        builder.add((Object)"http://schema.org/totalPrice");
        builder.add((Object)"http://schema.org/underName");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TicketImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Ticket";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDateIssuedList() {
        return this.getProperty("http://schema.org/dateIssued");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIssuedByList() {
        return this.getProperty("http://schema.org/issuedBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceCurrencyList() {
        return this.getProperty("http://schema.org/priceCurrency");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTicketedSeatList() {
        return this.getProperty("http://schema.org/ticketedSeat");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTicketNumberList() {
        return this.getProperty("http://schema.org/ticketNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTicketTokenList() {
        return this.getProperty("http://schema.org/ticketToken");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTotalPriceList() {
        return this.getProperty("http://schema.org/totalPrice");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnderNameList() {
        return this.getProperty("http://schema.org/underName");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Ticket.Builder>
    implements Ticket.Builder {
        BuilderImpl() {
        }

        @Override
        public Ticket.Builder addAdditionalType(URL value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Ticket.Builder addAdditionalType(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Ticket.Builder addAlternateName(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Ticket.Builder addAlternateName(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Ticket.Builder addDateIssued(DateTime value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/dateIssued", value);
        }

        @Override
        public Ticket.Builder addDateIssued(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/dateIssued", Text.of(value));
        }

        @Override
        public Ticket.Builder addDescription(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Ticket.Builder addDescription(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Ticket.Builder addImage(ImageObject value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Ticket.Builder addImage(ImageObject.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Ticket.Builder addImage(URL value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Ticket.Builder addImage(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Ticket.Builder addIssuedBy(Organization value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/issuedBy", value);
        }

        @Override
        public Ticket.Builder addIssuedBy(Organization.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/issuedBy", value.build());
        }

        @Override
        public Ticket.Builder addIssuedBy(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/issuedBy", Text.of(value));
        }

        @Override
        public Ticket.Builder addMainEntityOfPage(CreativeWork value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Ticket.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Ticket.Builder addMainEntityOfPage(URL value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Ticket.Builder addMainEntityOfPage(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Ticket.Builder addName(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Ticket.Builder addName(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Ticket.Builder addPotentialAction(Action value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Ticket.Builder addPotentialAction(Action.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Ticket.Builder addPotentialAction(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Ticket.Builder addPriceCurrency(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/priceCurrency", value);
        }

        @Override
        public Ticket.Builder addPriceCurrency(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/priceCurrency", Text.of(value));
        }

        @Override
        public Ticket.Builder addSameAs(URL value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Ticket.Builder addSameAs(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Ticket.Builder addTicketedSeat(Seat value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketedSeat", value);
        }

        @Override
        public Ticket.Builder addTicketedSeat(Seat.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketedSeat", value.build());
        }

        @Override
        public Ticket.Builder addTicketedSeat(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketedSeat", Text.of(value));
        }

        @Override
        public Ticket.Builder addTicketNumber(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketNumber", value);
        }

        @Override
        public Ticket.Builder addTicketNumber(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketNumber", Text.of(value));
        }

        @Override
        public Ticket.Builder addTicketToken(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketToken", value);
        }

        @Override
        public Ticket.Builder addTicketToken(URL value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketToken", value);
        }

        @Override
        public Ticket.Builder addTicketToken(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/ticketToken", Text.of(value));
        }

        @Override
        public Ticket.Builder addTotalPrice(Number value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/totalPrice", value);
        }

        @Override
        public Ticket.Builder addTotalPrice(PriceSpecification value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/totalPrice", value);
        }

        @Override
        public Ticket.Builder addTotalPrice(PriceSpecification.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/totalPrice", value.build());
        }

        @Override
        public Ticket.Builder addTotalPrice(Text value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/totalPrice", value);
        }

        @Override
        public Ticket.Builder addTotalPrice(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/totalPrice", Text.of(value));
        }

        @Override
        public Ticket.Builder addUnderName(Organization value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/underName", value);
        }

        @Override
        public Ticket.Builder addUnderName(Organization.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/underName", value.build());
        }

        @Override
        public Ticket.Builder addUnderName(Person value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/underName", value);
        }

        @Override
        public Ticket.Builder addUnderName(Person.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/underName", value.build());
        }

        @Override
        public Ticket.Builder addUnderName(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/underName", Text.of(value));
        }

        @Override
        public Ticket.Builder addUrl(URL value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Ticket.Builder addUrl(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Ticket.Builder addDetailedDescription(Article value) {
            return (Ticket.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Ticket.Builder addDetailedDescription(Article.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Ticket.Builder addDetailedDescription(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Ticket.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Ticket.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Ticket.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Ticket.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Ticket.Builder addPopularityScore(String value) {
            return (Ticket.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Ticket build() {
            return new TicketImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

