/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ThingImpl
extends SchemaOrgTypeImpl
implements Thing {
    private static final ImmutableSet<String> PROPERTY_SET = ThingImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ThingImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Thing";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdditionalTypeList() {
        return this.getProperty("http://schema.org/additionalType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlternateNameList() {
        return this.getProperty("http://schema.org/alternateName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDescriptionList() {
        return this.getProperty("http://schema.org/description");
    }

    @Override
    public ImmutableList<SchemaOrgType> getImageList() {
        return this.getProperty("http://schema.org/image");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMainEntityOfPageList() {
        return this.getProperty("http://schema.org/mainEntityOfPage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNameList() {
        return this.getProperty("http://schema.org/name");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPotentialActionList() {
        return this.getProperty("http://schema.org/potentialAction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSameAsList() {
        return this.getProperty("http://schema.org/sameAs");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUrlList() {
        return this.getProperty("http://schema.org/url");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDetailedDescriptionList() {
        return this.getProperty("http://schema.googleapis.com/detailedDescription");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPopularityScoreList() {
        return this.getProperty("http://schema.googleapis.com/popularityScore");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Thing.Builder>
    implements Thing.Builder {
        BuilderImpl() {
        }

        @Override
        public Thing.Builder addAdditionalType(URL value) {
            return (Thing.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Thing.Builder addAdditionalType(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Thing.Builder addAlternateName(Text value) {
            return (Thing.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Thing.Builder addAlternateName(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Thing.Builder addDescription(Text value) {
            return (Thing.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Thing.Builder addDescription(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Thing.Builder addImage(ImageObject value) {
            return (Thing.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Thing.Builder addImage(ImageObject.Builder value) {
            return (Thing.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Thing.Builder addImage(URL value) {
            return (Thing.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Thing.Builder addImage(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Thing.Builder addMainEntityOfPage(CreativeWork value) {
            return (Thing.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Thing.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Thing.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Thing.Builder addMainEntityOfPage(URL value) {
            return (Thing.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Thing.Builder addMainEntityOfPage(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Thing.Builder addName(Text value) {
            return (Thing.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Thing.Builder addName(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Thing.Builder addPotentialAction(Action value) {
            return (Thing.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Thing.Builder addPotentialAction(Action.Builder value) {
            return (Thing.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Thing.Builder addPotentialAction(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Thing.Builder addSameAs(URL value) {
            return (Thing.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Thing.Builder addSameAs(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Thing.Builder addUrl(URL value) {
            return (Thing.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Thing.Builder addUrl(String value) {
            return (Thing.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Thing.Builder addDetailedDescription(Article value) {
            return (Thing.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Thing.Builder addDetailedDescription(Article.Builder value) {
            return (Thing.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Thing.Builder addDetailedDescription(String value) {
            return (Thing.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Thing.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Thing.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Thing.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Thing.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Thing.Builder addPopularityScore(String value) {
            return (Thing.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Thing build() {
            return new ThingImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

