/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalProcedureImpl;
import com.google.schemaorg.core.MedicalProcedureType;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.TherapeuticProcedure;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TherapeuticProcedureImpl
extends MedicalProcedureImpl
implements TherapeuticProcedure {
    private static final ImmutableSet<String> PROPERTY_SET = TherapeuticProcedureImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/adverseOutcome");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/contraindication");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/duplicateTherapy");
        builder.add((Object)"http://schema.org/followup");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/howPerformed");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/indication");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/preparation");
        builder.add((Object)"http://schema.org/procedureType");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seriousAdverseOutcome");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TherapeuticProcedureImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/TherapeuticProcedure";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdverseOutcomeList() {
        return this.getProperty("http://schema.org/adverseOutcome");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContraindicationList() {
        return this.getProperty("http://schema.org/contraindication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDuplicateTherapyList() {
        return this.getProperty("http://schema.org/duplicateTherapy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIndicationList() {
        return this.getProperty("http://schema.org/indication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeriousAdverseOutcomeList() {
        return this.getProperty("http://schema.org/seriousAdverseOutcome");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<TherapeuticProcedure.Builder>
    implements TherapeuticProcedure.Builder {
        BuilderImpl() {
        }

        @Override
        public TherapeuticProcedure.Builder addAdditionalType(URL value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public TherapeuticProcedure.Builder addAdditionalType(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addAdverseOutcome(MedicalEntity value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/adverseOutcome", value);
        }

        @Override
        public TherapeuticProcedure.Builder addAdverseOutcome(MedicalEntity.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/adverseOutcome", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addAdverseOutcome(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/adverseOutcome", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addAlternateName(Text value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public TherapeuticProcedure.Builder addAlternateName(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addCode(MedicalCode value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public TherapeuticProcedure.Builder addCode(MedicalCode.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addCode(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addContraindication(MedicalContraindication value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/contraindication", value);
        }

        @Override
        public TherapeuticProcedure.Builder addContraindication(MedicalContraindication.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/contraindication", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addContraindication(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/contraindication", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addDescription(Text value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public TherapeuticProcedure.Builder addDescription(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addDuplicateTherapy(MedicalTherapy value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/duplicateTherapy", value);
        }

        @Override
        public TherapeuticProcedure.Builder addDuplicateTherapy(MedicalTherapy.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/duplicateTherapy", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addDuplicateTherapy(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/duplicateTherapy", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addFollowup(Text value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/followup", value);
        }

        @Override
        public TherapeuticProcedure.Builder addFollowup(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/followup", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addGuideline(MedicalGuideline value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public TherapeuticProcedure.Builder addGuideline(MedicalGuideline.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addGuideline(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addHowPerformed(Text value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/howPerformed", value);
        }

        @Override
        public TherapeuticProcedure.Builder addHowPerformed(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/howPerformed", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addImage(ImageObject value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TherapeuticProcedure.Builder addImage(ImageObject.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addImage(URL value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TherapeuticProcedure.Builder addImage(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addIndication(MedicalIndication value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/indication", value);
        }

        @Override
        public TherapeuticProcedure.Builder addIndication(MedicalIndication.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/indication", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addIndication(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/indication", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addMainEntityOfPage(CreativeWork value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TherapeuticProcedure.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addMainEntityOfPage(URL value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TherapeuticProcedure.Builder addMainEntityOfPage(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addMedicineSystem(MedicineSystem value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public TherapeuticProcedure.Builder addMedicineSystem(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addName(Text value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public TherapeuticProcedure.Builder addName(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addPotentialAction(Action value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public TherapeuticProcedure.Builder addPotentialAction(Action.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addPotentialAction(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addPreparation(Text value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/preparation", value);
        }

        @Override
        public TherapeuticProcedure.Builder addPreparation(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/preparation", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addProcedureType(MedicalProcedureType value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/procedureType", value);
        }

        @Override
        public TherapeuticProcedure.Builder addProcedureType(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/procedureType", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addRecognizingAuthority(Organization value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public TherapeuticProcedure.Builder addRecognizingAuthority(Organization.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addRecognizingAuthority(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public TherapeuticProcedure.Builder addRelevantSpecialty(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addSameAs(URL value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public TherapeuticProcedure.Builder addSameAs(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addSeriousAdverseOutcome(MedicalEntity value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value);
        }

        @Override
        public TherapeuticProcedure.Builder addSeriousAdverseOutcome(MedicalEntity.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addSeriousAdverseOutcome(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addStudy(MedicalStudy value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public TherapeuticProcedure.Builder addStudy(MedicalStudy.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addStudy(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addUrl(URL value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public TherapeuticProcedure.Builder addUrl(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addDetailedDescription(Article value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public TherapeuticProcedure.Builder addDetailedDescription(Article.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addDetailedDescription(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public TherapeuticProcedure.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public TherapeuticProcedure.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public TherapeuticProcedure.Builder addPopularityScore(String value) {
            return (TherapeuticProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public TherapeuticProcedure build() {
            return new TherapeuticProcedureImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

