/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Rating;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ReviewImpl
extends CreativeWorkImpl
implements Review {
    private static final ImmutableSet<String> PROPERTY_SET = ReviewImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/itemReviewed");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviewBody");
        builder.add((Object)"http://schema.org/reviewRating");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ReviewImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Review";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemReviewedList() {
        return this.getProperty("http://schema.org/itemReviewed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewBodyList() {
        return this.getProperty("http://schema.org/reviewBody");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewRatingList() {
        return this.getProperty("http://schema.org/reviewRating");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Review.Builder>
    implements Review.Builder {
        BuilderImpl() {
        }

        @Override
        public Review.Builder addAbout(Thing value) {
            return (Review.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Review.Builder addAbout(Thing.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Review.Builder addAbout(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Review.Builder addAccessibilityAPI(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Review.Builder addAccessibilityAPI(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Review.Builder addAccessibilityControl(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Review.Builder addAccessibilityControl(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Review.Builder addAccessibilityFeature(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Review.Builder addAccessibilityFeature(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Review.Builder addAccessibilityHazard(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Review.Builder addAccessibilityHazard(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Review.Builder addAccountablePerson(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Review.Builder addAccountablePerson(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Review.Builder addAccountablePerson(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Review.Builder addAdditionalType(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Review.Builder addAdditionalType(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Review.Builder addAggregateRating(AggregateRating value) {
            return (Review.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Review.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Review.Builder addAggregateRating(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Review.Builder addAlternateName(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Review.Builder addAlternateName(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Review.Builder addAlternativeHeadline(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Review.Builder addAlternativeHeadline(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Review.Builder addAssociatedMedia(MediaObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Review.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Review.Builder addAssociatedMedia(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Review.Builder addAudience(Audience value) {
            return (Review.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Review.Builder addAudience(Audience.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Review.Builder addAudience(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Review.Builder addAudio(AudioObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Review.Builder addAudio(AudioObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Review.Builder addAudio(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Review.Builder addAuthor(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Review.Builder addAuthor(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Review.Builder addAuthor(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Review.Builder addAuthor(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Review.Builder addAuthor(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Review.Builder addAward(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Review.Builder addAward(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Review.Builder addAwards(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Review.Builder addAwards(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Review.Builder addCharacter(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Review.Builder addCharacter(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Review.Builder addCharacter(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Review.Builder addCitation(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Review.Builder addCitation(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Review.Builder addCitation(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Review.Builder addCitation(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Review.Builder addComment(Comment value) {
            return (Review.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Review.Builder addComment(Comment.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Review.Builder addComment(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Review.Builder addCommentCount(Integer value) {
            return (Review.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Review.Builder addCommentCount(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Review.Builder addContentLocation(Place value) {
            return (Review.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Review.Builder addContentLocation(Place.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Review.Builder addContentLocation(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Review.Builder addContentRating(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Review.Builder addContentRating(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Review.Builder addContributor(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Review.Builder addContributor(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Review.Builder addContributor(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Review.Builder addContributor(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Review.Builder addContributor(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Review.Builder addCopyrightHolder(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Review.Builder addCopyrightHolder(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Review.Builder addCopyrightHolder(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Review.Builder addCopyrightHolder(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Review.Builder addCopyrightHolder(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Review.Builder addCopyrightYear(Number value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Review.Builder addCopyrightYear(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Review.Builder addCreator(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Review.Builder addCreator(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Review.Builder addCreator(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Review.Builder addCreator(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Review.Builder addCreator(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Review.Builder addDateCreated(Date value) {
            return (Review.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Review.Builder addDateCreated(DateTime value) {
            return (Review.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Review.Builder addDateCreated(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Review.Builder addDateModified(Date value) {
            return (Review.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Review.Builder addDateModified(DateTime value) {
            return (Review.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Review.Builder addDateModified(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Review.Builder addDatePublished(Date value) {
            return (Review.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Review.Builder addDatePublished(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Review.Builder addDescription(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Review.Builder addDescription(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Review.Builder addDiscussionUrl(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Review.Builder addDiscussionUrl(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Review.Builder addEditor(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Review.Builder addEditor(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Review.Builder addEditor(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Review.Builder addEducationalAlignment(AlignmentObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Review.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Review.Builder addEducationalAlignment(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Review.Builder addEducationalUse(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Review.Builder addEducationalUse(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Review.Builder addEncoding(MediaObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Review.Builder addEncoding(MediaObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Review.Builder addEncoding(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Review.Builder addEncodings(MediaObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Review.Builder addEncodings(MediaObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Review.Builder addEncodings(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Review.Builder addExampleOfWork(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Review.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Review.Builder addExampleOfWork(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Review.Builder addFileFormat(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Review.Builder addFileFormat(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Review.Builder addGenre(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Review.Builder addGenre(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Review.Builder addGenre(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Review.Builder addHasPart(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Review.Builder addHasPart(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Review.Builder addHasPart(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Review.Builder addHeadline(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Review.Builder addHeadline(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Review.Builder addImage(ImageObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Review.Builder addImage(ImageObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Review.Builder addImage(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Review.Builder addImage(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Review.Builder addInLanguage(Language value) {
            return (Review.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Review.Builder addInLanguage(Language.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Review.Builder addInLanguage(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Review.Builder addInLanguage(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Review.Builder addInteractionStatistic(InteractionCounter value) {
            return (Review.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Review.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Review.Builder addInteractionStatistic(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Review.Builder addInteractivityType(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Review.Builder addInteractivityType(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Review.Builder addIsBasedOnUrl(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Review.Builder addIsBasedOnUrl(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Review.Builder addIsFamilyFriendly(Boolean value) {
            return (Review.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Review.Builder addIsFamilyFriendly(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Review.Builder addIsPartOf(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Review.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Review.Builder addIsPartOf(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Review.Builder addItemReviewed(Thing value) {
            return (Review.Builder)this.addProperty("http://schema.org/itemReviewed", value);
        }

        @Override
        public Review.Builder addItemReviewed(Thing.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/itemReviewed", value.build());
        }

        @Override
        public Review.Builder addItemReviewed(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/itemReviewed", Text.of(value));
        }

        @Override
        public Review.Builder addKeywords(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Review.Builder addKeywords(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Review.Builder addLearningResourceType(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Review.Builder addLearningResourceType(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Review.Builder addLicense(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Review.Builder addLicense(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Review.Builder addLicense(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Review.Builder addLicense(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Review.Builder addLocationCreated(Place value) {
            return (Review.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Review.Builder addLocationCreated(Place.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Review.Builder addLocationCreated(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Review.Builder addMainEntity(Thing value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Review.Builder addMainEntity(Thing.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Review.Builder addMainEntity(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Review.Builder addMainEntityOfPage(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Review.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Review.Builder addMainEntityOfPage(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Review.Builder addMainEntityOfPage(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Review.Builder addMentions(Thing value) {
            return (Review.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Review.Builder addMentions(Thing.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Review.Builder addMentions(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Review.Builder addName(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Review.Builder addName(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Review.Builder addOffers(Offer value) {
            return (Review.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Review.Builder addOffers(Offer.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Review.Builder addOffers(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Review.Builder addPosition(Integer value) {
            return (Review.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Review.Builder addPosition(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Review.Builder addPosition(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Review.Builder addPotentialAction(Action value) {
            return (Review.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Review.Builder addPotentialAction(Action.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Review.Builder addPotentialAction(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Review.Builder addProducer(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Review.Builder addProducer(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Review.Builder addProducer(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Review.Builder addProducer(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Review.Builder addProducer(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Review.Builder addProvider(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Review.Builder addProvider(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Review.Builder addProvider(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Review.Builder addProvider(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Review.Builder addProvider(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Review.Builder addPublication(PublicationEvent value) {
            return (Review.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Review.Builder addPublication(PublicationEvent.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Review.Builder addPublication(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Review.Builder addPublisher(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Review.Builder addPublisher(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Review.Builder addPublisher(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Review.Builder addPublisher(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Review.Builder addPublisher(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Review.Builder addPublishingPrinciples(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Review.Builder addPublishingPrinciples(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Review.Builder addRecordedAt(Event value) {
            return (Review.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Review.Builder addRecordedAt(Event.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Review.Builder addRecordedAt(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Review.Builder addReleasedEvent(PublicationEvent value) {
            return (Review.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Review.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Review.Builder addReleasedEvent(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Review.Builder addReview(Review value) {
            return (Review.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Review.Builder addReview(Review.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Review.Builder addReview(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Review.Builder addReviewBody(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviewBody", value);
        }

        @Override
        public Review.Builder addReviewBody(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviewBody", Text.of(value));
        }

        @Override
        public Review.Builder addReviewRating(Rating value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviewRating", value);
        }

        @Override
        public Review.Builder addReviewRating(Rating.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviewRating", value.build());
        }

        @Override
        public Review.Builder addReviewRating(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviewRating", Text.of(value));
        }

        @Override
        public Review.Builder addReviews(Review value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Review.Builder addReviews(Review.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Review.Builder addReviews(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Review.Builder addSameAs(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Review.Builder addSameAs(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Review.Builder addSchemaVersion(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Review.Builder addSchemaVersion(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Review.Builder addSchemaVersion(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Review.Builder addSourceOrganization(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Review.Builder addSourceOrganization(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Review.Builder addSourceOrganization(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Review.Builder addText(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Review.Builder addText(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Review.Builder addThumbnailUrl(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Review.Builder addThumbnailUrl(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Review.Builder addTimeRequired(Duration value) {
            return (Review.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Review.Builder addTimeRequired(Duration.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Review.Builder addTimeRequired(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Review.Builder addTranslator(Organization value) {
            return (Review.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Review.Builder addTranslator(Organization.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Review.Builder addTranslator(Person value) {
            return (Review.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Review.Builder addTranslator(Person.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Review.Builder addTranslator(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Review.Builder addTypicalAgeRange(Text value) {
            return (Review.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Review.Builder addTypicalAgeRange(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Review.Builder addUrl(URL value) {
            return (Review.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Review.Builder addUrl(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Review.Builder addVersion(Number value) {
            return (Review.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Review.Builder addVersion(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Review.Builder addVideo(VideoObject value) {
            return (Review.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Review.Builder addVideo(VideoObject.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Review.Builder addVideo(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Review.Builder addWorkExample(CreativeWork value) {
            return (Review.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Review.Builder addWorkExample(CreativeWork.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Review.Builder addWorkExample(String value) {
            return (Review.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Review.Builder addDetailedDescription(Article value) {
            return (Review.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Review.Builder addDetailedDescription(Article.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Review.Builder addDetailedDescription(String value) {
            return (Review.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Review.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Review.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Review.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Review.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Review.Builder addPopularityScore(String value) {
            return (Review.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Review build() {
            return new ReviewImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

