/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.PublicationIssue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PublicationIssueImpl
extends CreativeWorkImpl
implements PublicationIssue {
    private static final ImmutableSet<String> PROPERTY_SET = PublicationIssueImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/issueNumber");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/pageEnd");
        builder.add((Object)"http://schema.org/pageStart");
        builder.add((Object)"http://schema.org/pagination");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PublicationIssueImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PublicationIssue";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getIssueNumberList() {
        return this.getProperty("http://schema.org/issueNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPageEndList() {
        return this.getProperty("http://schema.org/pageEnd");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPageStartList() {
        return this.getProperty("http://schema.org/pageStart");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaginationList() {
        return this.getProperty("http://schema.org/pagination");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PublicationIssue.Builder>
    implements PublicationIssue.Builder {
        BuilderImpl() {
        }

        @Override
        public PublicationIssue.Builder addAbout(Thing value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public PublicationIssue.Builder addAbout(Thing.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public PublicationIssue.Builder addAbout(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAccessibilityAPI(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public PublicationIssue.Builder addAccessibilityAPI(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAccessibilityControl(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public PublicationIssue.Builder addAccessibilityControl(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAccessibilityFeature(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public PublicationIssue.Builder addAccessibilityFeature(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAccessibilityHazard(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public PublicationIssue.Builder addAccessibilityHazard(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAccountablePerson(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public PublicationIssue.Builder addAccountablePerson(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public PublicationIssue.Builder addAccountablePerson(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAdditionalType(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PublicationIssue.Builder addAdditionalType(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAggregateRating(AggregateRating value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public PublicationIssue.Builder addAggregateRating(AggregateRating.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public PublicationIssue.Builder addAggregateRating(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAlternateName(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PublicationIssue.Builder addAlternateName(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAlternativeHeadline(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public PublicationIssue.Builder addAlternativeHeadline(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAssociatedMedia(MediaObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public PublicationIssue.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public PublicationIssue.Builder addAssociatedMedia(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAudience(Audience value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public PublicationIssue.Builder addAudience(Audience.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public PublicationIssue.Builder addAudience(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAudio(AudioObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public PublicationIssue.Builder addAudio(AudioObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public PublicationIssue.Builder addAudio(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAuthor(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public PublicationIssue.Builder addAuthor(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public PublicationIssue.Builder addAuthor(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public PublicationIssue.Builder addAuthor(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public PublicationIssue.Builder addAuthor(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAward(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public PublicationIssue.Builder addAward(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addAwards(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public PublicationIssue.Builder addAwards(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addCharacter(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public PublicationIssue.Builder addCharacter(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public PublicationIssue.Builder addCharacter(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addCitation(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public PublicationIssue.Builder addCitation(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public PublicationIssue.Builder addCitation(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public PublicationIssue.Builder addCitation(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addComment(Comment value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public PublicationIssue.Builder addComment(Comment.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public PublicationIssue.Builder addComment(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addCommentCount(Integer value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public PublicationIssue.Builder addCommentCount(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addContentLocation(Place value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public PublicationIssue.Builder addContentLocation(Place.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public PublicationIssue.Builder addContentLocation(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addContentRating(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public PublicationIssue.Builder addContentRating(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addContributor(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public PublicationIssue.Builder addContributor(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public PublicationIssue.Builder addContributor(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public PublicationIssue.Builder addContributor(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public PublicationIssue.Builder addContributor(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addCopyrightHolder(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public PublicationIssue.Builder addCopyrightHolder(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public PublicationIssue.Builder addCopyrightHolder(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public PublicationIssue.Builder addCopyrightHolder(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public PublicationIssue.Builder addCopyrightHolder(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addCopyrightYear(Number value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public PublicationIssue.Builder addCopyrightYear(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addCreator(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public PublicationIssue.Builder addCreator(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public PublicationIssue.Builder addCreator(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public PublicationIssue.Builder addCreator(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public PublicationIssue.Builder addCreator(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addDateCreated(Date value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public PublicationIssue.Builder addDateCreated(DateTime value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public PublicationIssue.Builder addDateCreated(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addDateModified(Date value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public PublicationIssue.Builder addDateModified(DateTime value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public PublicationIssue.Builder addDateModified(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addDatePublished(Date value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public PublicationIssue.Builder addDatePublished(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addDescription(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PublicationIssue.Builder addDescription(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addDiscussionUrl(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public PublicationIssue.Builder addDiscussionUrl(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addEditor(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public PublicationIssue.Builder addEditor(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public PublicationIssue.Builder addEditor(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addEducationalAlignment(AlignmentObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public PublicationIssue.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public PublicationIssue.Builder addEducationalAlignment(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addEducationalUse(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public PublicationIssue.Builder addEducationalUse(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addEncoding(MediaObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public PublicationIssue.Builder addEncoding(MediaObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public PublicationIssue.Builder addEncoding(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addEncodings(MediaObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public PublicationIssue.Builder addEncodings(MediaObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public PublicationIssue.Builder addEncodings(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addExampleOfWork(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public PublicationIssue.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public PublicationIssue.Builder addExampleOfWork(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addFileFormat(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public PublicationIssue.Builder addFileFormat(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addGenre(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public PublicationIssue.Builder addGenre(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public PublicationIssue.Builder addGenre(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addHasPart(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public PublicationIssue.Builder addHasPart(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public PublicationIssue.Builder addHasPart(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addHeadline(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public PublicationIssue.Builder addHeadline(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addImage(ImageObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PublicationIssue.Builder addImage(ImageObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PublicationIssue.Builder addImage(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PublicationIssue.Builder addImage(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addInLanguage(Language value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public PublicationIssue.Builder addInLanguage(Language.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public PublicationIssue.Builder addInLanguage(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public PublicationIssue.Builder addInLanguage(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addInteractionStatistic(InteractionCounter value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public PublicationIssue.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public PublicationIssue.Builder addInteractionStatistic(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addInteractivityType(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public PublicationIssue.Builder addInteractivityType(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addIsBasedOnUrl(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public PublicationIssue.Builder addIsBasedOnUrl(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addIsFamilyFriendly(Boolean value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public PublicationIssue.Builder addIsFamilyFriendly(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addIsPartOf(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public PublicationIssue.Builder addIsPartOf(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public PublicationIssue.Builder addIsPartOf(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addIssueNumber(Integer value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/issueNumber", value);
        }

        @Override
        public PublicationIssue.Builder addIssueNumber(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/issueNumber", value);
        }

        @Override
        public PublicationIssue.Builder addIssueNumber(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/issueNumber", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addKeywords(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public PublicationIssue.Builder addKeywords(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addLearningResourceType(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public PublicationIssue.Builder addLearningResourceType(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addLicense(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public PublicationIssue.Builder addLicense(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public PublicationIssue.Builder addLicense(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public PublicationIssue.Builder addLicense(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addLocationCreated(Place value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public PublicationIssue.Builder addLocationCreated(Place.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public PublicationIssue.Builder addLocationCreated(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addMainEntity(Thing value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public PublicationIssue.Builder addMainEntity(Thing.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public PublicationIssue.Builder addMainEntity(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addMainEntityOfPage(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PublicationIssue.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PublicationIssue.Builder addMainEntityOfPage(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PublicationIssue.Builder addMainEntityOfPage(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addMentions(Thing value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public PublicationIssue.Builder addMentions(Thing.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public PublicationIssue.Builder addMentions(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addName(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PublicationIssue.Builder addName(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addOffers(Offer value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public PublicationIssue.Builder addOffers(Offer.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public PublicationIssue.Builder addOffers(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPageEnd(Integer value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pageEnd", value);
        }

        @Override
        public PublicationIssue.Builder addPageEnd(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pageEnd", value);
        }

        @Override
        public PublicationIssue.Builder addPageEnd(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pageEnd", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPageStart(Integer value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pageStart", value);
        }

        @Override
        public PublicationIssue.Builder addPageStart(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pageStart", value);
        }

        @Override
        public PublicationIssue.Builder addPageStart(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pageStart", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPagination(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pagination", value);
        }

        @Override
        public PublicationIssue.Builder addPagination(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/pagination", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPosition(Integer value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public PublicationIssue.Builder addPosition(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public PublicationIssue.Builder addPosition(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPotentialAction(Action value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PublicationIssue.Builder addPotentialAction(Action.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PublicationIssue.Builder addPotentialAction(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addProducer(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public PublicationIssue.Builder addProducer(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public PublicationIssue.Builder addProducer(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public PublicationIssue.Builder addProducer(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public PublicationIssue.Builder addProducer(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addProvider(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public PublicationIssue.Builder addProvider(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public PublicationIssue.Builder addProvider(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public PublicationIssue.Builder addProvider(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public PublicationIssue.Builder addProvider(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPublication(PublicationEvent value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public PublicationIssue.Builder addPublication(PublicationEvent.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public PublicationIssue.Builder addPublication(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPublisher(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public PublicationIssue.Builder addPublisher(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public PublicationIssue.Builder addPublisher(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public PublicationIssue.Builder addPublisher(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public PublicationIssue.Builder addPublisher(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPublishingPrinciples(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public PublicationIssue.Builder addPublishingPrinciples(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addRecordedAt(Event value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public PublicationIssue.Builder addRecordedAt(Event.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public PublicationIssue.Builder addRecordedAt(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addReleasedEvent(PublicationEvent value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public PublicationIssue.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public PublicationIssue.Builder addReleasedEvent(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addReview(Review value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public PublicationIssue.Builder addReview(Review.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public PublicationIssue.Builder addReview(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addReviews(Review value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public PublicationIssue.Builder addReviews(Review.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public PublicationIssue.Builder addReviews(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addSameAs(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PublicationIssue.Builder addSameAs(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addSchemaVersion(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public PublicationIssue.Builder addSchemaVersion(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public PublicationIssue.Builder addSchemaVersion(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addSourceOrganization(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public PublicationIssue.Builder addSourceOrganization(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public PublicationIssue.Builder addSourceOrganization(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addText(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public PublicationIssue.Builder addText(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addThumbnailUrl(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public PublicationIssue.Builder addThumbnailUrl(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addTimeRequired(Duration value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public PublicationIssue.Builder addTimeRequired(Duration.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public PublicationIssue.Builder addTimeRequired(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addTranslator(Organization value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public PublicationIssue.Builder addTranslator(Organization.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public PublicationIssue.Builder addTranslator(Person value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public PublicationIssue.Builder addTranslator(Person.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public PublicationIssue.Builder addTranslator(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addTypicalAgeRange(Text value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public PublicationIssue.Builder addTypicalAgeRange(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addUrl(URL value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PublicationIssue.Builder addUrl(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addVersion(Number value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public PublicationIssue.Builder addVersion(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addVideo(VideoObject value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public PublicationIssue.Builder addVideo(VideoObject.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public PublicationIssue.Builder addVideo(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addWorkExample(CreativeWork value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public PublicationIssue.Builder addWorkExample(CreativeWork.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public PublicationIssue.Builder addWorkExample(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addDetailedDescription(Article value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PublicationIssue.Builder addDetailedDescription(Article.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PublicationIssue.Builder addDetailedDescription(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PublicationIssue.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PublicationIssue.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PublicationIssue.Builder addPopularityScore(String value) {
            return (PublicationIssue.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PublicationIssue build() {
            return new PublicationIssueImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

