/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndicationImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PreventionIndication;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PreventionIndicationImpl
extends MedicalIndicationImpl
implements PreventionIndication {
    private static final ImmutableSet<String> PROPERTY_SET = PreventionIndicationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PreventionIndicationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PreventionIndication";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PreventionIndication.Builder>
    implements PreventionIndication.Builder {
        BuilderImpl() {
        }

        @Override
        public PreventionIndication.Builder addAdditionalType(URL value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PreventionIndication.Builder addAdditionalType(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addAlternateName(Text value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PreventionIndication.Builder addAlternateName(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addCode(MedicalCode value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public PreventionIndication.Builder addCode(MedicalCode.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public PreventionIndication.Builder addCode(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addDescription(Text value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PreventionIndication.Builder addDescription(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addGuideline(MedicalGuideline value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public PreventionIndication.Builder addGuideline(MedicalGuideline.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public PreventionIndication.Builder addGuideline(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addImage(ImageObject value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PreventionIndication.Builder addImage(ImageObject.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PreventionIndication.Builder addImage(URL value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PreventionIndication.Builder addImage(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addMainEntityOfPage(CreativeWork value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PreventionIndication.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PreventionIndication.Builder addMainEntityOfPage(URL value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PreventionIndication.Builder addMainEntityOfPage(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addMedicineSystem(MedicineSystem value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public PreventionIndication.Builder addMedicineSystem(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addName(Text value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PreventionIndication.Builder addName(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addPotentialAction(Action value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PreventionIndication.Builder addPotentialAction(Action.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PreventionIndication.Builder addPotentialAction(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addRecognizingAuthority(Organization value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public PreventionIndication.Builder addRecognizingAuthority(Organization.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public PreventionIndication.Builder addRecognizingAuthority(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public PreventionIndication.Builder addRelevantSpecialty(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addSameAs(URL value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PreventionIndication.Builder addSameAs(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addStudy(MedicalStudy value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public PreventionIndication.Builder addStudy(MedicalStudy.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public PreventionIndication.Builder addStudy(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addUrl(URL value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PreventionIndication.Builder addUrl(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addDetailedDescription(Article value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PreventionIndication.Builder addDetailedDescription(Article.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PreventionIndication.Builder addDetailedDescription(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PreventionIndication.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PreventionIndication.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PreventionIndication.Builder addPopularityScore(String value) {
            return (PreventionIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PreventionIndication build() {
            return new PreventionIndicationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

