/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Permit;
import com.google.schemaorg.core.Service;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PermitImpl
extends IntangibleImpl
implements Permit {
    private static final ImmutableSet<String> PROPERTY_SET = PermitImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/issuedBy");
        builder.add((Object)"http://schema.org/issuedThrough");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/permitAudience");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/validFor");
        builder.add((Object)"http://schema.org/validFrom");
        builder.add((Object)"http://schema.org/validIn");
        builder.add((Object)"http://schema.org/validUntil");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PermitImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Permit";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getIssuedByList() {
        return this.getProperty("http://schema.org/issuedBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIssuedThroughList() {
        return this.getProperty("http://schema.org/issuedThrough");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPermitAudienceList() {
        return this.getProperty("http://schema.org/permitAudience");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidForList() {
        return this.getProperty("http://schema.org/validFor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidFromList() {
        return this.getProperty("http://schema.org/validFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidInList() {
        return this.getProperty("http://schema.org/validIn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidUntilList() {
        return this.getProperty("http://schema.org/validUntil");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Permit.Builder>
    implements Permit.Builder {
        BuilderImpl() {
        }

        @Override
        public Permit.Builder addAdditionalType(URL value) {
            return (Permit.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Permit.Builder addAdditionalType(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Permit.Builder addAlternateName(Text value) {
            return (Permit.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Permit.Builder addAlternateName(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Permit.Builder addDescription(Text value) {
            return (Permit.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Permit.Builder addDescription(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Permit.Builder addImage(ImageObject value) {
            return (Permit.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Permit.Builder addImage(ImageObject.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Permit.Builder addImage(URL value) {
            return (Permit.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Permit.Builder addImage(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Permit.Builder addIssuedBy(Organization value) {
            return (Permit.Builder)this.addProperty("http://schema.org/issuedBy", value);
        }

        @Override
        public Permit.Builder addIssuedBy(Organization.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/issuedBy", value.build());
        }

        @Override
        public Permit.Builder addIssuedBy(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/issuedBy", Text.of(value));
        }

        @Override
        public Permit.Builder addIssuedThrough(Service value) {
            return (Permit.Builder)this.addProperty("http://schema.org/issuedThrough", value);
        }

        @Override
        public Permit.Builder addIssuedThrough(Service.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/issuedThrough", value.build());
        }

        @Override
        public Permit.Builder addIssuedThrough(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/issuedThrough", Text.of(value));
        }

        @Override
        public Permit.Builder addMainEntityOfPage(CreativeWork value) {
            return (Permit.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Permit.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Permit.Builder addMainEntityOfPage(URL value) {
            return (Permit.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Permit.Builder addMainEntityOfPage(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Permit.Builder addName(Text value) {
            return (Permit.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Permit.Builder addName(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Permit.Builder addPermitAudience(Audience value) {
            return (Permit.Builder)this.addProperty("http://schema.org/permitAudience", value);
        }

        @Override
        public Permit.Builder addPermitAudience(Audience.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/permitAudience", value.build());
        }

        @Override
        public Permit.Builder addPermitAudience(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/permitAudience", Text.of(value));
        }

        @Override
        public Permit.Builder addPotentialAction(Action value) {
            return (Permit.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Permit.Builder addPotentialAction(Action.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Permit.Builder addPotentialAction(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Permit.Builder addSameAs(URL value) {
            return (Permit.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Permit.Builder addSameAs(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Permit.Builder addUrl(URL value) {
            return (Permit.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Permit.Builder addUrl(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Permit.Builder addValidFor(Duration value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validFor", value);
        }

        @Override
        public Permit.Builder addValidFor(Duration.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validFor", value.build());
        }

        @Override
        public Permit.Builder addValidFor(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validFor", Text.of(value));
        }

        @Override
        public Permit.Builder addValidFrom(DateTime value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validFrom", value);
        }

        @Override
        public Permit.Builder addValidFrom(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validFrom", Text.of(value));
        }

        @Override
        public Permit.Builder addValidIn(AdministrativeArea value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validIn", value);
        }

        @Override
        public Permit.Builder addValidIn(AdministrativeArea.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validIn", value.build());
        }

        @Override
        public Permit.Builder addValidIn(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validIn", Text.of(value));
        }

        @Override
        public Permit.Builder addValidUntil(Date value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validUntil", value);
        }

        @Override
        public Permit.Builder addValidUntil(String value) {
            return (Permit.Builder)this.addProperty("http://schema.org/validUntil", Text.of(value));
        }

        @Override
        public Permit.Builder addDetailedDescription(Article value) {
            return (Permit.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Permit.Builder addDetailedDescription(Article.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Permit.Builder addDetailedDescription(String value) {
            return (Permit.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Permit.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Permit.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Permit.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Permit.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Permit.Builder addPopularityScore(String value) {
            return (Permit.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Permit build() {
            return new PermitImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

