/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Invoice;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Order;
import com.google.schemaorg.core.OrderItem;
import com.google.schemaorg.core.OrderStatus;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.ParcelDelivery;
import com.google.schemaorg.core.PaymentMethod;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class OrderImpl
extends IntangibleImpl
implements Order {
    private static final ImmutableSet<String> PROPERTY_SET = OrderImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/acceptedOffer");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/billingAddress");
        builder.add((Object)"http://schema.org/broker");
        builder.add((Object)"http://schema.org/confirmationNumber");
        builder.add((Object)"http://schema.org/customer");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discount");
        builder.add((Object)"http://schema.org/discountCode");
        builder.add((Object)"http://schema.org/discountCurrency");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/isGift");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/merchant");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/orderDate");
        builder.add((Object)"http://schema.org/orderDelivery");
        builder.add((Object)"http://schema.org/orderedItem");
        builder.add((Object)"http://schema.org/orderNumber");
        builder.add((Object)"http://schema.org/orderStatus");
        builder.add((Object)"http://schema.org/partOfInvoice");
        builder.add((Object)"http://schema.org/paymentDue");
        builder.add((Object)"http://schema.org/paymentDueDate");
        builder.add((Object)"http://schema.org/paymentMethod");
        builder.add((Object)"http://schema.org/paymentMethodId");
        builder.add((Object)"http://schema.org/paymentUrl");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seller");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public OrderImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Order";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAcceptedOfferList() {
        return this.getProperty("http://schema.org/acceptedOffer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBillingAddressList() {
        return this.getProperty("http://schema.org/billingAddress");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBrokerList() {
        return this.getProperty("http://schema.org/broker");
    }

    @Override
    public ImmutableList<SchemaOrgType> getConfirmationNumberList() {
        return this.getProperty("http://schema.org/confirmationNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCustomerList() {
        return this.getProperty("http://schema.org/customer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDiscountList() {
        return this.getProperty("http://schema.org/discount");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDiscountCodeList() {
        return this.getProperty("http://schema.org/discountCode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDiscountCurrencyList() {
        return this.getProperty("http://schema.org/discountCurrency");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsGiftList() {
        return this.getProperty("http://schema.org/isGift");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMerchantList() {
        return this.getProperty("http://schema.org/merchant");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderDateList() {
        return this.getProperty("http://schema.org/orderDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderDeliveryList() {
        return this.getProperty("http://schema.org/orderDelivery");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderedItemList() {
        return this.getProperty("http://schema.org/orderedItem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderNumberList() {
        return this.getProperty("http://schema.org/orderNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderStatusList() {
        return this.getProperty("http://schema.org/orderStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfInvoiceList() {
        return this.getProperty("http://schema.org/partOfInvoice");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentDueList() {
        return this.getProperty("http://schema.org/paymentDue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentDueDateList() {
        return this.getProperty("http://schema.org/paymentDueDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentMethodList() {
        return this.getProperty("http://schema.org/paymentMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentMethodIdList() {
        return this.getProperty("http://schema.org/paymentMethodId");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentUrlList() {
        return this.getProperty("http://schema.org/paymentUrl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSellerList() {
        return this.getProperty("http://schema.org/seller");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Order.Builder>
    implements Order.Builder {
        BuilderImpl() {
        }

        @Override
        public Order.Builder addAcceptedOffer(Offer value) {
            return (Order.Builder)this.addProperty("http://schema.org/acceptedOffer", value);
        }

        @Override
        public Order.Builder addAcceptedOffer(Offer.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/acceptedOffer", value.build());
        }

        @Override
        public Order.Builder addAcceptedOffer(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/acceptedOffer", Text.of(value));
        }

        @Override
        public Order.Builder addAdditionalType(URL value) {
            return (Order.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Order.Builder addAdditionalType(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Order.Builder addAlternateName(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Order.Builder addAlternateName(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Order.Builder addBillingAddress(PostalAddress value) {
            return (Order.Builder)this.addProperty("http://schema.org/billingAddress", value);
        }

        @Override
        public Order.Builder addBillingAddress(PostalAddress.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/billingAddress", value.build());
        }

        @Override
        public Order.Builder addBillingAddress(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/billingAddress", Text.of(value));
        }

        @Override
        public Order.Builder addBroker(Organization value) {
            return (Order.Builder)this.addProperty("http://schema.org/broker", value);
        }

        @Override
        public Order.Builder addBroker(Organization.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/broker", value.build());
        }

        @Override
        public Order.Builder addBroker(Person value) {
            return (Order.Builder)this.addProperty("http://schema.org/broker", value);
        }

        @Override
        public Order.Builder addBroker(Person.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/broker", value.build());
        }

        @Override
        public Order.Builder addBroker(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/broker", Text.of(value));
        }

        @Override
        public Order.Builder addConfirmationNumber(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/confirmationNumber", value);
        }

        @Override
        public Order.Builder addConfirmationNumber(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/confirmationNumber", Text.of(value));
        }

        @Override
        public Order.Builder addCustomer(Organization value) {
            return (Order.Builder)this.addProperty("http://schema.org/customer", value);
        }

        @Override
        public Order.Builder addCustomer(Organization.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/customer", value.build());
        }

        @Override
        public Order.Builder addCustomer(Person value) {
            return (Order.Builder)this.addProperty("http://schema.org/customer", value);
        }

        @Override
        public Order.Builder addCustomer(Person.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/customer", value.build());
        }

        @Override
        public Order.Builder addCustomer(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/customer", Text.of(value));
        }

        @Override
        public Order.Builder addDescription(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Order.Builder addDescription(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Order.Builder addDiscount(Number value) {
            return (Order.Builder)this.addProperty("http://schema.org/discount", value);
        }

        @Override
        public Order.Builder addDiscount(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/discount", value);
        }

        @Override
        public Order.Builder addDiscount(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/discount", Text.of(value));
        }

        @Override
        public Order.Builder addDiscountCode(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/discountCode", value);
        }

        @Override
        public Order.Builder addDiscountCode(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/discountCode", Text.of(value));
        }

        @Override
        public Order.Builder addDiscountCurrency(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/discountCurrency", value);
        }

        @Override
        public Order.Builder addDiscountCurrency(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/discountCurrency", Text.of(value));
        }

        @Override
        public Order.Builder addImage(ImageObject value) {
            return (Order.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Order.Builder addImage(ImageObject.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Order.Builder addImage(URL value) {
            return (Order.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Order.Builder addImage(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Order.Builder addIsGift(Boolean value) {
            return (Order.Builder)this.addProperty("http://schema.org/isGift", value);
        }

        @Override
        public Order.Builder addIsGift(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/isGift", Text.of(value));
        }

        @Override
        public Order.Builder addMainEntityOfPage(CreativeWork value) {
            return (Order.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Order.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Order.Builder addMainEntityOfPage(URL value) {
            return (Order.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Order.Builder addMainEntityOfPage(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Order.Builder addMerchant(Organization value) {
            return (Order.Builder)this.addProperty("http://schema.org/merchant", value);
        }

        @Override
        public Order.Builder addMerchant(Organization.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/merchant", value.build());
        }

        @Override
        public Order.Builder addMerchant(Person value) {
            return (Order.Builder)this.addProperty("http://schema.org/merchant", value);
        }

        @Override
        public Order.Builder addMerchant(Person.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/merchant", value.build());
        }

        @Override
        public Order.Builder addMerchant(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/merchant", Text.of(value));
        }

        @Override
        public Order.Builder addName(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Order.Builder addName(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Order.Builder addOrderDate(DateTime value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderDate", value);
        }

        @Override
        public Order.Builder addOrderDate(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderDate", Text.of(value));
        }

        @Override
        public Order.Builder addOrderDelivery(ParcelDelivery value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderDelivery", value);
        }

        @Override
        public Order.Builder addOrderDelivery(ParcelDelivery.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderDelivery", value.build());
        }

        @Override
        public Order.Builder addOrderDelivery(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderDelivery", Text.of(value));
        }

        @Override
        public Order.Builder addOrderedItem(OrderItem value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderedItem", value);
        }

        @Override
        public Order.Builder addOrderedItem(OrderItem.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderedItem", value.build());
        }

        @Override
        public Order.Builder addOrderedItem(Product value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderedItem", value);
        }

        @Override
        public Order.Builder addOrderedItem(Product.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderedItem", value.build());
        }

        @Override
        public Order.Builder addOrderedItem(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderedItem", Text.of(value));
        }

        @Override
        public Order.Builder addOrderNumber(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderNumber", value);
        }

        @Override
        public Order.Builder addOrderNumber(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderNumber", Text.of(value));
        }

        @Override
        public Order.Builder addOrderStatus(OrderStatus value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderStatus", value);
        }

        @Override
        public Order.Builder addOrderStatus(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/orderStatus", Text.of(value));
        }

        @Override
        public Order.Builder addPartOfInvoice(Invoice value) {
            return (Order.Builder)this.addProperty("http://schema.org/partOfInvoice", value);
        }

        @Override
        public Order.Builder addPartOfInvoice(Invoice.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/partOfInvoice", value.build());
        }

        @Override
        public Order.Builder addPartOfInvoice(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/partOfInvoice", Text.of(value));
        }

        @Override
        public Order.Builder addPaymentDue(DateTime value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentDue", value);
        }

        @Override
        public Order.Builder addPaymentDue(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentDue", Text.of(value));
        }

        @Override
        public Order.Builder addPaymentDueDate(DateTime value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentDueDate", value);
        }

        @Override
        public Order.Builder addPaymentDueDate(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentDueDate", Text.of(value));
        }

        @Override
        public Order.Builder addPaymentMethod(PaymentMethod value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentMethod", value);
        }

        @Override
        public Order.Builder addPaymentMethod(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentMethod", Text.of(value));
        }

        @Override
        public Order.Builder addPaymentMethodId(Text value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentMethodId", value);
        }

        @Override
        public Order.Builder addPaymentMethodId(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentMethodId", Text.of(value));
        }

        @Override
        public Order.Builder addPaymentUrl(URL value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentUrl", value);
        }

        @Override
        public Order.Builder addPaymentUrl(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/paymentUrl", Text.of(value));
        }

        @Override
        public Order.Builder addPotentialAction(Action value) {
            return (Order.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Order.Builder addPotentialAction(Action.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Order.Builder addPotentialAction(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Order.Builder addSameAs(URL value) {
            return (Order.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Order.Builder addSameAs(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Order.Builder addSeller(Organization value) {
            return (Order.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Order.Builder addSeller(Organization.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Order.Builder addSeller(Person value) {
            return (Order.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Order.Builder addSeller(Person.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Order.Builder addSeller(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/seller", Text.of(value));
        }

        @Override
        public Order.Builder addUrl(URL value) {
            return (Order.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Order.Builder addUrl(String value) {
            return (Order.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Order.Builder addDetailedDescription(Article value) {
            return (Order.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Order.Builder addDetailedDescription(Article.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Order.Builder addDetailedDescription(String value) {
            return (Order.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Order.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Order.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Order.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Order.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Order.Builder addPopularityScore(String value) {
            return (Order.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Order build() {
            return new OrderImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

