/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BusinessEntityType;
import com.google.schemaorg.core.BusinessFunction;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DeliveryMethod;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.ItemAvailability;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.OfferItemCondition;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PaymentMethod;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.PhysicalActivityCategory;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PriceSpecification;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Service;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.TypeAndQuantityNode;
import com.google.schemaorg.core.WarrantyPromise;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class OfferImpl
extends IntangibleImpl
implements Offer {
    private static final ImmutableSet<String> PROPERTY_SET = OfferImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/acceptedPaymentMethod");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/addOn");
        builder.add((Object)"http://schema.org/advanceBookingRequirement");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/areaServed");
        builder.add((Object)"http://schema.org/availability");
        builder.add((Object)"http://schema.org/availabilityEnds");
        builder.add((Object)"http://schema.org/availabilityStarts");
        builder.add((Object)"http://schema.org/availableAtOrFrom");
        builder.add((Object)"http://schema.org/availableDeliveryMethod");
        builder.add((Object)"http://schema.org/businessFunction");
        builder.add((Object)"http://schema.org/category");
        builder.add((Object)"http://schema.org/deliveryLeadTime");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/eligibleCustomerType");
        builder.add((Object)"http://schema.org/eligibleDuration");
        builder.add((Object)"http://schema.org/eligibleQuantity");
        builder.add((Object)"http://schema.org/eligibleRegion");
        builder.add((Object)"http://schema.org/eligibleTransactionVolume");
        builder.add((Object)"http://schema.org/gtin12");
        builder.add((Object)"http://schema.org/gtin13");
        builder.add((Object)"http://schema.org/gtin14");
        builder.add((Object)"http://schema.org/gtin8");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includesObject");
        builder.add((Object)"http://schema.org/ineligibleRegion");
        builder.add((Object)"http://schema.org/inventoryLevel");
        builder.add((Object)"http://schema.org/itemCondition");
        builder.add((Object)"http://schema.org/itemOffered");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mpn");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offeredBy");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/price");
        builder.add((Object)"http://schema.org/priceCurrency");
        builder.add((Object)"http://schema.org/priceSpecification");
        builder.add((Object)"http://schema.org/priceValidUntil");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seller");
        builder.add((Object)"http://schema.org/serialNumber");
        builder.add((Object)"http://schema.org/sku");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/validFrom");
        builder.add((Object)"http://schema.org/validThrough");
        builder.add((Object)"http://schema.org/warranty");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public OfferImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Offer";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAcceptedPaymentMethodList() {
        return this.getProperty("http://schema.org/acceptedPaymentMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddOnList() {
        return this.getProperty("http://schema.org/addOn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdvanceBookingRequirementList() {
        return this.getProperty("http://schema.org/advanceBookingRequirement");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAggregateRatingList() {
        return this.getProperty("http://schema.org/aggregateRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAreaServedList() {
        return this.getProperty("http://schema.org/areaServed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailabilityList() {
        return this.getProperty("http://schema.org/availability");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailabilityEndsList() {
        return this.getProperty("http://schema.org/availabilityEnds");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailabilityStartsList() {
        return this.getProperty("http://schema.org/availabilityStarts");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableAtOrFromList() {
        return this.getProperty("http://schema.org/availableAtOrFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableDeliveryMethodList() {
        return this.getProperty("http://schema.org/availableDeliveryMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBusinessFunctionList() {
        return this.getProperty("http://schema.org/businessFunction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCategoryList() {
        return this.getProperty("http://schema.org/category");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDeliveryLeadTimeList() {
        return this.getProperty("http://schema.org/deliveryLeadTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleCustomerTypeList() {
        return this.getProperty("http://schema.org/eligibleCustomerType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleDurationList() {
        return this.getProperty("http://schema.org/eligibleDuration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleQuantityList() {
        return this.getProperty("http://schema.org/eligibleQuantity");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleRegionList() {
        return this.getProperty("http://schema.org/eligibleRegion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleTransactionVolumeList() {
        return this.getProperty("http://schema.org/eligibleTransactionVolume");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin12List() {
        return this.getProperty("http://schema.org/gtin12");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin13List() {
        return this.getProperty("http://schema.org/gtin13");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin14List() {
        return this.getProperty("http://schema.org/gtin14");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin8List() {
        return this.getProperty("http://schema.org/gtin8");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIncludesObjectList() {
        return this.getProperty("http://schema.org/includesObject");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIneligibleRegionList() {
        return this.getProperty("http://schema.org/ineligibleRegion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInventoryLevelList() {
        return this.getProperty("http://schema.org/inventoryLevel");
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemConditionList() {
        return this.getProperty("http://schema.org/itemCondition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemOfferedList() {
        return this.getProperty("http://schema.org/itemOffered");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMpnList() {
        return this.getProperty("http://schema.org/mpn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOfferedByList() {
        return this.getProperty("http://schema.org/offeredBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceList() {
        return this.getProperty("http://schema.org/price");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceCurrencyList() {
        return this.getProperty("http://schema.org/priceCurrency");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceSpecificationList() {
        return this.getProperty("http://schema.org/priceSpecification");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceValidUntilList() {
        return this.getProperty("http://schema.org/priceValidUntil");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewList() {
        return this.getProperty("http://schema.org/review");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewsList() {
        return this.getProperty("http://schema.org/reviews");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSellerList() {
        return this.getProperty("http://schema.org/seller");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSerialNumberList() {
        return this.getProperty("http://schema.org/serialNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSkuList() {
        return this.getProperty("http://schema.org/sku");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidFromList() {
        return this.getProperty("http://schema.org/validFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidThroughList() {
        return this.getProperty("http://schema.org/validThrough");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWarrantyList() {
        return this.getProperty("http://schema.org/warranty");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Offer.Builder>
    implements Offer.Builder {
        BuilderImpl() {
        }

        @Override
        public Offer.Builder addAcceptedPaymentMethod(PaymentMethod value) {
            return (Offer.Builder)this.addProperty("http://schema.org/acceptedPaymentMethod", value);
        }

        @Override
        public Offer.Builder addAcceptedPaymentMethod(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/acceptedPaymentMethod", Text.of(value));
        }

        @Override
        public Offer.Builder addAdditionalType(URL value) {
            return (Offer.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Offer.Builder addAdditionalType(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Offer.Builder addAddOn(Offer value) {
            return (Offer.Builder)this.addProperty("http://schema.org/addOn", value);
        }

        @Override
        public Offer.Builder addAddOn(Offer.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/addOn", value.build());
        }

        @Override
        public Offer.Builder addAddOn(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/addOn", Text.of(value));
        }

        @Override
        public Offer.Builder addAdvanceBookingRequirement(QuantitativeValue value) {
            return (Offer.Builder)this.addProperty("http://schema.org/advanceBookingRequirement", value);
        }

        @Override
        public Offer.Builder addAdvanceBookingRequirement(QuantitativeValue.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/advanceBookingRequirement", value.build());
        }

        @Override
        public Offer.Builder addAdvanceBookingRequirement(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/advanceBookingRequirement", Text.of(value));
        }

        @Override
        public Offer.Builder addAggregateRating(AggregateRating value) {
            return (Offer.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Offer.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Offer.Builder addAggregateRating(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Offer.Builder addAlternateName(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Offer.Builder addAlternateName(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Offer.Builder addAreaServed(AdministrativeArea value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Offer.Builder addAreaServed(AdministrativeArea.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Offer.Builder addAreaServed(GeoShape value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Offer.Builder addAreaServed(GeoShape.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Offer.Builder addAreaServed(Place value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Offer.Builder addAreaServed(Place.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Offer.Builder addAreaServed(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Offer.Builder addAreaServed(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/areaServed", Text.of(value));
        }

        @Override
        public Offer.Builder addAvailability(ItemAvailability value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availability", value);
        }

        @Override
        public Offer.Builder addAvailability(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availability", Text.of(value));
        }

        @Override
        public Offer.Builder addAvailabilityEnds(DateTime value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availabilityEnds", value);
        }

        @Override
        public Offer.Builder addAvailabilityEnds(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availabilityEnds", Text.of(value));
        }

        @Override
        public Offer.Builder addAvailabilityStarts(DateTime value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availabilityStarts", value);
        }

        @Override
        public Offer.Builder addAvailabilityStarts(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availabilityStarts", Text.of(value));
        }

        @Override
        public Offer.Builder addAvailableAtOrFrom(Place value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availableAtOrFrom", value);
        }

        @Override
        public Offer.Builder addAvailableAtOrFrom(Place.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availableAtOrFrom", value.build());
        }

        @Override
        public Offer.Builder addAvailableAtOrFrom(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availableAtOrFrom", Text.of(value));
        }

        @Override
        public Offer.Builder addAvailableDeliveryMethod(DeliveryMethod value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availableDeliveryMethod", value);
        }

        @Override
        public Offer.Builder addAvailableDeliveryMethod(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/availableDeliveryMethod", Text.of(value));
        }

        @Override
        public Offer.Builder addBusinessFunction(BusinessFunction value) {
            return (Offer.Builder)this.addProperty("http://schema.org/businessFunction", value);
        }

        @Override
        public Offer.Builder addBusinessFunction(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/businessFunction", Text.of(value));
        }

        @Override
        public Offer.Builder addCategory(PhysicalActivityCategory value) {
            return (Offer.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Offer.Builder addCategory(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Offer.Builder addCategory(Thing value) {
            return (Offer.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Offer.Builder addCategory(Thing.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/category", value.build());
        }

        @Override
        public Offer.Builder addCategory(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/category", Text.of(value));
        }

        @Override
        public Offer.Builder addDeliveryLeadTime(QuantitativeValue value) {
            return (Offer.Builder)this.addProperty("http://schema.org/deliveryLeadTime", value);
        }

        @Override
        public Offer.Builder addDeliveryLeadTime(QuantitativeValue.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/deliveryLeadTime", value.build());
        }

        @Override
        public Offer.Builder addDeliveryLeadTime(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/deliveryLeadTime", Text.of(value));
        }

        @Override
        public Offer.Builder addDescription(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Offer.Builder addDescription(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Offer.Builder addEligibleCustomerType(BusinessEntityType value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleCustomerType", value);
        }

        @Override
        public Offer.Builder addEligibleCustomerType(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleCustomerType", Text.of(value));
        }

        @Override
        public Offer.Builder addEligibleDuration(QuantitativeValue value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleDuration", value);
        }

        @Override
        public Offer.Builder addEligibleDuration(QuantitativeValue.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleDuration", value.build());
        }

        @Override
        public Offer.Builder addEligibleDuration(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleDuration", Text.of(value));
        }

        @Override
        public Offer.Builder addEligibleQuantity(QuantitativeValue value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleQuantity", value);
        }

        @Override
        public Offer.Builder addEligibleQuantity(QuantitativeValue.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleQuantity", value.build());
        }

        @Override
        public Offer.Builder addEligibleQuantity(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleQuantity", Text.of(value));
        }

        @Override
        public Offer.Builder addEligibleRegion(GeoShape value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public Offer.Builder addEligibleRegion(GeoShape.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleRegion", value.build());
        }

        @Override
        public Offer.Builder addEligibleRegion(Place value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public Offer.Builder addEligibleRegion(Place.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleRegion", value.build());
        }

        @Override
        public Offer.Builder addEligibleRegion(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public Offer.Builder addEligibleRegion(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleRegion", Text.of(value));
        }

        @Override
        public Offer.Builder addEligibleTransactionVolume(PriceSpecification value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleTransactionVolume", value);
        }

        @Override
        public Offer.Builder addEligibleTransactionVolume(PriceSpecification.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleTransactionVolume", value.build());
        }

        @Override
        public Offer.Builder addEligibleTransactionVolume(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/eligibleTransactionVolume", Text.of(value));
        }

        @Override
        public Offer.Builder addGtin12(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin12", value);
        }

        @Override
        public Offer.Builder addGtin12(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin12", Text.of(value));
        }

        @Override
        public Offer.Builder addGtin13(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin13", value);
        }

        @Override
        public Offer.Builder addGtin13(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin13", Text.of(value));
        }

        @Override
        public Offer.Builder addGtin14(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin14", value);
        }

        @Override
        public Offer.Builder addGtin14(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin14", Text.of(value));
        }

        @Override
        public Offer.Builder addGtin8(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin8", value);
        }

        @Override
        public Offer.Builder addGtin8(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/gtin8", Text.of(value));
        }

        @Override
        public Offer.Builder addImage(ImageObject value) {
            return (Offer.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Offer.Builder addImage(ImageObject.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Offer.Builder addImage(URL value) {
            return (Offer.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Offer.Builder addImage(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Offer.Builder addIncludesObject(TypeAndQuantityNode value) {
            return (Offer.Builder)this.addProperty("http://schema.org/includesObject", value);
        }

        @Override
        public Offer.Builder addIncludesObject(TypeAndQuantityNode.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/includesObject", value.build());
        }

        @Override
        public Offer.Builder addIncludesObject(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/includesObject", Text.of(value));
        }

        @Override
        public Offer.Builder addIneligibleRegion(GeoShape value) {
            return (Offer.Builder)this.addProperty("http://schema.org/ineligibleRegion", value);
        }

        @Override
        public Offer.Builder addIneligibleRegion(GeoShape.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/ineligibleRegion", value.build());
        }

        @Override
        public Offer.Builder addIneligibleRegion(Place value) {
            return (Offer.Builder)this.addProperty("http://schema.org/ineligibleRegion", value);
        }

        @Override
        public Offer.Builder addIneligibleRegion(Place.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/ineligibleRegion", value.build());
        }

        @Override
        public Offer.Builder addIneligibleRegion(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/ineligibleRegion", value);
        }

        @Override
        public Offer.Builder addIneligibleRegion(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/ineligibleRegion", Text.of(value));
        }

        @Override
        public Offer.Builder addInventoryLevel(QuantitativeValue value) {
            return (Offer.Builder)this.addProperty("http://schema.org/inventoryLevel", value);
        }

        @Override
        public Offer.Builder addInventoryLevel(QuantitativeValue.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/inventoryLevel", value.build());
        }

        @Override
        public Offer.Builder addInventoryLevel(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/inventoryLevel", Text.of(value));
        }

        @Override
        public Offer.Builder addItemCondition(OfferItemCondition value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemCondition", value);
        }

        @Override
        public Offer.Builder addItemCondition(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemCondition", Text.of(value));
        }

        @Override
        public Offer.Builder addItemOffered(Product value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemOffered", value);
        }

        @Override
        public Offer.Builder addItemOffered(Product.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemOffered", value.build());
        }

        @Override
        public Offer.Builder addItemOffered(Service value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemOffered", value);
        }

        @Override
        public Offer.Builder addItemOffered(Service.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemOffered", value.build());
        }

        @Override
        public Offer.Builder addItemOffered(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/itemOffered", Text.of(value));
        }

        @Override
        public Offer.Builder addMainEntityOfPage(CreativeWork value) {
            return (Offer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Offer.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Offer.Builder addMainEntityOfPage(URL value) {
            return (Offer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Offer.Builder addMainEntityOfPage(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Offer.Builder addMpn(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/mpn", value);
        }

        @Override
        public Offer.Builder addMpn(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/mpn", Text.of(value));
        }

        @Override
        public Offer.Builder addName(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Offer.Builder addName(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Offer.Builder addOfferedBy(Organization value) {
            return (Offer.Builder)this.addProperty("http://schema.org/offeredBy", value);
        }

        @Override
        public Offer.Builder addOfferedBy(Organization.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/offeredBy", value.build());
        }

        @Override
        public Offer.Builder addOfferedBy(Person value) {
            return (Offer.Builder)this.addProperty("http://schema.org/offeredBy", value);
        }

        @Override
        public Offer.Builder addOfferedBy(Person.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/offeredBy", value.build());
        }

        @Override
        public Offer.Builder addOfferedBy(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/offeredBy", Text.of(value));
        }

        @Override
        public Offer.Builder addPotentialAction(Action value) {
            return (Offer.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Offer.Builder addPotentialAction(Action.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Offer.Builder addPotentialAction(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Offer.Builder addPrice(Number value) {
            return (Offer.Builder)this.addProperty("http://schema.org/price", value);
        }

        @Override
        public Offer.Builder addPrice(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/price", value);
        }

        @Override
        public Offer.Builder addPrice(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/price", Text.of(value));
        }

        @Override
        public Offer.Builder addPriceCurrency(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceCurrency", value);
        }

        @Override
        public Offer.Builder addPriceCurrency(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceCurrency", Text.of(value));
        }

        @Override
        public Offer.Builder addPriceSpecification(PriceSpecification value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceSpecification", value);
        }

        @Override
        public Offer.Builder addPriceSpecification(PriceSpecification.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceSpecification", value.build());
        }

        @Override
        public Offer.Builder addPriceSpecification(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceSpecification", Text.of(value));
        }

        @Override
        public Offer.Builder addPriceValidUntil(Date value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceValidUntil", value);
        }

        @Override
        public Offer.Builder addPriceValidUntil(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/priceValidUntil", Text.of(value));
        }

        @Override
        public Offer.Builder addReview(Review value) {
            return (Offer.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Offer.Builder addReview(Review.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Offer.Builder addReview(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Offer.Builder addReviews(Review value) {
            return (Offer.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Offer.Builder addReviews(Review.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Offer.Builder addReviews(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Offer.Builder addSameAs(URL value) {
            return (Offer.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Offer.Builder addSameAs(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Offer.Builder addSeller(Organization value) {
            return (Offer.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Offer.Builder addSeller(Organization.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Offer.Builder addSeller(Person value) {
            return (Offer.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Offer.Builder addSeller(Person.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Offer.Builder addSeller(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/seller", Text.of(value));
        }

        @Override
        public Offer.Builder addSerialNumber(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/serialNumber", value);
        }

        @Override
        public Offer.Builder addSerialNumber(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/serialNumber", Text.of(value));
        }

        @Override
        public Offer.Builder addSku(Text value) {
            return (Offer.Builder)this.addProperty("http://schema.org/sku", value);
        }

        @Override
        public Offer.Builder addSku(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/sku", Text.of(value));
        }

        @Override
        public Offer.Builder addUrl(URL value) {
            return (Offer.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Offer.Builder addUrl(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Offer.Builder addValidFrom(DateTime value) {
            return (Offer.Builder)this.addProperty("http://schema.org/validFrom", value);
        }

        @Override
        public Offer.Builder addValidFrom(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/validFrom", Text.of(value));
        }

        @Override
        public Offer.Builder addValidThrough(DateTime value) {
            return (Offer.Builder)this.addProperty("http://schema.org/validThrough", value);
        }

        @Override
        public Offer.Builder addValidThrough(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/validThrough", Text.of(value));
        }

        @Override
        public Offer.Builder addWarranty(WarrantyPromise value) {
            return (Offer.Builder)this.addProperty("http://schema.org/warranty", value);
        }

        @Override
        public Offer.Builder addWarranty(WarrantyPromise.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.org/warranty", value.build());
        }

        @Override
        public Offer.Builder addWarranty(String value) {
            return (Offer.Builder)this.addProperty("http://schema.org/warranty", Text.of(value));
        }

        @Override
        public Offer.Builder addDetailedDescription(Article value) {
            return (Offer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Offer.Builder addDetailedDescription(Article.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Offer.Builder addDetailedDescription(String value) {
            return (Offer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Offer.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Offer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Offer.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Offer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Offer.Builder addPopularityScore(String value) {
            return (Offer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Offer build() {
            return new OfferImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

