/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalStructureImpl;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BrainStructure;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Muscle;
import com.google.schemaorg.core.Nerve;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.SuperficialAnatomy;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class NerveImpl
extends AnatomicalStructureImpl
implements Nerve {
    private static final ImmutableSet<String> PROPERTY_SET = NerveImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/branch");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/nerveMotor");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/sensoryUnit");
        builder.add((Object)"http://schema.org/sourcedFrom");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public NerveImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Nerve";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBranchList() {
        return this.getProperty("http://schema.org/branch");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNerveMotorList() {
        return this.getProperty("http://schema.org/nerveMotor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSensoryUnitList() {
        return this.getProperty("http://schema.org/sensoryUnit");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSourcedFromList() {
        return this.getProperty("http://schema.org/sourcedFrom");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Nerve.Builder>
    implements Nerve.Builder {
        BuilderImpl() {
        }

        @Override
        public Nerve.Builder addAdditionalType(URL value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Nerve.Builder addAdditionalType(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Nerve.Builder addAlternateName(Text value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Nerve.Builder addAlternateName(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Nerve.Builder addAssociatedPathophysiology(Text value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public Nerve.Builder addAssociatedPathophysiology(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public Nerve.Builder addBodyLocation(Text value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public Nerve.Builder addBodyLocation(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public Nerve.Builder addBranch(AnatomicalStructure value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/branch", value);
        }

        @Override
        public Nerve.Builder addBranch(AnatomicalStructure.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/branch", value.build());
        }

        @Override
        public Nerve.Builder addBranch(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/branch", Text.of(value));
        }

        @Override
        public Nerve.Builder addCode(MedicalCode value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Nerve.Builder addCode(MedicalCode.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Nerve.Builder addCode(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Nerve.Builder addConnectedTo(AnatomicalStructure value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public Nerve.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public Nerve.Builder addConnectedTo(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public Nerve.Builder addDescription(Text value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Nerve.Builder addDescription(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Nerve.Builder addDiagram(ImageObject value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public Nerve.Builder addDiagram(ImageObject.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public Nerve.Builder addDiagram(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public Nerve.Builder addFunction(Text value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public Nerve.Builder addFunction(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public Nerve.Builder addGuideline(MedicalGuideline value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Nerve.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Nerve.Builder addGuideline(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Nerve.Builder addImage(ImageObject value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Nerve.Builder addImage(ImageObject.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Nerve.Builder addImage(URL value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Nerve.Builder addImage(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Nerve.Builder addMainEntityOfPage(CreativeWork value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Nerve.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Nerve.Builder addMainEntityOfPage(URL value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Nerve.Builder addMainEntityOfPage(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Nerve.Builder addMedicineSystem(MedicineSystem value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Nerve.Builder addMedicineSystem(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Nerve.Builder addName(Text value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Nerve.Builder addName(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Nerve.Builder addNerveMotor(Muscle value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/nerveMotor", value);
        }

        @Override
        public Nerve.Builder addNerveMotor(Muscle.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/nerveMotor", value.build());
        }

        @Override
        public Nerve.Builder addNerveMotor(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/nerveMotor", Text.of(value));
        }

        @Override
        public Nerve.Builder addPartOfSystem(AnatomicalSystem value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public Nerve.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public Nerve.Builder addPartOfSystem(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public Nerve.Builder addPotentialAction(Action value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Nerve.Builder addPotentialAction(Action.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Nerve.Builder addPotentialAction(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Nerve.Builder addRecognizingAuthority(Organization value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Nerve.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Nerve.Builder addRecognizingAuthority(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Nerve.Builder addRelatedCondition(MedicalCondition value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public Nerve.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public Nerve.Builder addRelatedCondition(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public Nerve.Builder addRelatedTherapy(MedicalTherapy value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public Nerve.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public Nerve.Builder addRelatedTherapy(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public Nerve.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Nerve.Builder addRelevantSpecialty(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Nerve.Builder addSameAs(URL value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Nerve.Builder addSameAs(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Nerve.Builder addSensoryUnit(AnatomicalStructure value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sensoryUnit", value);
        }

        @Override
        public Nerve.Builder addSensoryUnit(AnatomicalStructure.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sensoryUnit", value.build());
        }

        @Override
        public Nerve.Builder addSensoryUnit(SuperficialAnatomy value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sensoryUnit", value);
        }

        @Override
        public Nerve.Builder addSensoryUnit(SuperficialAnatomy.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sensoryUnit", value.build());
        }

        @Override
        public Nerve.Builder addSensoryUnit(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sensoryUnit", Text.of(value));
        }

        @Override
        public Nerve.Builder addSourcedFrom(BrainStructure value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sourcedFrom", value);
        }

        @Override
        public Nerve.Builder addSourcedFrom(BrainStructure.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sourcedFrom", value.build());
        }

        @Override
        public Nerve.Builder addSourcedFrom(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/sourcedFrom", Text.of(value));
        }

        @Override
        public Nerve.Builder addStudy(MedicalStudy value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Nerve.Builder addStudy(MedicalStudy.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Nerve.Builder addStudy(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Nerve.Builder addSubStructure(AnatomicalStructure value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public Nerve.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public Nerve.Builder addSubStructure(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public Nerve.Builder addUrl(URL value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Nerve.Builder addUrl(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Nerve.Builder addDetailedDescription(Article value) {
            return (Nerve.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Nerve.Builder addDetailedDescription(Article.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Nerve.Builder addDetailedDescription(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Nerve.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Nerve.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Nerve.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Nerve.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Nerve.Builder addPopularityScore(String value) {
            return (Nerve.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Nerve build() {
            return new NerveImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

