/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MusicComposition;
import com.google.schemaorg.core.MusicRecording;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MusicCompositionImpl
extends CreativeWorkImpl
implements MusicComposition {
    private static final ImmutableSet<String> PROPERTY_SET = MusicCompositionImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/composer");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/firstPerformance");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includedComposition");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/iswcCode");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/lyricist");
        builder.add((Object)"http://schema.org/lyrics");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicalKey");
        builder.add((Object)"http://schema.org/musicArrangement");
        builder.add((Object)"http://schema.org/musicCompositionForm");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAs");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MusicCompositionImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MusicComposition";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getComposerList() {
        return this.getProperty("http://schema.org/composer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFirstPerformanceList() {
        return this.getProperty("http://schema.org/firstPerformance");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIncludedCompositionList() {
        return this.getProperty("http://schema.org/includedComposition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIswcCodeList() {
        return this.getProperty("http://schema.org/iswcCode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLyricistList() {
        return this.getProperty("http://schema.org/lyricist");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLyricsList() {
        return this.getProperty("http://schema.org/lyrics");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicalKeyList() {
        return this.getProperty("http://schema.org/musicalKey");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicArrangementList() {
        return this.getProperty("http://schema.org/musicArrangement");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicCompositionFormList() {
        return this.getProperty("http://schema.org/musicCompositionForm");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecordedAsList() {
        return this.getProperty("http://schema.org/recordedAs");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MusicComposition.Builder>
    implements MusicComposition.Builder {
        BuilderImpl() {
        }

        @Override
        public MusicComposition.Builder addAbout(Thing value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public MusicComposition.Builder addAbout(Thing.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public MusicComposition.Builder addAbout(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAccessibilityAPI(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public MusicComposition.Builder addAccessibilityAPI(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAccessibilityControl(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public MusicComposition.Builder addAccessibilityControl(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAccessibilityFeature(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public MusicComposition.Builder addAccessibilityFeature(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAccessibilityHazard(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public MusicComposition.Builder addAccessibilityHazard(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAccountablePerson(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public MusicComposition.Builder addAccountablePerson(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public MusicComposition.Builder addAccountablePerson(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAdditionalType(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MusicComposition.Builder addAdditionalType(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAggregateRating(AggregateRating value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public MusicComposition.Builder addAggregateRating(AggregateRating.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public MusicComposition.Builder addAggregateRating(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAlternateName(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MusicComposition.Builder addAlternateName(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAlternativeHeadline(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public MusicComposition.Builder addAlternativeHeadline(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAssociatedMedia(MediaObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public MusicComposition.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public MusicComposition.Builder addAssociatedMedia(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAudience(Audience value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public MusicComposition.Builder addAudience(Audience.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public MusicComposition.Builder addAudience(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAudio(AudioObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public MusicComposition.Builder addAudio(AudioObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public MusicComposition.Builder addAudio(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAuthor(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicComposition.Builder addAuthor(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicComposition.Builder addAuthor(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicComposition.Builder addAuthor(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicComposition.Builder addAuthor(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAward(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public MusicComposition.Builder addAward(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addAwards(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public MusicComposition.Builder addAwards(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addCharacter(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public MusicComposition.Builder addCharacter(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public MusicComposition.Builder addCharacter(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addCitation(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicComposition.Builder addCitation(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public MusicComposition.Builder addCitation(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicComposition.Builder addCitation(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addComment(Comment value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public MusicComposition.Builder addComment(Comment.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public MusicComposition.Builder addComment(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addCommentCount(Integer value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public MusicComposition.Builder addCommentCount(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addComposer(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/composer", value);
        }

        @Override
        public MusicComposition.Builder addComposer(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/composer", value.build());
        }

        @Override
        public MusicComposition.Builder addComposer(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/composer", value);
        }

        @Override
        public MusicComposition.Builder addComposer(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/composer", value.build());
        }

        @Override
        public MusicComposition.Builder addComposer(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/composer", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addContentLocation(Place value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public MusicComposition.Builder addContentLocation(Place.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public MusicComposition.Builder addContentLocation(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addContentRating(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public MusicComposition.Builder addContentRating(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addContributor(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicComposition.Builder addContributor(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicComposition.Builder addContributor(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicComposition.Builder addContributor(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicComposition.Builder addContributor(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addCopyrightHolder(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicComposition.Builder addCopyrightHolder(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicComposition.Builder addCopyrightHolder(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicComposition.Builder addCopyrightHolder(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicComposition.Builder addCopyrightHolder(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addCopyrightYear(Number value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public MusicComposition.Builder addCopyrightYear(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addCreator(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicComposition.Builder addCreator(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicComposition.Builder addCreator(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicComposition.Builder addCreator(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicComposition.Builder addCreator(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addDateCreated(Date value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicComposition.Builder addDateCreated(DateTime value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicComposition.Builder addDateCreated(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addDateModified(Date value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicComposition.Builder addDateModified(DateTime value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicComposition.Builder addDateModified(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addDatePublished(Date value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public MusicComposition.Builder addDatePublished(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addDescription(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MusicComposition.Builder addDescription(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addDiscussionUrl(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public MusicComposition.Builder addDiscussionUrl(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addEditor(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public MusicComposition.Builder addEditor(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public MusicComposition.Builder addEditor(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addEducationalAlignment(AlignmentObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public MusicComposition.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public MusicComposition.Builder addEducationalAlignment(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addEducationalUse(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public MusicComposition.Builder addEducationalUse(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addEncoding(MediaObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public MusicComposition.Builder addEncoding(MediaObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public MusicComposition.Builder addEncoding(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addEncodings(MediaObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public MusicComposition.Builder addEncodings(MediaObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public MusicComposition.Builder addEncodings(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addExampleOfWork(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public MusicComposition.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public MusicComposition.Builder addExampleOfWork(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addFileFormat(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public MusicComposition.Builder addFileFormat(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addFirstPerformance(Event value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/firstPerformance", value);
        }

        @Override
        public MusicComposition.Builder addFirstPerformance(Event.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/firstPerformance", value.build());
        }

        @Override
        public MusicComposition.Builder addFirstPerformance(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/firstPerformance", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addGenre(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicComposition.Builder addGenre(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicComposition.Builder addGenre(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addHasPart(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public MusicComposition.Builder addHasPart(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public MusicComposition.Builder addHasPart(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addHeadline(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public MusicComposition.Builder addHeadline(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addImage(ImageObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicComposition.Builder addImage(ImageObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MusicComposition.Builder addImage(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicComposition.Builder addImage(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addIncludedComposition(MusicComposition value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/includedComposition", value);
        }

        @Override
        public MusicComposition.Builder addIncludedComposition(MusicComposition.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/includedComposition", value.build());
        }

        @Override
        public MusicComposition.Builder addIncludedComposition(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/includedComposition", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addInLanguage(Language value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicComposition.Builder addInLanguage(Language.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public MusicComposition.Builder addInLanguage(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicComposition.Builder addInLanguage(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addInteractionStatistic(InteractionCounter value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public MusicComposition.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public MusicComposition.Builder addInteractionStatistic(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addInteractivityType(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public MusicComposition.Builder addInteractivityType(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addIsBasedOnUrl(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public MusicComposition.Builder addIsBasedOnUrl(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addIsFamilyFriendly(Boolean value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public MusicComposition.Builder addIsFamilyFriendly(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addIsPartOf(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public MusicComposition.Builder addIsPartOf(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public MusicComposition.Builder addIsPartOf(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addIswcCode(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/iswcCode", value);
        }

        @Override
        public MusicComposition.Builder addIswcCode(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/iswcCode", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addKeywords(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public MusicComposition.Builder addKeywords(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addLearningResourceType(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public MusicComposition.Builder addLearningResourceType(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addLicense(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicComposition.Builder addLicense(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public MusicComposition.Builder addLicense(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicComposition.Builder addLicense(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addLocationCreated(Place value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public MusicComposition.Builder addLocationCreated(Place.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public MusicComposition.Builder addLocationCreated(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addLyricist(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/lyricist", value);
        }

        @Override
        public MusicComposition.Builder addLyricist(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/lyricist", value.build());
        }

        @Override
        public MusicComposition.Builder addLyricist(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/lyricist", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addLyrics(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/lyrics", value);
        }

        @Override
        public MusicComposition.Builder addLyrics(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/lyrics", value.build());
        }

        @Override
        public MusicComposition.Builder addLyrics(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/lyrics", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addMainEntity(Thing value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public MusicComposition.Builder addMainEntity(Thing.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public MusicComposition.Builder addMainEntity(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addMainEntityOfPage(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicComposition.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MusicComposition.Builder addMainEntityOfPage(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicComposition.Builder addMainEntityOfPage(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addMentions(Thing value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public MusicComposition.Builder addMentions(Thing.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public MusicComposition.Builder addMentions(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addMusicalKey(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicalKey", value);
        }

        @Override
        public MusicComposition.Builder addMusicalKey(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicalKey", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addMusicArrangement(MusicComposition value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicArrangement", value);
        }

        @Override
        public MusicComposition.Builder addMusicArrangement(MusicComposition.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicArrangement", value.build());
        }

        @Override
        public MusicComposition.Builder addMusicArrangement(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicArrangement", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addMusicCompositionForm(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicCompositionForm", value);
        }

        @Override
        public MusicComposition.Builder addMusicCompositionForm(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/musicCompositionForm", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addName(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MusicComposition.Builder addName(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addOffers(Offer value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public MusicComposition.Builder addOffers(Offer.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public MusicComposition.Builder addOffers(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addPosition(Integer value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicComposition.Builder addPosition(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicComposition.Builder addPosition(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addPotentialAction(Action value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MusicComposition.Builder addPotentialAction(Action.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MusicComposition.Builder addPotentialAction(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addProducer(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicComposition.Builder addProducer(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicComposition.Builder addProducer(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicComposition.Builder addProducer(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicComposition.Builder addProducer(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addProvider(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicComposition.Builder addProvider(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicComposition.Builder addProvider(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicComposition.Builder addProvider(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicComposition.Builder addProvider(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addPublication(PublicationEvent value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public MusicComposition.Builder addPublication(PublicationEvent.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public MusicComposition.Builder addPublication(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addPublisher(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicComposition.Builder addPublisher(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicComposition.Builder addPublisher(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicComposition.Builder addPublisher(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicComposition.Builder addPublisher(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addPublishingPrinciples(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public MusicComposition.Builder addPublishingPrinciples(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addRecordedAs(MusicRecording value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/recordedAs", value);
        }

        @Override
        public MusicComposition.Builder addRecordedAs(MusicRecording.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/recordedAs", value.build());
        }

        @Override
        public MusicComposition.Builder addRecordedAs(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/recordedAs", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addRecordedAt(Event value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public MusicComposition.Builder addRecordedAt(Event.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public MusicComposition.Builder addRecordedAt(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addReleasedEvent(PublicationEvent value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public MusicComposition.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public MusicComposition.Builder addReleasedEvent(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addReview(Review value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public MusicComposition.Builder addReview(Review.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public MusicComposition.Builder addReview(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addReviews(Review value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public MusicComposition.Builder addReviews(Review.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public MusicComposition.Builder addReviews(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addSameAs(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MusicComposition.Builder addSameAs(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addSchemaVersion(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicComposition.Builder addSchemaVersion(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicComposition.Builder addSchemaVersion(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addSourceOrganization(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public MusicComposition.Builder addSourceOrganization(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public MusicComposition.Builder addSourceOrganization(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addText(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public MusicComposition.Builder addText(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addThumbnailUrl(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public MusicComposition.Builder addThumbnailUrl(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addTimeRequired(Duration value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public MusicComposition.Builder addTimeRequired(Duration.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public MusicComposition.Builder addTimeRequired(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addTranslator(Organization value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicComposition.Builder addTranslator(Organization.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicComposition.Builder addTranslator(Person value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicComposition.Builder addTranslator(Person.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicComposition.Builder addTranslator(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addTypicalAgeRange(Text value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public MusicComposition.Builder addTypicalAgeRange(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addUrl(URL value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MusicComposition.Builder addUrl(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addVersion(Number value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public MusicComposition.Builder addVersion(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addVideo(VideoObject value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public MusicComposition.Builder addVideo(VideoObject.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public MusicComposition.Builder addVideo(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addWorkExample(CreativeWork value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public MusicComposition.Builder addWorkExample(CreativeWork.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public MusicComposition.Builder addWorkExample(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addDetailedDescription(Article value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MusicComposition.Builder addDetailedDescription(Article.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MusicComposition.Builder addDetailedDescription(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MusicComposition.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MusicComposition.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MusicComposition.Builder addPopularityScore(String value) {
            return (MusicComposition.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MusicComposition build() {
            return new MusicCompositionImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

