/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalRiskEstimatorImpl;
import com.google.schemaorg.core.MedicalRiskFactor;
import com.google.schemaorg.core.MedicalRiskScore;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalRiskScoreImpl
extends MedicalRiskEstimatorImpl
implements MedicalRiskScore {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalRiskScoreImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/algorithm");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/estimatesRiskOf");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includedRiskFactor");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalRiskScoreImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalRiskScore";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlgorithmList() {
        return this.getProperty("http://schema.org/algorithm");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalRiskScore.Builder>
    implements MedicalRiskScore.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalRiskScore.Builder addAdditionalType(URL value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalRiskScore.Builder addAdditionalType(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addAlgorithm(Text value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/algorithm", value);
        }

        @Override
        public MedicalRiskScore.Builder addAlgorithm(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/algorithm", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addAlternateName(Text value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalRiskScore.Builder addAlternateName(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addCode(MedicalCode value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalRiskScore.Builder addCode(MedicalCode.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addCode(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addDescription(Text value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalRiskScore.Builder addDescription(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addEstimatesRiskOf(MedicalEntity value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/estimatesRiskOf", value);
        }

        @Override
        public MedicalRiskScore.Builder addEstimatesRiskOf(MedicalEntity.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/estimatesRiskOf", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addEstimatesRiskOf(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/estimatesRiskOf", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addGuideline(MedicalGuideline value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalRiskScore.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addGuideline(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addImage(ImageObject value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskScore.Builder addImage(ImageObject.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addImage(URL value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskScore.Builder addImage(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addIncludedRiskFactor(MedicalRiskFactor value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/includedRiskFactor", value);
        }

        @Override
        public MedicalRiskScore.Builder addIncludedRiskFactor(MedicalRiskFactor.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/includedRiskFactor", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addIncludedRiskFactor(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/includedRiskFactor", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskScore.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addMainEntityOfPage(URL value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskScore.Builder addMainEntityOfPage(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalRiskScore.Builder addMedicineSystem(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addName(Text value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalRiskScore.Builder addName(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addPotentialAction(Action value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalRiskScore.Builder addPotentialAction(Action.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addPotentialAction(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addRecognizingAuthority(Organization value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalRiskScore.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addRecognizingAuthority(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalRiskScore.Builder addRelevantSpecialty(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addSameAs(URL value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalRiskScore.Builder addSameAs(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addStudy(MedicalStudy value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalRiskScore.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addStudy(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addUrl(URL value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalRiskScore.Builder addUrl(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addDetailedDescription(Article value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalRiskScore.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addDetailedDescription(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalRiskScore.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalRiskScore.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalRiskScore.Builder addPopularityScore(String value) {
            return (MedicalRiskScore.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalRiskScore build() {
            return new MedicalRiskScoreImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

