/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalProcedure;
import com.google.schemaorg.core.MedicalProcedureType;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalProcedureImpl
extends MedicalEntityImpl
implements MedicalProcedure {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalProcedureImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/followup");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/howPerformed");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/preparation");
        builder.add((Object)"http://schema.org/procedureType");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalProcedureImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalProcedure";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getFollowupList() {
        return this.getProperty("http://schema.org/followup");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHowPerformedList() {
        return this.getProperty("http://schema.org/howPerformed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPreparationList() {
        return this.getProperty("http://schema.org/preparation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProcedureTypeList() {
        return this.getProperty("http://schema.org/procedureType");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalProcedure.Builder>
    implements MedicalProcedure.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalProcedure.Builder addAdditionalType(URL value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalProcedure.Builder addAdditionalType(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addAlternateName(Text value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalProcedure.Builder addAlternateName(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addCode(MedicalCode value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalProcedure.Builder addCode(MedicalCode.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalProcedure.Builder addCode(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addDescription(Text value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalProcedure.Builder addDescription(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addFollowup(Text value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/followup", value);
        }

        @Override
        public MedicalProcedure.Builder addFollowup(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/followup", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addGuideline(MedicalGuideline value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalProcedure.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalProcedure.Builder addGuideline(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addHowPerformed(Text value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/howPerformed", value);
        }

        @Override
        public MedicalProcedure.Builder addHowPerformed(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/howPerformed", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addImage(ImageObject value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalProcedure.Builder addImage(ImageObject.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalProcedure.Builder addImage(URL value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalProcedure.Builder addImage(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalProcedure.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalProcedure.Builder addMainEntityOfPage(URL value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalProcedure.Builder addMainEntityOfPage(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalProcedure.Builder addMedicineSystem(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addName(Text value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalProcedure.Builder addName(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addPotentialAction(Action value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalProcedure.Builder addPotentialAction(Action.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalProcedure.Builder addPotentialAction(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addPreparation(Text value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/preparation", value);
        }

        @Override
        public MedicalProcedure.Builder addPreparation(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/preparation", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addProcedureType(MedicalProcedureType value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/procedureType", value);
        }

        @Override
        public MedicalProcedure.Builder addProcedureType(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/procedureType", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addRecognizingAuthority(Organization value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalProcedure.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalProcedure.Builder addRecognizingAuthority(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalProcedure.Builder addRelevantSpecialty(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addSameAs(URL value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalProcedure.Builder addSameAs(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addStudy(MedicalStudy value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalProcedure.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalProcedure.Builder addStudy(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addUrl(URL value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalProcedure.Builder addUrl(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addDetailedDescription(Article value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalProcedure.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalProcedure.Builder addDetailedDescription(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalProcedure.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalProcedure.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalProcedure.Builder addPopularityScore(String value) {
            return (MedicalProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalProcedure build() {
            return new MedicalProcedureImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

