/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalIndicationImpl
extends MedicalEntityImpl
implements MedicalIndication {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalIndicationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalIndicationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalIndication";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalIndication.Builder>
    implements MedicalIndication.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalIndication.Builder addAdditionalType(URL value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalIndication.Builder addAdditionalType(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addAlternateName(Text value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalIndication.Builder addAlternateName(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addCode(MedicalCode value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalIndication.Builder addCode(MedicalCode.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalIndication.Builder addCode(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addDescription(Text value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalIndication.Builder addDescription(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addGuideline(MedicalGuideline value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalIndication.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalIndication.Builder addGuideline(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addImage(ImageObject value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalIndication.Builder addImage(ImageObject.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalIndication.Builder addImage(URL value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalIndication.Builder addImage(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalIndication.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalIndication.Builder addMainEntityOfPage(URL value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalIndication.Builder addMainEntityOfPage(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalIndication.Builder addMedicineSystem(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addName(Text value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalIndication.Builder addName(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addPotentialAction(Action value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalIndication.Builder addPotentialAction(Action.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalIndication.Builder addPotentialAction(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addRecognizingAuthority(Organization value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalIndication.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalIndication.Builder addRecognizingAuthority(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalIndication.Builder addRelevantSpecialty(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addSameAs(URL value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalIndication.Builder addSameAs(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addStudy(MedicalStudy value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalIndication.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalIndication.Builder addStudy(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addUrl(URL value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalIndication.Builder addUrl(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addDetailedDescription(Article value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalIndication.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalIndication.Builder addDetailedDescription(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalIndication.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalIndication.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalIndication.Builder addPopularityScore(String value) {
            return (MedicalIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalIndication build() {
            return new MedicalIndicationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

