/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalConditionStage;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalConditionStageImpl
extends MedicalIntangibleImpl
implements MedicalConditionStage {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalConditionStageImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/stageAsNumber");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStageSuffix");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalConditionStageImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalConditionStage";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getStageAsNumberList() {
        return this.getProperty("http://schema.org/stageAsNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubStageSuffixList() {
        return this.getProperty("http://schema.org/subStageSuffix");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalConditionStage.Builder>
    implements MedicalConditionStage.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalConditionStage.Builder addAdditionalType(URL value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalConditionStage.Builder addAdditionalType(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addAlternateName(Text value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalConditionStage.Builder addAlternateName(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addCode(MedicalCode value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalConditionStage.Builder addCode(MedicalCode.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addCode(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addDescription(Text value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalConditionStage.Builder addDescription(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addGuideline(MedicalGuideline value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalConditionStage.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addGuideline(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addImage(ImageObject value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalConditionStage.Builder addImage(ImageObject.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addImage(URL value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalConditionStage.Builder addImage(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalConditionStage.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addMainEntityOfPage(URL value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalConditionStage.Builder addMainEntityOfPage(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalConditionStage.Builder addMedicineSystem(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addName(Text value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalConditionStage.Builder addName(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addPotentialAction(Action value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalConditionStage.Builder addPotentialAction(Action.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addPotentialAction(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addRecognizingAuthority(Organization value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalConditionStage.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addRecognizingAuthority(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalConditionStage.Builder addRelevantSpecialty(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addSameAs(URL value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalConditionStage.Builder addSameAs(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addStageAsNumber(Number value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/stageAsNumber", value);
        }

        @Override
        public MedicalConditionStage.Builder addStageAsNumber(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/stageAsNumber", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addStudy(MedicalStudy value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalConditionStage.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addStudy(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addSubStageSuffix(Text value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/subStageSuffix", value);
        }

        @Override
        public MedicalConditionStage.Builder addSubStageSuffix(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/subStageSuffix", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addUrl(URL value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalConditionStage.Builder addUrl(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addDetailedDescription(Article value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalConditionStage.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addDetailedDescription(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalConditionStage.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalConditionStage.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalConditionStage.Builder addPopularityScore(String value) {
            return (MedicalConditionStage.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalConditionStage build() {
            return new MedicalConditionStageImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

