/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.ImagingTest;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalImagingTechnique;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTestImpl;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ImagingTestImpl
extends MedicalTestImpl
implements ImagingTest {
    private static final ImmutableSet<String> PROPERTY_SET = ImagingTestImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/affectedBy");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/imagingTechnique");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/normalRange");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/signDetected");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/usedToDiagnose");
        builder.add((Object)"http://schema.org/usesDevice");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ImagingTestImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/ImagingTest";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getImagingTechniqueList() {
        return this.getProperty("http://schema.org/imagingTechnique");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<ImagingTest.Builder>
    implements ImagingTest.Builder {
        BuilderImpl() {
        }

        @Override
        public ImagingTest.Builder addAdditionalType(URL value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public ImagingTest.Builder addAdditionalType(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addAffectedBy(Drug value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/affectedBy", value);
        }

        @Override
        public ImagingTest.Builder addAffectedBy(Drug.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/affectedBy", value.build());
        }

        @Override
        public ImagingTest.Builder addAffectedBy(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/affectedBy", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addAlternateName(Text value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public ImagingTest.Builder addAlternateName(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addCode(MedicalCode value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public ImagingTest.Builder addCode(MedicalCode.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public ImagingTest.Builder addCode(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addDescription(Text value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public ImagingTest.Builder addDescription(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addGuideline(MedicalGuideline value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public ImagingTest.Builder addGuideline(MedicalGuideline.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public ImagingTest.Builder addGuideline(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addImage(ImageObject value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ImagingTest.Builder addImage(ImageObject.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public ImagingTest.Builder addImage(URL value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ImagingTest.Builder addImage(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addImagingTechnique(MedicalImagingTechnique value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/imagingTechnique", value);
        }

        @Override
        public ImagingTest.Builder addImagingTechnique(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/imagingTechnique", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addMainEntityOfPage(CreativeWork value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ImagingTest.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public ImagingTest.Builder addMainEntityOfPage(URL value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ImagingTest.Builder addMainEntityOfPage(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addMedicineSystem(MedicineSystem value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public ImagingTest.Builder addMedicineSystem(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addName(Text value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public ImagingTest.Builder addName(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addNormalRange(Text value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/normalRange", value);
        }

        @Override
        public ImagingTest.Builder addNormalRange(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/normalRange", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addPotentialAction(Action value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public ImagingTest.Builder addPotentialAction(Action.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public ImagingTest.Builder addPotentialAction(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addRecognizingAuthority(Organization value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public ImagingTest.Builder addRecognizingAuthority(Organization.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public ImagingTest.Builder addRecognizingAuthority(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public ImagingTest.Builder addRelevantSpecialty(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addSameAs(URL value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public ImagingTest.Builder addSameAs(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addSignDetected(MedicalSign value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/signDetected", value);
        }

        @Override
        public ImagingTest.Builder addSignDetected(MedicalSign.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/signDetected", value.build());
        }

        @Override
        public ImagingTest.Builder addSignDetected(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/signDetected", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addStudy(MedicalStudy value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public ImagingTest.Builder addStudy(MedicalStudy.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public ImagingTest.Builder addStudy(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addUrl(URL value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public ImagingTest.Builder addUrl(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addUsedToDiagnose(MedicalCondition value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value);
        }

        @Override
        public ImagingTest.Builder addUsedToDiagnose(MedicalCondition.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value.build());
        }

        @Override
        public ImagingTest.Builder addUsedToDiagnose(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addUsesDevice(MedicalDevice value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/usesDevice", value);
        }

        @Override
        public ImagingTest.Builder addUsesDevice(MedicalDevice.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/usesDevice", value.build());
        }

        @Override
        public ImagingTest.Builder addUsesDevice(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.org/usesDevice", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addDetailedDescription(Article value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public ImagingTest.Builder addDetailedDescription(Article.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public ImagingTest.Builder addDetailedDescription(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public ImagingTest.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public ImagingTest.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public ImagingTest.Builder addPopularityScore(String value) {
            return (ImagingTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public ImagingTest build() {
            return new ImagingTestImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

