/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.GameServer;
import com.google.schemaorg.core.GameServerStatus;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoGame;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class GameServerImpl
extends IntangibleImpl
implements GameServer {
    private static final ImmutableSet<String> PROPERTY_SET = GameServerImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/game");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/playersOnline");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/serverStatus");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public GameServerImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/GameServer";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getGameList() {
        return this.getProperty("http://schema.org/game");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPlayersOnlineList() {
        return this.getProperty("http://schema.org/playersOnline");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServerStatusList() {
        return this.getProperty("http://schema.org/serverStatus");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<GameServer.Builder>
    implements GameServer.Builder {
        BuilderImpl() {
        }

        @Override
        public GameServer.Builder addAdditionalType(URL value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public GameServer.Builder addAdditionalType(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public GameServer.Builder addAlternateName(Text value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public GameServer.Builder addAlternateName(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public GameServer.Builder addDescription(Text value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public GameServer.Builder addDescription(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public GameServer.Builder addGame(VideoGame value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/game", value);
        }

        @Override
        public GameServer.Builder addGame(VideoGame.Builder value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/game", value.build());
        }

        @Override
        public GameServer.Builder addGame(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/game", Text.of(value));
        }

        @Override
        public GameServer.Builder addImage(ImageObject value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public GameServer.Builder addImage(ImageObject.Builder value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public GameServer.Builder addImage(URL value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public GameServer.Builder addImage(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public GameServer.Builder addMainEntityOfPage(CreativeWork value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public GameServer.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public GameServer.Builder addMainEntityOfPage(URL value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public GameServer.Builder addMainEntityOfPage(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public GameServer.Builder addName(Text value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public GameServer.Builder addName(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public GameServer.Builder addPlayersOnline(Integer value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/playersOnline", value);
        }

        @Override
        public GameServer.Builder addPlayersOnline(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/playersOnline", Text.of(value));
        }

        @Override
        public GameServer.Builder addPotentialAction(Action value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public GameServer.Builder addPotentialAction(Action.Builder value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public GameServer.Builder addPotentialAction(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public GameServer.Builder addSameAs(URL value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public GameServer.Builder addSameAs(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public GameServer.Builder addServerStatus(GameServerStatus value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/serverStatus", value);
        }

        @Override
        public GameServer.Builder addServerStatus(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/serverStatus", Text.of(value));
        }

        @Override
        public GameServer.Builder addUrl(URL value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public GameServer.Builder addUrl(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public GameServer.Builder addDetailedDescription(Article value) {
            return (GameServer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public GameServer.Builder addDetailedDescription(Article.Builder value) {
            return (GameServer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public GameServer.Builder addDetailedDescription(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public GameServer.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (GameServer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public GameServer.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (GameServer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public GameServer.Builder addPopularityScore(String value) {
            return (GameServer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public GameServer build() {
            return new GameServerImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

