/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.Game;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class GameImpl
extends CreativeWorkImpl
implements Game {
    private static final ImmutableSet<String> PROPERTY_SET = GameImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/characterAttribute");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/gameItem");
        builder.add((Object)"http://schema.org/gameLocation");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numberOfPlayers");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/quest");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public GameImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Game";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCharacterAttributeList() {
        return this.getProperty("http://schema.org/characterAttribute");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGameItemList() {
        return this.getProperty("http://schema.org/gameItem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGameLocationList() {
        return this.getProperty("http://schema.org/gameLocation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNumberOfPlayersList() {
        return this.getProperty("http://schema.org/numberOfPlayers");
    }

    @Override
    public ImmutableList<SchemaOrgType> getQuestList() {
        return this.getProperty("http://schema.org/quest");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Game.Builder>
    implements Game.Builder {
        BuilderImpl() {
        }

        @Override
        public Game.Builder addAbout(Thing value) {
            return (Game.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Game.Builder addAbout(Thing.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Game.Builder addAbout(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Game.Builder addAccessibilityAPI(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Game.Builder addAccessibilityAPI(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Game.Builder addAccessibilityControl(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Game.Builder addAccessibilityControl(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Game.Builder addAccessibilityFeature(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Game.Builder addAccessibilityFeature(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Game.Builder addAccessibilityHazard(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Game.Builder addAccessibilityHazard(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Game.Builder addAccountablePerson(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Game.Builder addAccountablePerson(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Game.Builder addAccountablePerson(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Game.Builder addAdditionalType(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Game.Builder addAdditionalType(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Game.Builder addAggregateRating(AggregateRating value) {
            return (Game.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Game.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Game.Builder addAggregateRating(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Game.Builder addAlternateName(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Game.Builder addAlternateName(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Game.Builder addAlternativeHeadline(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Game.Builder addAlternativeHeadline(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Game.Builder addAssociatedMedia(MediaObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Game.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Game.Builder addAssociatedMedia(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Game.Builder addAudience(Audience value) {
            return (Game.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Game.Builder addAudience(Audience.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Game.Builder addAudience(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Game.Builder addAudio(AudioObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Game.Builder addAudio(AudioObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Game.Builder addAudio(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Game.Builder addAuthor(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Game.Builder addAuthor(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Game.Builder addAuthor(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Game.Builder addAuthor(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Game.Builder addAuthor(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Game.Builder addAward(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Game.Builder addAward(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Game.Builder addAwards(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Game.Builder addAwards(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Game.Builder addCharacter(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Game.Builder addCharacter(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Game.Builder addCharacter(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Game.Builder addCharacterAttribute(Thing value) {
            return (Game.Builder)this.addProperty("http://schema.org/characterAttribute", value);
        }

        @Override
        public Game.Builder addCharacterAttribute(Thing.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/characterAttribute", value.build());
        }

        @Override
        public Game.Builder addCharacterAttribute(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/characterAttribute", Text.of(value));
        }

        @Override
        public Game.Builder addCitation(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Game.Builder addCitation(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Game.Builder addCitation(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Game.Builder addCitation(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Game.Builder addComment(Comment value) {
            return (Game.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Game.Builder addComment(Comment.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Game.Builder addComment(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Game.Builder addCommentCount(Integer value) {
            return (Game.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Game.Builder addCommentCount(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Game.Builder addContentLocation(Place value) {
            return (Game.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Game.Builder addContentLocation(Place.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Game.Builder addContentLocation(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Game.Builder addContentRating(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Game.Builder addContentRating(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Game.Builder addContributor(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Game.Builder addContributor(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Game.Builder addContributor(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Game.Builder addContributor(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Game.Builder addContributor(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Game.Builder addCopyrightHolder(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Game.Builder addCopyrightHolder(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Game.Builder addCopyrightHolder(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Game.Builder addCopyrightHolder(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Game.Builder addCopyrightHolder(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Game.Builder addCopyrightYear(Number value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Game.Builder addCopyrightYear(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Game.Builder addCreator(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Game.Builder addCreator(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Game.Builder addCreator(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Game.Builder addCreator(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Game.Builder addCreator(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Game.Builder addDateCreated(Date value) {
            return (Game.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Game.Builder addDateCreated(DateTime value) {
            return (Game.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Game.Builder addDateCreated(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Game.Builder addDateModified(Date value) {
            return (Game.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Game.Builder addDateModified(DateTime value) {
            return (Game.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Game.Builder addDateModified(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Game.Builder addDatePublished(Date value) {
            return (Game.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Game.Builder addDatePublished(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Game.Builder addDescription(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Game.Builder addDescription(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Game.Builder addDiscussionUrl(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Game.Builder addDiscussionUrl(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Game.Builder addEditor(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Game.Builder addEditor(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Game.Builder addEditor(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Game.Builder addEducationalAlignment(AlignmentObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Game.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Game.Builder addEducationalAlignment(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Game.Builder addEducationalUse(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Game.Builder addEducationalUse(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Game.Builder addEncoding(MediaObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Game.Builder addEncoding(MediaObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Game.Builder addEncoding(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Game.Builder addEncodings(MediaObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Game.Builder addEncodings(MediaObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Game.Builder addEncodings(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Game.Builder addExampleOfWork(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Game.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Game.Builder addExampleOfWork(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Game.Builder addFileFormat(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Game.Builder addFileFormat(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Game.Builder addGameItem(Thing value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameItem", value);
        }

        @Override
        public Game.Builder addGameItem(Thing.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameItem", value.build());
        }

        @Override
        public Game.Builder addGameItem(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameItem", Text.of(value));
        }

        @Override
        public Game.Builder addGameLocation(Place value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameLocation", value);
        }

        @Override
        public Game.Builder addGameLocation(Place.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameLocation", value.build());
        }

        @Override
        public Game.Builder addGameLocation(PostalAddress value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameLocation", value);
        }

        @Override
        public Game.Builder addGameLocation(PostalAddress.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameLocation", value.build());
        }

        @Override
        public Game.Builder addGameLocation(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameLocation", value);
        }

        @Override
        public Game.Builder addGameLocation(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/gameLocation", Text.of(value));
        }

        @Override
        public Game.Builder addGenre(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Game.Builder addGenre(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Game.Builder addGenre(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Game.Builder addHasPart(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Game.Builder addHasPart(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Game.Builder addHasPart(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Game.Builder addHeadline(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Game.Builder addHeadline(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Game.Builder addImage(ImageObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Game.Builder addImage(ImageObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Game.Builder addImage(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Game.Builder addImage(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Game.Builder addInLanguage(Language value) {
            return (Game.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Game.Builder addInLanguage(Language.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Game.Builder addInLanguage(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Game.Builder addInLanguage(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Game.Builder addInteractionStatistic(InteractionCounter value) {
            return (Game.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Game.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Game.Builder addInteractionStatistic(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Game.Builder addInteractivityType(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Game.Builder addInteractivityType(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Game.Builder addIsBasedOnUrl(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Game.Builder addIsBasedOnUrl(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Game.Builder addIsFamilyFriendly(Boolean value) {
            return (Game.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Game.Builder addIsFamilyFriendly(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Game.Builder addIsPartOf(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Game.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Game.Builder addIsPartOf(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Game.Builder addKeywords(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Game.Builder addKeywords(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Game.Builder addLearningResourceType(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Game.Builder addLearningResourceType(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Game.Builder addLicense(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Game.Builder addLicense(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Game.Builder addLicense(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Game.Builder addLicense(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Game.Builder addLocationCreated(Place value) {
            return (Game.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Game.Builder addLocationCreated(Place.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Game.Builder addLocationCreated(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Game.Builder addMainEntity(Thing value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Game.Builder addMainEntity(Thing.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Game.Builder addMainEntity(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Game.Builder addMainEntityOfPage(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Game.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Game.Builder addMainEntityOfPage(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Game.Builder addMainEntityOfPage(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Game.Builder addMentions(Thing value) {
            return (Game.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Game.Builder addMentions(Thing.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Game.Builder addMentions(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Game.Builder addName(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Game.Builder addName(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Game.Builder addNumberOfPlayers(QuantitativeValue value) {
            return (Game.Builder)this.addProperty("http://schema.org/numberOfPlayers", value);
        }

        @Override
        public Game.Builder addNumberOfPlayers(QuantitativeValue.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/numberOfPlayers", value.build());
        }

        @Override
        public Game.Builder addNumberOfPlayers(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/numberOfPlayers", Text.of(value));
        }

        @Override
        public Game.Builder addOffers(Offer value) {
            return (Game.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Game.Builder addOffers(Offer.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Game.Builder addOffers(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Game.Builder addPosition(Integer value) {
            return (Game.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Game.Builder addPosition(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Game.Builder addPosition(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Game.Builder addPotentialAction(Action value) {
            return (Game.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Game.Builder addPotentialAction(Action.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Game.Builder addPotentialAction(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Game.Builder addProducer(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Game.Builder addProducer(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Game.Builder addProducer(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Game.Builder addProducer(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Game.Builder addProducer(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Game.Builder addProvider(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Game.Builder addProvider(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Game.Builder addProvider(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Game.Builder addProvider(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Game.Builder addProvider(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Game.Builder addPublication(PublicationEvent value) {
            return (Game.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Game.Builder addPublication(PublicationEvent.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Game.Builder addPublication(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Game.Builder addPublisher(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Game.Builder addPublisher(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Game.Builder addPublisher(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Game.Builder addPublisher(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Game.Builder addPublisher(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Game.Builder addPublishingPrinciples(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Game.Builder addPublishingPrinciples(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Game.Builder addQuest(Thing value) {
            return (Game.Builder)this.addProperty("http://schema.org/quest", value);
        }

        @Override
        public Game.Builder addQuest(Thing.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/quest", value.build());
        }

        @Override
        public Game.Builder addQuest(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/quest", Text.of(value));
        }

        @Override
        public Game.Builder addRecordedAt(Event value) {
            return (Game.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Game.Builder addRecordedAt(Event.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Game.Builder addRecordedAt(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Game.Builder addReleasedEvent(PublicationEvent value) {
            return (Game.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Game.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Game.Builder addReleasedEvent(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Game.Builder addReview(Review value) {
            return (Game.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Game.Builder addReview(Review.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Game.Builder addReview(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Game.Builder addReviews(Review value) {
            return (Game.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Game.Builder addReviews(Review.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Game.Builder addReviews(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Game.Builder addSameAs(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Game.Builder addSameAs(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Game.Builder addSchemaVersion(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Game.Builder addSchemaVersion(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Game.Builder addSchemaVersion(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Game.Builder addSourceOrganization(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Game.Builder addSourceOrganization(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Game.Builder addSourceOrganization(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Game.Builder addText(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Game.Builder addText(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Game.Builder addThumbnailUrl(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Game.Builder addThumbnailUrl(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Game.Builder addTimeRequired(Duration value) {
            return (Game.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Game.Builder addTimeRequired(Duration.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Game.Builder addTimeRequired(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Game.Builder addTranslator(Organization value) {
            return (Game.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Game.Builder addTranslator(Organization.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Game.Builder addTranslator(Person value) {
            return (Game.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Game.Builder addTranslator(Person.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Game.Builder addTranslator(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Game.Builder addTypicalAgeRange(Text value) {
            return (Game.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Game.Builder addTypicalAgeRange(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Game.Builder addUrl(URL value) {
            return (Game.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Game.Builder addUrl(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Game.Builder addVersion(Number value) {
            return (Game.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Game.Builder addVersion(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Game.Builder addVideo(VideoObject value) {
            return (Game.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Game.Builder addVideo(VideoObject.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Game.Builder addVideo(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Game.Builder addWorkExample(CreativeWork value) {
            return (Game.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Game.Builder addWorkExample(CreativeWork.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Game.Builder addWorkExample(String value) {
            return (Game.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Game.Builder addDetailedDescription(Article value) {
            return (Game.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Game.Builder addDetailedDescription(Article.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Game.Builder addDetailedDescription(String value) {
            return (Game.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Game.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Game.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Game.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Game.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Game.Builder addPopularityScore(String value) {
            return (Game.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Game build() {
            return new GameImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

