/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.EventStatusType;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.ThingImpl;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EventImpl
extends ThingImpl
implements Event {
    private static final ImmutableSet<String> PROPERTY_SET = EventImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/attendee");
        builder.add((Object)"http://schema.org/attendees");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/doorTime");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/eventStatus");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/location");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/organizer");
        builder.add((Object)"http://schema.org/performer");
        builder.add((Object)"http://schema.org/performers");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/previousStartDate");
        builder.add((Object)"http://schema.org/recordedIn");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/subEvent");
        builder.add((Object)"http://schema.org/subEvents");
        builder.add((Object)"http://schema.org/superEvent");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/workFeatured");
        builder.add((Object)"http://schema.org/workPerformed");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EventImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Event";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAggregateRatingList() {
        return this.getProperty("http://schema.org/aggregateRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAttendeeList() {
        return this.getProperty("http://schema.org/attendee");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAttendeesList() {
        return this.getProperty("http://schema.org/attendees");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDoorTimeList() {
        return this.getProperty("http://schema.org/doorTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDurationList() {
        return this.getProperty("http://schema.org/duration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEndDateList() {
        return this.getProperty("http://schema.org/endDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEventStatusList() {
        return this.getProperty("http://schema.org/eventStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInLanguageList() {
        return this.getProperty("http://schema.org/inLanguage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLocationList() {
        return this.getProperty("http://schema.org/location");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOffersList() {
        return this.getProperty("http://schema.org/offers");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrganizerList() {
        return this.getProperty("http://schema.org/organizer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPerformerList() {
        return this.getProperty("http://schema.org/performer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPerformersList() {
        return this.getProperty("http://schema.org/performers");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPreviousStartDateList() {
        return this.getProperty("http://schema.org/previousStartDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecordedInList() {
        return this.getProperty("http://schema.org/recordedIn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewList() {
        return this.getProperty("http://schema.org/review");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStartDateList() {
        return this.getProperty("http://schema.org/startDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubEventList() {
        return this.getProperty("http://schema.org/subEvent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubEventsList() {
        return this.getProperty("http://schema.org/subEvents");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSuperEventList() {
        return this.getProperty("http://schema.org/superEvent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTypicalAgeRangeList() {
        return this.getProperty("http://schema.org/typicalAgeRange");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWorkFeaturedList() {
        return this.getProperty("http://schema.org/workFeatured");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWorkPerformedList() {
        return this.getProperty("http://schema.org/workPerformed");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Event.Builder>
    implements Event.Builder {
        BuilderImpl() {
        }

        @Override
        public Event.Builder addAdditionalType(URL value) {
            return (Event.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Event.Builder addAdditionalType(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Event.Builder addAggregateRating(AggregateRating value) {
            return (Event.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Event.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Event.Builder addAggregateRating(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Event.Builder addAlternateName(Text value) {
            return (Event.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Event.Builder addAlternateName(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Event.Builder addAttendee(Organization value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendee", value);
        }

        @Override
        public Event.Builder addAttendee(Organization.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendee", value.build());
        }

        @Override
        public Event.Builder addAttendee(Person value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendee", value);
        }

        @Override
        public Event.Builder addAttendee(Person.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendee", value.build());
        }

        @Override
        public Event.Builder addAttendee(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendee", Text.of(value));
        }

        @Override
        public Event.Builder addAttendees(Organization value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendees", value);
        }

        @Override
        public Event.Builder addAttendees(Organization.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendees", value.build());
        }

        @Override
        public Event.Builder addAttendees(Person value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendees", value);
        }

        @Override
        public Event.Builder addAttendees(Person.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendees", value.build());
        }

        @Override
        public Event.Builder addAttendees(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/attendees", Text.of(value));
        }

        @Override
        public Event.Builder addDescription(Text value) {
            return (Event.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Event.Builder addDescription(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Event.Builder addDoorTime(DateTime value) {
            return (Event.Builder)this.addProperty("http://schema.org/doorTime", value);
        }

        @Override
        public Event.Builder addDoorTime(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/doorTime", Text.of(value));
        }

        @Override
        public Event.Builder addDuration(Duration value) {
            return (Event.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public Event.Builder addDuration(Duration.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public Event.Builder addDuration(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public Event.Builder addEndDate(Date value) {
            return (Event.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public Event.Builder addEndDate(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public Event.Builder addEventStatus(EventStatusType value) {
            return (Event.Builder)this.addProperty("http://schema.org/eventStatus", value);
        }

        @Override
        public Event.Builder addEventStatus(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/eventStatus", Text.of(value));
        }

        @Override
        public Event.Builder addImage(ImageObject value) {
            return (Event.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Event.Builder addImage(ImageObject.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Event.Builder addImage(URL value) {
            return (Event.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Event.Builder addImage(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Event.Builder addInLanguage(Language value) {
            return (Event.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Event.Builder addInLanguage(Language.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Event.Builder addInLanguage(Text value) {
            return (Event.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Event.Builder addInLanguage(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Event.Builder addLocation(Place value) {
            return (Event.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public Event.Builder addLocation(Place.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public Event.Builder addLocation(PostalAddress value) {
            return (Event.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public Event.Builder addLocation(PostalAddress.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public Event.Builder addLocation(Text value) {
            return (Event.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public Event.Builder addLocation(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/location", Text.of(value));
        }

        @Override
        public Event.Builder addMainEntityOfPage(CreativeWork value) {
            return (Event.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Event.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Event.Builder addMainEntityOfPage(URL value) {
            return (Event.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Event.Builder addMainEntityOfPage(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Event.Builder addName(Text value) {
            return (Event.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Event.Builder addName(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Event.Builder addOffers(Offer value) {
            return (Event.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Event.Builder addOffers(Offer.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Event.Builder addOffers(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Event.Builder addOrganizer(Organization value) {
            return (Event.Builder)this.addProperty("http://schema.org/organizer", value);
        }

        @Override
        public Event.Builder addOrganizer(Organization.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/organizer", value.build());
        }

        @Override
        public Event.Builder addOrganizer(Person value) {
            return (Event.Builder)this.addProperty("http://schema.org/organizer", value);
        }

        @Override
        public Event.Builder addOrganizer(Person.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/organizer", value.build());
        }

        @Override
        public Event.Builder addOrganizer(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/organizer", Text.of(value));
        }

        @Override
        public Event.Builder addPerformer(Organization value) {
            return (Event.Builder)this.addProperty("http://schema.org/performer", value);
        }

        @Override
        public Event.Builder addPerformer(Organization.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/performer", value.build());
        }

        @Override
        public Event.Builder addPerformer(Person value) {
            return (Event.Builder)this.addProperty("http://schema.org/performer", value);
        }

        @Override
        public Event.Builder addPerformer(Person.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/performer", value.build());
        }

        @Override
        public Event.Builder addPerformer(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/performer", Text.of(value));
        }

        @Override
        public Event.Builder addPerformers(Organization value) {
            return (Event.Builder)this.addProperty("http://schema.org/performers", value);
        }

        @Override
        public Event.Builder addPerformers(Organization.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/performers", value.build());
        }

        @Override
        public Event.Builder addPerformers(Person value) {
            return (Event.Builder)this.addProperty("http://schema.org/performers", value);
        }

        @Override
        public Event.Builder addPerformers(Person.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/performers", value.build());
        }

        @Override
        public Event.Builder addPerformers(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/performers", Text.of(value));
        }

        @Override
        public Event.Builder addPotentialAction(Action value) {
            return (Event.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Event.Builder addPotentialAction(Action.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Event.Builder addPotentialAction(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Event.Builder addPreviousStartDate(Date value) {
            return (Event.Builder)this.addProperty("http://schema.org/previousStartDate", value);
        }

        @Override
        public Event.Builder addPreviousStartDate(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/previousStartDate", Text.of(value));
        }

        @Override
        public Event.Builder addRecordedIn(CreativeWork value) {
            return (Event.Builder)this.addProperty("http://schema.org/recordedIn", value);
        }

        @Override
        public Event.Builder addRecordedIn(CreativeWork.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/recordedIn", value.build());
        }

        @Override
        public Event.Builder addRecordedIn(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/recordedIn", Text.of(value));
        }

        @Override
        public Event.Builder addReview(Review value) {
            return (Event.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Event.Builder addReview(Review.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Event.Builder addReview(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Event.Builder addSameAs(URL value) {
            return (Event.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Event.Builder addSameAs(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Event.Builder addStartDate(Date value) {
            return (Event.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public Event.Builder addStartDate(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public Event.Builder addSubEvent(Event value) {
            return (Event.Builder)this.addProperty("http://schema.org/subEvent", value);
        }

        @Override
        public Event.Builder addSubEvent(Event.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/subEvent", value.build());
        }

        @Override
        public Event.Builder addSubEvent(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/subEvent", Text.of(value));
        }

        @Override
        public Event.Builder addSubEvents(Event value) {
            return (Event.Builder)this.addProperty("http://schema.org/subEvents", value);
        }

        @Override
        public Event.Builder addSubEvents(Event.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/subEvents", value.build());
        }

        @Override
        public Event.Builder addSubEvents(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/subEvents", Text.of(value));
        }

        @Override
        public Event.Builder addSuperEvent(Event value) {
            return (Event.Builder)this.addProperty("http://schema.org/superEvent", value);
        }

        @Override
        public Event.Builder addSuperEvent(Event.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/superEvent", value.build());
        }

        @Override
        public Event.Builder addSuperEvent(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/superEvent", Text.of(value));
        }

        @Override
        public Event.Builder addTypicalAgeRange(Text value) {
            return (Event.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Event.Builder addTypicalAgeRange(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Event.Builder addUrl(URL value) {
            return (Event.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Event.Builder addUrl(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Event.Builder addWorkFeatured(CreativeWork value) {
            return (Event.Builder)this.addProperty("http://schema.org/workFeatured", value);
        }

        @Override
        public Event.Builder addWorkFeatured(CreativeWork.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/workFeatured", value.build());
        }

        @Override
        public Event.Builder addWorkFeatured(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/workFeatured", Text.of(value));
        }

        @Override
        public Event.Builder addWorkPerformed(CreativeWork value) {
            return (Event.Builder)this.addProperty("http://schema.org/workPerformed", value);
        }

        @Override
        public Event.Builder addWorkPerformed(CreativeWork.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.org/workPerformed", value.build());
        }

        @Override
        public Event.Builder addWorkPerformed(String value) {
            return (Event.Builder)this.addProperty("http://schema.org/workPerformed", Text.of(value));
        }

        @Override
        public Event.Builder addDetailedDescription(Article value) {
            return (Event.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Event.Builder addDetailedDescription(Article.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Event.Builder addDetailedDescription(String value) {
            return (Event.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Event.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Event.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Event.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Event.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Event.Builder addPopularityScore(String value) {
            return (Event.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Event build() {
            return new EventImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

