/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.EngineSpecification;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.QualitativeValue;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EngineSpecificationImpl
extends StructuredValueImpl
implements EngineSpecification {
    private static final ImmutableSet<String> PROPERTY_SET = EngineSpecificationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/fuelType");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EngineSpecificationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/EngineSpecification";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getFuelTypeList() {
        return this.getProperty("http://schema.org/fuelType");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<EngineSpecification.Builder>
    implements EngineSpecification.Builder {
        BuilderImpl() {
        }

        @Override
        public EngineSpecification.Builder addAdditionalType(URL value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public EngineSpecification.Builder addAdditionalType(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addAlternateName(Text value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public EngineSpecification.Builder addAlternateName(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addDescription(Text value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public EngineSpecification.Builder addDescription(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addFuelType(QualitativeValue value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/fuelType", value);
        }

        @Override
        public EngineSpecification.Builder addFuelType(Text value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/fuelType", value);
        }

        @Override
        public EngineSpecification.Builder addFuelType(URL value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/fuelType", value);
        }

        @Override
        public EngineSpecification.Builder addFuelType(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/fuelType", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addImage(ImageObject value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EngineSpecification.Builder addImage(ImageObject.Builder value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public EngineSpecification.Builder addImage(URL value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EngineSpecification.Builder addImage(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addMainEntityOfPage(CreativeWork value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EngineSpecification.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public EngineSpecification.Builder addMainEntityOfPage(URL value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EngineSpecification.Builder addMainEntityOfPage(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addName(Text value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public EngineSpecification.Builder addName(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addPotentialAction(Action value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public EngineSpecification.Builder addPotentialAction(Action.Builder value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public EngineSpecification.Builder addPotentialAction(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addSameAs(URL value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public EngineSpecification.Builder addSameAs(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addUrl(URL value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public EngineSpecification.Builder addUrl(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addDetailedDescription(Article value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public EngineSpecification.Builder addDetailedDescription(Article.Builder value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public EngineSpecification.Builder addDetailedDescription(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public EngineSpecification.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public EngineSpecification.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public EngineSpecification.Builder addPopularityScore(String value) {
            return (EngineSpecification.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public EngineSpecification build() {
            return new EngineSpecificationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

