/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Energy;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.QuantityImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EnergyImpl
extends QuantityImpl
implements Energy {
    private static final ImmutableSet<String> PROPERTY_SET = EnergyImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EnergyImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Energy";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Energy.Builder>
    implements Energy.Builder {
        BuilderImpl() {
        }

        @Override
        public Energy.Builder addAdditionalType(URL value) {
            return (Energy.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Energy.Builder addAdditionalType(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Energy.Builder addAlternateName(Text value) {
            return (Energy.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Energy.Builder addAlternateName(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Energy.Builder addDescription(Text value) {
            return (Energy.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Energy.Builder addDescription(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Energy.Builder addImage(ImageObject value) {
            return (Energy.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Energy.Builder addImage(ImageObject.Builder value) {
            return (Energy.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Energy.Builder addImage(URL value) {
            return (Energy.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Energy.Builder addImage(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Energy.Builder addMainEntityOfPage(CreativeWork value) {
            return (Energy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Energy.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Energy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Energy.Builder addMainEntityOfPage(URL value) {
            return (Energy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Energy.Builder addMainEntityOfPage(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Energy.Builder addName(Text value) {
            return (Energy.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Energy.Builder addName(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Energy.Builder addPotentialAction(Action value) {
            return (Energy.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Energy.Builder addPotentialAction(Action.Builder value) {
            return (Energy.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Energy.Builder addPotentialAction(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Energy.Builder addSameAs(URL value) {
            return (Energy.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Energy.Builder addSameAs(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Energy.Builder addUrl(URL value) {
            return (Energy.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Energy.Builder addUrl(String value) {
            return (Energy.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Energy.Builder addDetailedDescription(Article value) {
            return (Energy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Energy.Builder addDetailedDescription(Article.Builder value) {
            return (Energy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Energy.Builder addDetailedDescription(String value) {
            return (Energy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Energy.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Energy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Energy.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Energy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Energy.Builder addPopularityScore(String value) {
            return (Energy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Energy build() {
            return new EnergyImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

