/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.EmployeeRole;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.OrganizationRoleImpl;
import com.google.schemaorg.core.PriceSpecification;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EmployeeRoleImpl
extends OrganizationRoleImpl
implements EmployeeRole {
    private static final ImmutableSet<String> PROPERTY_SET = EmployeeRoleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/baseSalary");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/namedPosition");
        builder.add((Object)"http://schema.org/numberedPosition");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/roleName");
        builder.add((Object)"http://schema.org/salaryCurrency");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EmployeeRoleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/EmployeeRole";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBaseSalaryList() {
        return this.getProperty("http://schema.org/baseSalary");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSalaryCurrencyList() {
        return this.getProperty("http://schema.org/salaryCurrency");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<EmployeeRole.Builder>
    implements EmployeeRole.Builder {
        BuilderImpl() {
        }

        @Override
        public EmployeeRole.Builder addAdditionalType(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public EmployeeRole.Builder addAdditionalType(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addAlternateName(Text value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public EmployeeRole.Builder addAlternateName(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addBaseSalary(Number value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/baseSalary", value);
        }

        @Override
        public EmployeeRole.Builder addBaseSalary(PriceSpecification value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/baseSalary", value);
        }

        @Override
        public EmployeeRole.Builder addBaseSalary(PriceSpecification.Builder value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/baseSalary", value.build());
        }

        @Override
        public EmployeeRole.Builder addBaseSalary(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/baseSalary", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addDescription(Text value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public EmployeeRole.Builder addDescription(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addEndDate(Date value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public EmployeeRole.Builder addEndDate(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addImage(ImageObject value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EmployeeRole.Builder addImage(ImageObject.Builder value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public EmployeeRole.Builder addImage(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EmployeeRole.Builder addImage(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addMainEntityOfPage(CreativeWork value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EmployeeRole.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public EmployeeRole.Builder addMainEntityOfPage(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EmployeeRole.Builder addMainEntityOfPage(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addName(Text value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public EmployeeRole.Builder addName(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addNamedPosition(Text value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/namedPosition", value);
        }

        @Override
        public EmployeeRole.Builder addNamedPosition(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/namedPosition", value);
        }

        @Override
        public EmployeeRole.Builder addNamedPosition(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/namedPosition", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addNumberedPosition(Number value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/numberedPosition", value);
        }

        @Override
        public EmployeeRole.Builder addNumberedPosition(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/numberedPosition", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addPotentialAction(Action value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public EmployeeRole.Builder addPotentialAction(Action.Builder value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public EmployeeRole.Builder addPotentialAction(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addRoleName(Text value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/roleName", value);
        }

        @Override
        public EmployeeRole.Builder addRoleName(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/roleName", value);
        }

        @Override
        public EmployeeRole.Builder addRoleName(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/roleName", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addSalaryCurrency(Text value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/salaryCurrency", value);
        }

        @Override
        public EmployeeRole.Builder addSalaryCurrency(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/salaryCurrency", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addSameAs(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public EmployeeRole.Builder addSameAs(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addStartDate(Date value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public EmployeeRole.Builder addStartDate(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addUrl(URL value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public EmployeeRole.Builder addUrl(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addDetailedDescription(Article value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public EmployeeRole.Builder addDetailedDescription(Article.Builder value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public EmployeeRole.Builder addDetailedDescription(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public EmployeeRole.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public EmployeeRole.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public EmployeeRole.Builder addPopularityScore(String value) {
            return (EmployeeRole.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public EmployeeRole build() {
            return new EmployeeRoleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

