/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DrugStrength;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DrugStrengthImpl
extends MedicalIntangibleImpl
implements DrugStrength {
    private static final ImmutableSet<String> PROPERTY_SET = DrugStrengthImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/activeIngredient");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/availableIn");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/strengthUnit");
        builder.add((Object)"http://schema.org/strengthValue");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DrugStrengthImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DrugStrength";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActiveIngredientList() {
        return this.getProperty("http://schema.org/activeIngredient");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableInList() {
        return this.getProperty("http://schema.org/availableIn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStrengthUnitList() {
        return this.getProperty("http://schema.org/strengthUnit");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStrengthValueList() {
        return this.getProperty("http://schema.org/strengthValue");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DrugStrength.Builder>
    implements DrugStrength.Builder {
        BuilderImpl() {
        }

        @Override
        public DrugStrength.Builder addActiveIngredient(Text value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/activeIngredient", value);
        }

        @Override
        public DrugStrength.Builder addActiveIngredient(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/activeIngredient", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addAdditionalType(URL value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DrugStrength.Builder addAdditionalType(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addAlternateName(Text value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DrugStrength.Builder addAlternateName(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addAvailableIn(AdministrativeArea value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/availableIn", value);
        }

        @Override
        public DrugStrength.Builder addAvailableIn(AdministrativeArea.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/availableIn", value.build());
        }

        @Override
        public DrugStrength.Builder addAvailableIn(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/availableIn", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addCode(MedicalCode value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DrugStrength.Builder addCode(MedicalCode.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DrugStrength.Builder addCode(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addDescription(Text value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DrugStrength.Builder addDescription(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addGuideline(MedicalGuideline value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DrugStrength.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DrugStrength.Builder addGuideline(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addImage(ImageObject value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DrugStrength.Builder addImage(ImageObject.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DrugStrength.Builder addImage(URL value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DrugStrength.Builder addImage(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addMainEntityOfPage(CreativeWork value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DrugStrength.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DrugStrength.Builder addMainEntityOfPage(URL value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DrugStrength.Builder addMainEntityOfPage(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addMedicineSystem(MedicineSystem value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DrugStrength.Builder addMedicineSystem(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addName(Text value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DrugStrength.Builder addName(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addPotentialAction(Action value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DrugStrength.Builder addPotentialAction(Action.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DrugStrength.Builder addPotentialAction(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addRecognizingAuthority(Organization value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DrugStrength.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DrugStrength.Builder addRecognizingAuthority(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DrugStrength.Builder addRelevantSpecialty(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addSameAs(URL value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DrugStrength.Builder addSameAs(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addStrengthUnit(Text value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/strengthUnit", value);
        }

        @Override
        public DrugStrength.Builder addStrengthUnit(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/strengthUnit", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addStrengthValue(Number value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/strengthValue", value);
        }

        @Override
        public DrugStrength.Builder addStrengthValue(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/strengthValue", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addStudy(MedicalStudy value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DrugStrength.Builder addStudy(MedicalStudy.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DrugStrength.Builder addStudy(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addUrl(URL value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DrugStrength.Builder addUrl(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addDetailedDescription(Article value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DrugStrength.Builder addDetailedDescription(Article.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DrugStrength.Builder addDetailedDescription(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DrugStrength.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DrugStrength.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DrugStrength.Builder addPopularityScore(String value) {
            return (DrugStrength.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DrugStrength build() {
            return new DrugStrengthImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

