/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DrugLegalStatus;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DrugLegalStatusImpl
extends MedicalIntangibleImpl
implements DrugLegalStatus {
    private static final ImmutableSet<String> PROPERTY_SET = DrugLegalStatusImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/applicableLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DrugLegalStatusImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DrugLegalStatus";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getApplicableLocationList() {
        return this.getProperty("http://schema.org/applicableLocation");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DrugLegalStatus.Builder>
    implements DrugLegalStatus.Builder {
        BuilderImpl() {
        }

        @Override
        public DrugLegalStatus.Builder addAdditionalType(URL value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DrugLegalStatus.Builder addAdditionalType(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addAlternateName(Text value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DrugLegalStatus.Builder addAlternateName(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addApplicableLocation(AdministrativeArea value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/applicableLocation", value);
        }

        @Override
        public DrugLegalStatus.Builder addApplicableLocation(AdministrativeArea.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/applicableLocation", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addApplicableLocation(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/applicableLocation", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addCode(MedicalCode value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DrugLegalStatus.Builder addCode(MedicalCode.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addCode(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addDescription(Text value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DrugLegalStatus.Builder addDescription(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addGuideline(MedicalGuideline value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DrugLegalStatus.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addGuideline(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addImage(ImageObject value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DrugLegalStatus.Builder addImage(ImageObject.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addImage(URL value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DrugLegalStatus.Builder addImage(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addMainEntityOfPage(CreativeWork value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DrugLegalStatus.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addMainEntityOfPage(URL value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DrugLegalStatus.Builder addMainEntityOfPage(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addMedicineSystem(MedicineSystem value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DrugLegalStatus.Builder addMedicineSystem(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addName(Text value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DrugLegalStatus.Builder addName(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addPotentialAction(Action value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DrugLegalStatus.Builder addPotentialAction(Action.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addPotentialAction(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addRecognizingAuthority(Organization value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DrugLegalStatus.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addRecognizingAuthority(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DrugLegalStatus.Builder addRelevantSpecialty(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addSameAs(URL value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DrugLegalStatus.Builder addSameAs(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addStudy(MedicalStudy value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DrugLegalStatus.Builder addStudy(MedicalStudy.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addStudy(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addUrl(URL value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DrugLegalStatus.Builder addUrl(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addDetailedDescription(Article value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DrugLegalStatus.Builder addDetailedDescription(Article.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addDetailedDescription(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DrugLegalStatus.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DrugLegalStatus.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DrugLegalStatus.Builder addPopularityScore(String value) {
            return (DrugLegalStatus.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DrugLegalStatus build() {
            return new DrugLegalStatusImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

