/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Diet;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DietImpl
extends CreativeWorkImpl
implements Diet {
    private static final ImmutableSet<String> PROPERTY_SET = DietImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/adverseOutcome");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contraindication");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/dietFeatures");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duplicateTherapy");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/endorsers");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/expertConsiderations");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/indication");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/overview");
        builder.add((Object)"http://schema.org/physiologicalBenefits");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/proprietaryName");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/risks");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/seriousAdverseOutcome");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DietImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Diet";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdverseOutcomeList() {
        return this.getProperty("http://schema.org/adverseOutcome");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCodeList() {
        return this.getProperty("http://schema.org/code");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContraindicationList() {
        return this.getProperty("http://schema.org/contraindication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDietFeaturesList() {
        return this.getProperty("http://schema.org/dietFeatures");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDuplicateTherapyList() {
        return this.getProperty("http://schema.org/duplicateTherapy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEndorsersList() {
        return this.getProperty("http://schema.org/endorsers");
    }

    @Override
    public ImmutableList<SchemaOrgType> getExpertConsiderationsList() {
        return this.getProperty("http://schema.org/expertConsiderations");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGuidelineList() {
        return this.getProperty("http://schema.org/guideline");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIndicationList() {
        return this.getProperty("http://schema.org/indication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMedicineSystemList() {
        return this.getProperty("http://schema.org/medicineSystem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOverviewList() {
        return this.getProperty("http://schema.org/overview");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPhysiologicalBenefitsList() {
        return this.getProperty("http://schema.org/physiologicalBenefits");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProprietaryNameList() {
        return this.getProperty("http://schema.org/proprietaryName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecognizingAuthorityList() {
        return this.getProperty("http://schema.org/recognizingAuthority");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelevantSpecialtyList() {
        return this.getProperty("http://schema.org/relevantSpecialty");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRisksList() {
        return this.getProperty("http://schema.org/risks");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSeriousAdverseOutcomeList() {
        return this.getProperty("http://schema.org/seriousAdverseOutcome");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStudyList() {
        return this.getProperty("http://schema.org/study");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Diet.Builder>
    implements Diet.Builder {
        BuilderImpl() {
        }

        @Override
        public Diet.Builder addAbout(Thing value) {
            return (Diet.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Diet.Builder addAbout(Thing.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Diet.Builder addAbout(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Diet.Builder addAccessibilityAPI(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Diet.Builder addAccessibilityAPI(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Diet.Builder addAccessibilityControl(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Diet.Builder addAccessibilityControl(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Diet.Builder addAccessibilityFeature(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Diet.Builder addAccessibilityFeature(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Diet.Builder addAccessibilityHazard(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Diet.Builder addAccessibilityHazard(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Diet.Builder addAccountablePerson(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Diet.Builder addAccountablePerson(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Diet.Builder addAccountablePerson(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Diet.Builder addAdditionalType(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Diet.Builder addAdditionalType(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Diet.Builder addAdverseOutcome(MedicalEntity value) {
            return (Diet.Builder)this.addProperty("http://schema.org/adverseOutcome", value);
        }

        @Override
        public Diet.Builder addAdverseOutcome(MedicalEntity.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/adverseOutcome", value.build());
        }

        @Override
        public Diet.Builder addAdverseOutcome(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/adverseOutcome", Text.of(value));
        }

        @Override
        public Diet.Builder addAggregateRating(AggregateRating value) {
            return (Diet.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Diet.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Diet.Builder addAggregateRating(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Diet.Builder addAlternateName(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Diet.Builder addAlternateName(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Diet.Builder addAlternativeHeadline(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Diet.Builder addAlternativeHeadline(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Diet.Builder addAssociatedMedia(MediaObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Diet.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Diet.Builder addAssociatedMedia(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Diet.Builder addAudience(Audience value) {
            return (Diet.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Diet.Builder addAudience(Audience.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Diet.Builder addAudience(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Diet.Builder addAudio(AudioObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Diet.Builder addAudio(AudioObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Diet.Builder addAudio(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Diet.Builder addAuthor(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Diet.Builder addAuthor(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Diet.Builder addAuthor(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Diet.Builder addAuthor(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Diet.Builder addAuthor(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Diet.Builder addAward(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Diet.Builder addAward(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Diet.Builder addAwards(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Diet.Builder addAwards(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Diet.Builder addCharacter(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Diet.Builder addCharacter(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Diet.Builder addCharacter(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Diet.Builder addCitation(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Diet.Builder addCitation(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Diet.Builder addCitation(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Diet.Builder addCitation(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Diet.Builder addCode(MedicalCode value) {
            return (Diet.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Diet.Builder addCode(MedicalCode.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Diet.Builder addCode(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Diet.Builder addComment(Comment value) {
            return (Diet.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Diet.Builder addComment(Comment.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Diet.Builder addComment(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Diet.Builder addCommentCount(Integer value) {
            return (Diet.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Diet.Builder addCommentCount(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Diet.Builder addContentLocation(Place value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Diet.Builder addContentLocation(Place.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Diet.Builder addContentLocation(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Diet.Builder addContentRating(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Diet.Builder addContentRating(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Diet.Builder addContraindication(MedicalContraindication value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contraindication", value);
        }

        @Override
        public Diet.Builder addContraindication(MedicalContraindication.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contraindication", value.build());
        }

        @Override
        public Diet.Builder addContraindication(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contraindication", Text.of(value));
        }

        @Override
        public Diet.Builder addContributor(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Diet.Builder addContributor(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Diet.Builder addContributor(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Diet.Builder addContributor(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Diet.Builder addContributor(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Diet.Builder addCopyrightHolder(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Diet.Builder addCopyrightHolder(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Diet.Builder addCopyrightHolder(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Diet.Builder addCopyrightHolder(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Diet.Builder addCopyrightHolder(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Diet.Builder addCopyrightYear(Number value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Diet.Builder addCopyrightYear(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Diet.Builder addCreator(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Diet.Builder addCreator(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Diet.Builder addCreator(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Diet.Builder addCreator(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Diet.Builder addCreator(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Diet.Builder addDateCreated(Date value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Diet.Builder addDateCreated(DateTime value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Diet.Builder addDateCreated(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Diet.Builder addDateModified(Date value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Diet.Builder addDateModified(DateTime value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Diet.Builder addDateModified(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Diet.Builder addDatePublished(Date value) {
            return (Diet.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Diet.Builder addDatePublished(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Diet.Builder addDescription(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Diet.Builder addDescription(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Diet.Builder addDietFeatures(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dietFeatures", value);
        }

        @Override
        public Diet.Builder addDietFeatures(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/dietFeatures", Text.of(value));
        }

        @Override
        public Diet.Builder addDiscussionUrl(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Diet.Builder addDiscussionUrl(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Diet.Builder addDuplicateTherapy(MedicalTherapy value) {
            return (Diet.Builder)this.addProperty("http://schema.org/duplicateTherapy", value);
        }

        @Override
        public Diet.Builder addDuplicateTherapy(MedicalTherapy.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/duplicateTherapy", value.build());
        }

        @Override
        public Diet.Builder addDuplicateTherapy(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/duplicateTherapy", Text.of(value));
        }

        @Override
        public Diet.Builder addEditor(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Diet.Builder addEditor(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Diet.Builder addEditor(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Diet.Builder addEducationalAlignment(AlignmentObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Diet.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Diet.Builder addEducationalAlignment(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Diet.Builder addEducationalUse(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Diet.Builder addEducationalUse(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Diet.Builder addEncoding(MediaObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Diet.Builder addEncoding(MediaObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Diet.Builder addEncoding(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Diet.Builder addEncodings(MediaObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Diet.Builder addEncodings(MediaObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Diet.Builder addEncodings(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Diet.Builder addEndorsers(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/endorsers", value);
        }

        @Override
        public Diet.Builder addEndorsers(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/endorsers", value.build());
        }

        @Override
        public Diet.Builder addEndorsers(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/endorsers", value);
        }

        @Override
        public Diet.Builder addEndorsers(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/endorsers", value.build());
        }

        @Override
        public Diet.Builder addEndorsers(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/endorsers", Text.of(value));
        }

        @Override
        public Diet.Builder addExampleOfWork(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Diet.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Diet.Builder addExampleOfWork(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Diet.Builder addExpertConsiderations(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/expertConsiderations", value);
        }

        @Override
        public Diet.Builder addExpertConsiderations(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/expertConsiderations", Text.of(value));
        }

        @Override
        public Diet.Builder addFileFormat(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Diet.Builder addFileFormat(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Diet.Builder addGenre(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Diet.Builder addGenre(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Diet.Builder addGenre(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Diet.Builder addGuideline(MedicalGuideline value) {
            return (Diet.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Diet.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Diet.Builder addGuideline(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Diet.Builder addHasPart(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Diet.Builder addHasPart(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Diet.Builder addHasPart(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Diet.Builder addHeadline(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Diet.Builder addHeadline(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Diet.Builder addImage(ImageObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Diet.Builder addImage(ImageObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Diet.Builder addImage(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Diet.Builder addImage(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Diet.Builder addIndication(MedicalIndication value) {
            return (Diet.Builder)this.addProperty("http://schema.org/indication", value);
        }

        @Override
        public Diet.Builder addIndication(MedicalIndication.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/indication", value.build());
        }

        @Override
        public Diet.Builder addIndication(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/indication", Text.of(value));
        }

        @Override
        public Diet.Builder addInLanguage(Language value) {
            return (Diet.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Diet.Builder addInLanguage(Language.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Diet.Builder addInLanguage(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Diet.Builder addInLanguage(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Diet.Builder addInteractionStatistic(InteractionCounter value) {
            return (Diet.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Diet.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Diet.Builder addInteractionStatistic(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Diet.Builder addInteractivityType(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Diet.Builder addInteractivityType(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Diet.Builder addIsBasedOnUrl(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Diet.Builder addIsBasedOnUrl(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Diet.Builder addIsFamilyFriendly(Boolean value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Diet.Builder addIsFamilyFriendly(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Diet.Builder addIsPartOf(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Diet.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Diet.Builder addIsPartOf(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Diet.Builder addKeywords(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Diet.Builder addKeywords(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Diet.Builder addLearningResourceType(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Diet.Builder addLearningResourceType(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Diet.Builder addLicense(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Diet.Builder addLicense(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Diet.Builder addLicense(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Diet.Builder addLicense(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Diet.Builder addLocationCreated(Place value) {
            return (Diet.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Diet.Builder addLocationCreated(Place.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Diet.Builder addLocationCreated(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Diet.Builder addMainEntity(Thing value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Diet.Builder addMainEntity(Thing.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Diet.Builder addMainEntity(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Diet.Builder addMainEntityOfPage(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Diet.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Diet.Builder addMainEntityOfPage(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Diet.Builder addMainEntityOfPage(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Diet.Builder addMedicineSystem(MedicineSystem value) {
            return (Diet.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Diet.Builder addMedicineSystem(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Diet.Builder addMentions(Thing value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Diet.Builder addMentions(Thing.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Diet.Builder addMentions(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Diet.Builder addName(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Diet.Builder addName(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Diet.Builder addOffers(Offer value) {
            return (Diet.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Diet.Builder addOffers(Offer.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Diet.Builder addOffers(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Diet.Builder addOverview(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/overview", value);
        }

        @Override
        public Diet.Builder addOverview(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/overview", Text.of(value));
        }

        @Override
        public Diet.Builder addPhysiologicalBenefits(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/physiologicalBenefits", value);
        }

        @Override
        public Diet.Builder addPhysiologicalBenefits(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/physiologicalBenefits", Text.of(value));
        }

        @Override
        public Diet.Builder addPosition(Integer value) {
            return (Diet.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Diet.Builder addPosition(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Diet.Builder addPosition(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Diet.Builder addPotentialAction(Action value) {
            return (Diet.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Diet.Builder addPotentialAction(Action.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Diet.Builder addPotentialAction(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Diet.Builder addProducer(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Diet.Builder addProducer(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Diet.Builder addProducer(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Diet.Builder addProducer(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Diet.Builder addProducer(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Diet.Builder addProprietaryName(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/proprietaryName", value);
        }

        @Override
        public Diet.Builder addProprietaryName(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/proprietaryName", Text.of(value));
        }

        @Override
        public Diet.Builder addProvider(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Diet.Builder addProvider(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Diet.Builder addProvider(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Diet.Builder addProvider(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Diet.Builder addProvider(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Diet.Builder addPublication(PublicationEvent value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Diet.Builder addPublication(PublicationEvent.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Diet.Builder addPublication(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Diet.Builder addPublisher(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Diet.Builder addPublisher(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Diet.Builder addPublisher(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Diet.Builder addPublisher(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Diet.Builder addPublisher(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Diet.Builder addPublishingPrinciples(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Diet.Builder addPublishingPrinciples(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Diet.Builder addRecognizingAuthority(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Diet.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Diet.Builder addRecognizingAuthority(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Diet.Builder addRecordedAt(Event value) {
            return (Diet.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Diet.Builder addRecordedAt(Event.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Diet.Builder addRecordedAt(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Diet.Builder addReleasedEvent(PublicationEvent value) {
            return (Diet.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Diet.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Diet.Builder addReleasedEvent(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Diet.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Diet.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Diet.Builder addRelevantSpecialty(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Diet.Builder addReview(Review value) {
            return (Diet.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Diet.Builder addReview(Review.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Diet.Builder addReview(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Diet.Builder addReviews(Review value) {
            return (Diet.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Diet.Builder addReviews(Review.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Diet.Builder addReviews(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Diet.Builder addRisks(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/risks", value);
        }

        @Override
        public Diet.Builder addRisks(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/risks", Text.of(value));
        }

        @Override
        public Diet.Builder addSameAs(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Diet.Builder addSameAs(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Diet.Builder addSchemaVersion(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Diet.Builder addSchemaVersion(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Diet.Builder addSchemaVersion(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Diet.Builder addSeriousAdverseOutcome(MedicalEntity value) {
            return (Diet.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value);
        }

        @Override
        public Diet.Builder addSeriousAdverseOutcome(MedicalEntity.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value.build());
        }

        @Override
        public Diet.Builder addSeriousAdverseOutcome(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", Text.of(value));
        }

        @Override
        public Diet.Builder addSourceOrganization(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Diet.Builder addSourceOrganization(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Diet.Builder addSourceOrganization(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Diet.Builder addStudy(MedicalStudy value) {
            return (Diet.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Diet.Builder addStudy(MedicalStudy.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Diet.Builder addStudy(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Diet.Builder addText(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Diet.Builder addText(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Diet.Builder addThumbnailUrl(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Diet.Builder addThumbnailUrl(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Diet.Builder addTimeRequired(Duration value) {
            return (Diet.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Diet.Builder addTimeRequired(Duration.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Diet.Builder addTimeRequired(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Diet.Builder addTranslator(Organization value) {
            return (Diet.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Diet.Builder addTranslator(Organization.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Diet.Builder addTranslator(Person value) {
            return (Diet.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Diet.Builder addTranslator(Person.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Diet.Builder addTranslator(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Diet.Builder addTypicalAgeRange(Text value) {
            return (Diet.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Diet.Builder addTypicalAgeRange(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Diet.Builder addUrl(URL value) {
            return (Diet.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Diet.Builder addUrl(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Diet.Builder addVersion(Number value) {
            return (Diet.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Diet.Builder addVersion(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Diet.Builder addVideo(VideoObject value) {
            return (Diet.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Diet.Builder addVideo(VideoObject.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Diet.Builder addVideo(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Diet.Builder addWorkExample(CreativeWork value) {
            return (Diet.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Diet.Builder addWorkExample(CreativeWork.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Diet.Builder addWorkExample(String value) {
            return (Diet.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Diet.Builder addDetailedDescription(Article value) {
            return (Diet.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Diet.Builder addDetailedDescription(Article.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Diet.Builder addDetailedDescription(String value) {
            return (Diet.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Diet.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Diet.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Diet.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Diet.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Diet.Builder addPopularityScore(String value) {
            return (Diet.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Diet build() {
            return new DietImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

