/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.DataCatalog;
import com.google.schemaorg.core.DataDownload;
import com.google.schemaorg.core.Dataset;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DatasetImpl
extends CreativeWorkImpl
implements Dataset {
    private static final ImmutableSet<String> PROPERTY_SET = DatasetImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/catalog");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/datasetTimeInterval");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/distribution");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includedDataCatalog");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/spatial");
        builder.add((Object)"http://schema.org/temporal");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DatasetImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Dataset";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCatalogList() {
        return this.getProperty("http://schema.org/catalog");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDatasetTimeIntervalList() {
        return this.getProperty("http://schema.org/datasetTimeInterval");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDistributionList() {
        return this.getProperty("http://schema.org/distribution");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIncludedDataCatalogList() {
        return this.getProperty("http://schema.org/includedDataCatalog");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSpatialList() {
        return this.getProperty("http://schema.org/spatial");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTemporalList() {
        return this.getProperty("http://schema.org/temporal");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Dataset.Builder>
    implements Dataset.Builder {
        BuilderImpl() {
        }

        @Override
        public Dataset.Builder addAbout(Thing value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Dataset.Builder addAbout(Thing.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Dataset.Builder addAbout(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Dataset.Builder addAccessibilityAPI(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Dataset.Builder addAccessibilityAPI(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Dataset.Builder addAccessibilityControl(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Dataset.Builder addAccessibilityControl(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Dataset.Builder addAccessibilityFeature(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Dataset.Builder addAccessibilityFeature(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Dataset.Builder addAccessibilityHazard(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Dataset.Builder addAccessibilityHazard(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Dataset.Builder addAccountablePerson(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Dataset.Builder addAccountablePerson(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Dataset.Builder addAccountablePerson(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Dataset.Builder addAdditionalType(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Dataset.Builder addAdditionalType(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Dataset.Builder addAggregateRating(AggregateRating value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Dataset.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Dataset.Builder addAggregateRating(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Dataset.Builder addAlternateName(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Dataset.Builder addAlternateName(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Dataset.Builder addAlternativeHeadline(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Dataset.Builder addAlternativeHeadline(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Dataset.Builder addAssociatedMedia(MediaObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Dataset.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Dataset.Builder addAssociatedMedia(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Dataset.Builder addAudience(Audience value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Dataset.Builder addAudience(Audience.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Dataset.Builder addAudience(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Dataset.Builder addAudio(AudioObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Dataset.Builder addAudio(AudioObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Dataset.Builder addAudio(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Dataset.Builder addAuthor(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Dataset.Builder addAuthor(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Dataset.Builder addAuthor(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Dataset.Builder addAuthor(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Dataset.Builder addAuthor(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Dataset.Builder addAward(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Dataset.Builder addAward(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Dataset.Builder addAwards(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Dataset.Builder addAwards(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Dataset.Builder addCatalog(DataCatalog value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/catalog", value);
        }

        @Override
        public Dataset.Builder addCatalog(DataCatalog.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/catalog", value.build());
        }

        @Override
        public Dataset.Builder addCatalog(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/catalog", Text.of(value));
        }

        @Override
        public Dataset.Builder addCharacter(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Dataset.Builder addCharacter(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Dataset.Builder addCharacter(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Dataset.Builder addCitation(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Dataset.Builder addCitation(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Dataset.Builder addCitation(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Dataset.Builder addCitation(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Dataset.Builder addComment(Comment value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Dataset.Builder addComment(Comment.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Dataset.Builder addComment(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Dataset.Builder addCommentCount(Integer value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Dataset.Builder addCommentCount(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Dataset.Builder addContentLocation(Place value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Dataset.Builder addContentLocation(Place.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Dataset.Builder addContentLocation(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Dataset.Builder addContentRating(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Dataset.Builder addContentRating(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Dataset.Builder addContributor(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Dataset.Builder addContributor(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Dataset.Builder addContributor(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Dataset.Builder addContributor(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Dataset.Builder addContributor(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Dataset.Builder addCopyrightHolder(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Dataset.Builder addCopyrightHolder(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Dataset.Builder addCopyrightHolder(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Dataset.Builder addCopyrightHolder(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Dataset.Builder addCopyrightHolder(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Dataset.Builder addCopyrightYear(Number value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Dataset.Builder addCopyrightYear(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Dataset.Builder addCreator(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Dataset.Builder addCreator(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Dataset.Builder addCreator(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Dataset.Builder addCreator(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Dataset.Builder addCreator(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Dataset.Builder addDatasetTimeInterval(DateTime value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/datasetTimeInterval", value);
        }

        @Override
        public Dataset.Builder addDatasetTimeInterval(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/datasetTimeInterval", Text.of(value));
        }

        @Override
        public Dataset.Builder addDateCreated(Date value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Dataset.Builder addDateCreated(DateTime value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Dataset.Builder addDateCreated(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Dataset.Builder addDateModified(Date value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Dataset.Builder addDateModified(DateTime value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Dataset.Builder addDateModified(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Dataset.Builder addDatePublished(Date value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Dataset.Builder addDatePublished(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Dataset.Builder addDescription(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Dataset.Builder addDescription(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Dataset.Builder addDiscussionUrl(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Dataset.Builder addDiscussionUrl(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Dataset.Builder addDistribution(DataDownload value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/distribution", value);
        }

        @Override
        public Dataset.Builder addDistribution(DataDownload.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/distribution", value.build());
        }

        @Override
        public Dataset.Builder addDistribution(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/distribution", Text.of(value));
        }

        @Override
        public Dataset.Builder addEditor(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Dataset.Builder addEditor(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Dataset.Builder addEditor(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Dataset.Builder addEducationalAlignment(AlignmentObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Dataset.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Dataset.Builder addEducationalAlignment(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Dataset.Builder addEducationalUse(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Dataset.Builder addEducationalUse(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Dataset.Builder addEncoding(MediaObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Dataset.Builder addEncoding(MediaObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Dataset.Builder addEncoding(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Dataset.Builder addEncodings(MediaObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Dataset.Builder addEncodings(MediaObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Dataset.Builder addEncodings(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Dataset.Builder addExampleOfWork(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Dataset.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Dataset.Builder addExampleOfWork(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Dataset.Builder addFileFormat(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Dataset.Builder addFileFormat(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Dataset.Builder addGenre(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Dataset.Builder addGenre(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Dataset.Builder addGenre(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Dataset.Builder addHasPart(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Dataset.Builder addHasPart(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Dataset.Builder addHasPart(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Dataset.Builder addHeadline(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Dataset.Builder addHeadline(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Dataset.Builder addImage(ImageObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Dataset.Builder addImage(ImageObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Dataset.Builder addImage(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Dataset.Builder addImage(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Dataset.Builder addIncludedDataCatalog(DataCatalog value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/includedDataCatalog", value);
        }

        @Override
        public Dataset.Builder addIncludedDataCatalog(DataCatalog.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/includedDataCatalog", value.build());
        }

        @Override
        public Dataset.Builder addIncludedDataCatalog(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/includedDataCatalog", Text.of(value));
        }

        @Override
        public Dataset.Builder addInLanguage(Language value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Dataset.Builder addInLanguage(Language.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Dataset.Builder addInLanguage(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Dataset.Builder addInLanguage(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Dataset.Builder addInteractionStatistic(InteractionCounter value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Dataset.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Dataset.Builder addInteractionStatistic(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Dataset.Builder addInteractivityType(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Dataset.Builder addInteractivityType(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Dataset.Builder addIsBasedOnUrl(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Dataset.Builder addIsBasedOnUrl(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Dataset.Builder addIsFamilyFriendly(Boolean value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Dataset.Builder addIsFamilyFriendly(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Dataset.Builder addIsPartOf(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Dataset.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Dataset.Builder addIsPartOf(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Dataset.Builder addKeywords(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Dataset.Builder addKeywords(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Dataset.Builder addLearningResourceType(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Dataset.Builder addLearningResourceType(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Dataset.Builder addLicense(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Dataset.Builder addLicense(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Dataset.Builder addLicense(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Dataset.Builder addLicense(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Dataset.Builder addLocationCreated(Place value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Dataset.Builder addLocationCreated(Place.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Dataset.Builder addLocationCreated(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Dataset.Builder addMainEntity(Thing value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Dataset.Builder addMainEntity(Thing.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Dataset.Builder addMainEntity(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Dataset.Builder addMainEntityOfPage(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Dataset.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Dataset.Builder addMainEntityOfPage(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Dataset.Builder addMainEntityOfPage(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Dataset.Builder addMentions(Thing value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Dataset.Builder addMentions(Thing.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Dataset.Builder addMentions(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Dataset.Builder addName(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Dataset.Builder addName(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Dataset.Builder addOffers(Offer value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Dataset.Builder addOffers(Offer.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Dataset.Builder addOffers(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Dataset.Builder addPosition(Integer value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Dataset.Builder addPosition(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Dataset.Builder addPosition(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Dataset.Builder addPotentialAction(Action value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Dataset.Builder addPotentialAction(Action.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Dataset.Builder addPotentialAction(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Dataset.Builder addProducer(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Dataset.Builder addProducer(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Dataset.Builder addProducer(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Dataset.Builder addProducer(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Dataset.Builder addProducer(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Dataset.Builder addProvider(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Dataset.Builder addProvider(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Dataset.Builder addProvider(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Dataset.Builder addProvider(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Dataset.Builder addProvider(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Dataset.Builder addPublication(PublicationEvent value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Dataset.Builder addPublication(PublicationEvent.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Dataset.Builder addPublication(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Dataset.Builder addPublisher(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Dataset.Builder addPublisher(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Dataset.Builder addPublisher(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Dataset.Builder addPublisher(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Dataset.Builder addPublisher(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Dataset.Builder addPublishingPrinciples(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Dataset.Builder addPublishingPrinciples(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Dataset.Builder addRecordedAt(Event value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Dataset.Builder addRecordedAt(Event.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Dataset.Builder addRecordedAt(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Dataset.Builder addReleasedEvent(PublicationEvent value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Dataset.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Dataset.Builder addReleasedEvent(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Dataset.Builder addReview(Review value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Dataset.Builder addReview(Review.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Dataset.Builder addReview(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Dataset.Builder addReviews(Review value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Dataset.Builder addReviews(Review.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Dataset.Builder addReviews(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Dataset.Builder addSameAs(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Dataset.Builder addSameAs(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Dataset.Builder addSchemaVersion(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Dataset.Builder addSchemaVersion(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Dataset.Builder addSchemaVersion(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Dataset.Builder addSourceOrganization(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Dataset.Builder addSourceOrganization(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Dataset.Builder addSourceOrganization(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Dataset.Builder addSpatial(Place value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/spatial", value);
        }

        @Override
        public Dataset.Builder addSpatial(Place.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/spatial", value.build());
        }

        @Override
        public Dataset.Builder addSpatial(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/spatial", Text.of(value));
        }

        @Override
        public Dataset.Builder addTemporal(DateTime value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/temporal", value);
        }

        @Override
        public Dataset.Builder addTemporal(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/temporal", Text.of(value));
        }

        @Override
        public Dataset.Builder addText(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Dataset.Builder addText(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Dataset.Builder addThumbnailUrl(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Dataset.Builder addThumbnailUrl(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Dataset.Builder addTimeRequired(Duration value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Dataset.Builder addTimeRequired(Duration.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Dataset.Builder addTimeRequired(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Dataset.Builder addTranslator(Organization value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Dataset.Builder addTranslator(Organization.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Dataset.Builder addTranslator(Person value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Dataset.Builder addTranslator(Person.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Dataset.Builder addTranslator(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Dataset.Builder addTypicalAgeRange(Text value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Dataset.Builder addTypicalAgeRange(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Dataset.Builder addUrl(URL value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Dataset.Builder addUrl(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Dataset.Builder addVersion(Number value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Dataset.Builder addVersion(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Dataset.Builder addVideo(VideoObject value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Dataset.Builder addVideo(VideoObject.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Dataset.Builder addVideo(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Dataset.Builder addWorkExample(CreativeWork value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Dataset.Builder addWorkExample(CreativeWork.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Dataset.Builder addWorkExample(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Dataset.Builder addDetailedDescription(Article value) {
            return (Dataset.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Dataset.Builder addDetailedDescription(Article.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Dataset.Builder addDetailedDescription(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Dataset.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Dataset.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Dataset.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Dataset.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Dataset.Builder addPopularityScore(String value) {
            return (Dataset.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Dataset build() {
            return new DatasetImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

