/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DDxElement;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSignOrSymptom;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DDxElementImpl
extends MedicalIntangibleImpl
implements DDxElement {
    private static final ImmutableSet<String> PROPERTY_SET = DDxElementImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagnosis");
        builder.add((Object)"http://schema.org/distinguishingSign");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DDxElementImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DDxElement";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDiagnosisList() {
        return this.getProperty("http://schema.org/diagnosis");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDistinguishingSignList() {
        return this.getProperty("http://schema.org/distinguishingSign");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DDxElement.Builder>
    implements DDxElement.Builder {
        BuilderImpl() {
        }

        @Override
        public DDxElement.Builder addAdditionalType(URL value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DDxElement.Builder addAdditionalType(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DDxElement.Builder addAlternateName(Text value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DDxElement.Builder addAlternateName(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DDxElement.Builder addCode(MedicalCode value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DDxElement.Builder addCode(MedicalCode.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DDxElement.Builder addCode(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DDxElement.Builder addDescription(Text value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DDxElement.Builder addDescription(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DDxElement.Builder addDiagnosis(MedicalCondition value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/diagnosis", value);
        }

        @Override
        public DDxElement.Builder addDiagnosis(MedicalCondition.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/diagnosis", value.build());
        }

        @Override
        public DDxElement.Builder addDiagnosis(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/diagnosis", Text.of(value));
        }

        @Override
        public DDxElement.Builder addDistinguishingSign(MedicalSignOrSymptom value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/distinguishingSign", value);
        }

        @Override
        public DDxElement.Builder addDistinguishingSign(MedicalSignOrSymptom.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/distinguishingSign", value.build());
        }

        @Override
        public DDxElement.Builder addDistinguishingSign(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/distinguishingSign", Text.of(value));
        }

        @Override
        public DDxElement.Builder addGuideline(MedicalGuideline value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DDxElement.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DDxElement.Builder addGuideline(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DDxElement.Builder addImage(ImageObject value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DDxElement.Builder addImage(ImageObject.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DDxElement.Builder addImage(URL value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DDxElement.Builder addImage(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DDxElement.Builder addMainEntityOfPage(CreativeWork value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DDxElement.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DDxElement.Builder addMainEntityOfPage(URL value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DDxElement.Builder addMainEntityOfPage(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DDxElement.Builder addMedicineSystem(MedicineSystem value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DDxElement.Builder addMedicineSystem(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DDxElement.Builder addName(Text value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DDxElement.Builder addName(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DDxElement.Builder addPotentialAction(Action value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DDxElement.Builder addPotentialAction(Action.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DDxElement.Builder addPotentialAction(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DDxElement.Builder addRecognizingAuthority(Organization value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DDxElement.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DDxElement.Builder addRecognizingAuthority(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DDxElement.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DDxElement.Builder addRelevantSpecialty(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DDxElement.Builder addSameAs(URL value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DDxElement.Builder addSameAs(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DDxElement.Builder addStudy(MedicalStudy value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DDxElement.Builder addStudy(MedicalStudy.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DDxElement.Builder addStudy(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DDxElement.Builder addUrl(URL value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DDxElement.Builder addUrl(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DDxElement.Builder addDetailedDescription(Article value) {
            return (DDxElement.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DDxElement.Builder addDetailedDescription(Article.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DDxElement.Builder addDetailedDescription(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DDxElement.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DDxElement.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DDxElement.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DDxElement.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DDxElement.Builder addPopularityScore(String value) {
            return (DDxElement.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DDxElement build() {
            return new DDxElementImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

