/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Clip;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.CreativeWorkSeason;
import com.google.schemaorg.core.CreativeWorkSeries;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Episode;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ClipImpl
extends CreativeWorkImpl
implements Clip {
    private static final ImmutableSet<String> PROPERTY_SET = ClipImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/actor");
        builder.add((Object)"http://schema.org/actors");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/clipNumber");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/director");
        builder.add((Object)"http://schema.org/directors");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicBy");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/partOfEpisode");
        builder.add((Object)"http://schema.org/partOfSeason");
        builder.add((Object)"http://schema.org/partOfSeries");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ClipImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Clip";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorList() {
        return this.getProperty("http://schema.org/actor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorsList() {
        return this.getProperty("http://schema.org/actors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getClipNumberList() {
        return this.getProperty("http://schema.org/clipNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorList() {
        return this.getProperty("http://schema.org/director");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorsList() {
        return this.getProperty("http://schema.org/directors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicByList() {
        return this.getProperty("http://schema.org/musicBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfEpisodeList() {
        return this.getProperty("http://schema.org/partOfEpisode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfSeasonList() {
        return this.getProperty("http://schema.org/partOfSeason");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfSeriesList() {
        return this.getProperty("http://schema.org/partOfSeries");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Clip.Builder>
    implements Clip.Builder {
        BuilderImpl() {
        }

        @Override
        public Clip.Builder addAbout(Thing value) {
            return (Clip.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Clip.Builder addAbout(Thing.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Clip.Builder addAbout(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Clip.Builder addAccessibilityAPI(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Clip.Builder addAccessibilityAPI(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Clip.Builder addAccessibilityControl(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Clip.Builder addAccessibilityControl(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Clip.Builder addAccessibilityFeature(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Clip.Builder addAccessibilityFeature(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Clip.Builder addAccessibilityHazard(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Clip.Builder addAccessibilityHazard(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Clip.Builder addAccountablePerson(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Clip.Builder addAccountablePerson(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Clip.Builder addAccountablePerson(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Clip.Builder addActor(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/actor", value);
        }

        @Override
        public Clip.Builder addActor(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/actor", value.build());
        }

        @Override
        public Clip.Builder addActor(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/actor", Text.of(value));
        }

        @Override
        public Clip.Builder addActors(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/actors", value);
        }

        @Override
        public Clip.Builder addActors(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/actors", value.build());
        }

        @Override
        public Clip.Builder addActors(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/actors", Text.of(value));
        }

        @Override
        public Clip.Builder addAdditionalType(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Clip.Builder addAdditionalType(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Clip.Builder addAggregateRating(AggregateRating value) {
            return (Clip.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Clip.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Clip.Builder addAggregateRating(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Clip.Builder addAlternateName(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Clip.Builder addAlternateName(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Clip.Builder addAlternativeHeadline(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Clip.Builder addAlternativeHeadline(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Clip.Builder addAssociatedMedia(MediaObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Clip.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Clip.Builder addAssociatedMedia(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Clip.Builder addAudience(Audience value) {
            return (Clip.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Clip.Builder addAudience(Audience.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Clip.Builder addAudience(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Clip.Builder addAudio(AudioObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Clip.Builder addAudio(AudioObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Clip.Builder addAudio(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Clip.Builder addAuthor(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Clip.Builder addAuthor(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Clip.Builder addAuthor(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Clip.Builder addAuthor(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Clip.Builder addAuthor(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Clip.Builder addAward(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Clip.Builder addAward(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Clip.Builder addAwards(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Clip.Builder addAwards(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Clip.Builder addCharacter(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Clip.Builder addCharacter(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Clip.Builder addCharacter(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Clip.Builder addCitation(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Clip.Builder addCitation(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Clip.Builder addCitation(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Clip.Builder addCitation(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Clip.Builder addClipNumber(Integer value) {
            return (Clip.Builder)this.addProperty("http://schema.org/clipNumber", value);
        }

        @Override
        public Clip.Builder addClipNumber(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/clipNumber", value);
        }

        @Override
        public Clip.Builder addClipNumber(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/clipNumber", Text.of(value));
        }

        @Override
        public Clip.Builder addComment(Comment value) {
            return (Clip.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Clip.Builder addComment(Comment.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Clip.Builder addComment(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Clip.Builder addCommentCount(Integer value) {
            return (Clip.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Clip.Builder addCommentCount(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Clip.Builder addContentLocation(Place value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Clip.Builder addContentLocation(Place.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Clip.Builder addContentLocation(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Clip.Builder addContentRating(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Clip.Builder addContentRating(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Clip.Builder addContributor(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Clip.Builder addContributor(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Clip.Builder addContributor(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Clip.Builder addContributor(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Clip.Builder addContributor(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Clip.Builder addCopyrightHolder(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Clip.Builder addCopyrightHolder(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Clip.Builder addCopyrightHolder(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Clip.Builder addCopyrightHolder(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Clip.Builder addCopyrightHolder(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Clip.Builder addCopyrightYear(Number value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Clip.Builder addCopyrightYear(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Clip.Builder addCreator(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Clip.Builder addCreator(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Clip.Builder addCreator(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Clip.Builder addCreator(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Clip.Builder addCreator(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Clip.Builder addDateCreated(Date value) {
            return (Clip.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Clip.Builder addDateCreated(DateTime value) {
            return (Clip.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Clip.Builder addDateCreated(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Clip.Builder addDateModified(Date value) {
            return (Clip.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Clip.Builder addDateModified(DateTime value) {
            return (Clip.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Clip.Builder addDateModified(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Clip.Builder addDatePublished(Date value) {
            return (Clip.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Clip.Builder addDatePublished(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Clip.Builder addDescription(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Clip.Builder addDescription(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Clip.Builder addDirector(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/director", value);
        }

        @Override
        public Clip.Builder addDirector(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/director", value.build());
        }

        @Override
        public Clip.Builder addDirector(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/director", Text.of(value));
        }

        @Override
        public Clip.Builder addDirectors(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/directors", value);
        }

        @Override
        public Clip.Builder addDirectors(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/directors", value.build());
        }

        @Override
        public Clip.Builder addDirectors(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/directors", Text.of(value));
        }

        @Override
        public Clip.Builder addDiscussionUrl(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Clip.Builder addDiscussionUrl(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Clip.Builder addEditor(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Clip.Builder addEditor(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Clip.Builder addEditor(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Clip.Builder addEducationalAlignment(AlignmentObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Clip.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Clip.Builder addEducationalAlignment(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Clip.Builder addEducationalUse(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Clip.Builder addEducationalUse(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Clip.Builder addEncoding(MediaObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Clip.Builder addEncoding(MediaObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Clip.Builder addEncoding(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Clip.Builder addEncodings(MediaObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Clip.Builder addEncodings(MediaObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Clip.Builder addEncodings(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Clip.Builder addExampleOfWork(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Clip.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Clip.Builder addExampleOfWork(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Clip.Builder addFileFormat(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Clip.Builder addFileFormat(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Clip.Builder addGenre(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Clip.Builder addGenre(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Clip.Builder addGenre(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Clip.Builder addHasPart(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Clip.Builder addHasPart(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Clip.Builder addHasPart(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Clip.Builder addHeadline(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Clip.Builder addHeadline(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Clip.Builder addImage(ImageObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Clip.Builder addImage(ImageObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Clip.Builder addImage(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Clip.Builder addImage(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Clip.Builder addInLanguage(Language value) {
            return (Clip.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Clip.Builder addInLanguage(Language.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Clip.Builder addInLanguage(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Clip.Builder addInLanguage(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Clip.Builder addInteractionStatistic(InteractionCounter value) {
            return (Clip.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Clip.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Clip.Builder addInteractionStatistic(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Clip.Builder addInteractivityType(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Clip.Builder addInteractivityType(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Clip.Builder addIsBasedOnUrl(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Clip.Builder addIsBasedOnUrl(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Clip.Builder addIsFamilyFriendly(Boolean value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Clip.Builder addIsFamilyFriendly(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Clip.Builder addIsPartOf(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Clip.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Clip.Builder addIsPartOf(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Clip.Builder addKeywords(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Clip.Builder addKeywords(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Clip.Builder addLearningResourceType(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Clip.Builder addLearningResourceType(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Clip.Builder addLicense(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Clip.Builder addLicense(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Clip.Builder addLicense(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Clip.Builder addLicense(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Clip.Builder addLocationCreated(Place value) {
            return (Clip.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Clip.Builder addLocationCreated(Place.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Clip.Builder addLocationCreated(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Clip.Builder addMainEntity(Thing value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Clip.Builder addMainEntity(Thing.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Clip.Builder addMainEntity(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Clip.Builder addMainEntityOfPage(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Clip.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Clip.Builder addMainEntityOfPage(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Clip.Builder addMainEntityOfPage(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Clip.Builder addMentions(Thing value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Clip.Builder addMentions(Thing.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Clip.Builder addMentions(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Clip.Builder addMusicBy(MusicGroup value) {
            return (Clip.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public Clip.Builder addMusicBy(MusicGroup.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public Clip.Builder addMusicBy(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public Clip.Builder addMusicBy(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public Clip.Builder addMusicBy(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/musicBy", Text.of(value));
        }

        @Override
        public Clip.Builder addName(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Clip.Builder addName(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Clip.Builder addOffers(Offer value) {
            return (Clip.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Clip.Builder addOffers(Offer.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Clip.Builder addOffers(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Clip.Builder addPartOfEpisode(Episode value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfEpisode", value);
        }

        @Override
        public Clip.Builder addPartOfEpisode(Episode.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfEpisode", value.build());
        }

        @Override
        public Clip.Builder addPartOfEpisode(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfEpisode", Text.of(value));
        }

        @Override
        public Clip.Builder addPartOfSeason(CreativeWorkSeason value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfSeason", value);
        }

        @Override
        public Clip.Builder addPartOfSeason(CreativeWorkSeason.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfSeason", value.build());
        }

        @Override
        public Clip.Builder addPartOfSeason(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfSeason", Text.of(value));
        }

        @Override
        public Clip.Builder addPartOfSeries(CreativeWorkSeries value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfSeries", value);
        }

        @Override
        public Clip.Builder addPartOfSeries(CreativeWorkSeries.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfSeries", value.build());
        }

        @Override
        public Clip.Builder addPartOfSeries(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/partOfSeries", Text.of(value));
        }

        @Override
        public Clip.Builder addPosition(Integer value) {
            return (Clip.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Clip.Builder addPosition(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Clip.Builder addPosition(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Clip.Builder addPotentialAction(Action value) {
            return (Clip.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Clip.Builder addPotentialAction(Action.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Clip.Builder addPotentialAction(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Clip.Builder addProducer(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Clip.Builder addProducer(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Clip.Builder addProducer(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Clip.Builder addProducer(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Clip.Builder addProducer(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Clip.Builder addProvider(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Clip.Builder addProvider(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Clip.Builder addProvider(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Clip.Builder addProvider(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Clip.Builder addProvider(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Clip.Builder addPublication(PublicationEvent value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Clip.Builder addPublication(PublicationEvent.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Clip.Builder addPublication(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Clip.Builder addPublisher(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Clip.Builder addPublisher(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Clip.Builder addPublisher(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Clip.Builder addPublisher(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Clip.Builder addPublisher(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Clip.Builder addPublishingPrinciples(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Clip.Builder addPublishingPrinciples(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Clip.Builder addRecordedAt(Event value) {
            return (Clip.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Clip.Builder addRecordedAt(Event.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Clip.Builder addRecordedAt(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Clip.Builder addReleasedEvent(PublicationEvent value) {
            return (Clip.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Clip.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Clip.Builder addReleasedEvent(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Clip.Builder addReview(Review value) {
            return (Clip.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Clip.Builder addReview(Review.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Clip.Builder addReview(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Clip.Builder addReviews(Review value) {
            return (Clip.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Clip.Builder addReviews(Review.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Clip.Builder addReviews(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Clip.Builder addSameAs(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Clip.Builder addSameAs(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Clip.Builder addSchemaVersion(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Clip.Builder addSchemaVersion(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Clip.Builder addSchemaVersion(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Clip.Builder addSourceOrganization(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Clip.Builder addSourceOrganization(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Clip.Builder addSourceOrganization(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Clip.Builder addText(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Clip.Builder addText(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Clip.Builder addThumbnailUrl(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Clip.Builder addThumbnailUrl(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Clip.Builder addTimeRequired(Duration value) {
            return (Clip.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Clip.Builder addTimeRequired(Duration.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Clip.Builder addTimeRequired(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Clip.Builder addTranslator(Organization value) {
            return (Clip.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Clip.Builder addTranslator(Organization.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Clip.Builder addTranslator(Person value) {
            return (Clip.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Clip.Builder addTranslator(Person.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Clip.Builder addTranslator(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Clip.Builder addTypicalAgeRange(Text value) {
            return (Clip.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Clip.Builder addTypicalAgeRange(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Clip.Builder addUrl(URL value) {
            return (Clip.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Clip.Builder addUrl(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Clip.Builder addVersion(Number value) {
            return (Clip.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Clip.Builder addVersion(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Clip.Builder addVideo(VideoObject value) {
            return (Clip.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Clip.Builder addVideo(VideoObject.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Clip.Builder addVideo(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Clip.Builder addWorkExample(CreativeWork value) {
            return (Clip.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Clip.Builder addWorkExample(CreativeWork.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Clip.Builder addWorkExample(String value) {
            return (Clip.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Clip.Builder addDetailedDescription(Article value) {
            return (Clip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Clip.Builder addDetailedDescription(Article.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Clip.Builder addDetailedDescription(String value) {
            return (Clip.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Clip.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Clip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Clip.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Clip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Clip.Builder addPopularityScore(String value) {
            return (Clip.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Clip build() {
            return new ClipImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

