/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BreadcrumbList;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.ItemListImpl;
import com.google.schemaorg.core.ItemListOrderType;
import com.google.schemaorg.core.ListItem;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BreadcrumbListImpl
extends ItemListImpl
implements BreadcrumbList {
    private static final ImmutableSet<String> PROPERTY_SET = BreadcrumbListImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/itemListElement");
        builder.add((Object)"http://schema.org/itemListOrder");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numberOfItems");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BreadcrumbListImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BreadcrumbList";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BreadcrumbList.Builder>
    implements BreadcrumbList.Builder {
        BuilderImpl() {
        }

        @Override
        public BreadcrumbList.Builder addAdditionalType(URL value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BreadcrumbList.Builder addAdditionalType(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addAlternateName(Text value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BreadcrumbList.Builder addAlternateName(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addDescription(Text value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BreadcrumbList.Builder addDescription(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addImage(ImageObject value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BreadcrumbList.Builder addImage(ImageObject.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BreadcrumbList.Builder addImage(URL value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BreadcrumbList.Builder addImage(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addItemListElement(ListItem value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public BreadcrumbList.Builder addItemListElement(ListItem.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListElement", value.build());
        }

        @Override
        public BreadcrumbList.Builder addItemListElement(Text value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public BreadcrumbList.Builder addItemListElement(Thing value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public BreadcrumbList.Builder addItemListElement(Thing.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListElement", value.build());
        }

        @Override
        public BreadcrumbList.Builder addItemListElement(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListElement", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addItemListOrder(ItemListOrderType value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListOrder", value);
        }

        @Override
        public BreadcrumbList.Builder addItemListOrder(Text value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListOrder", value);
        }

        @Override
        public BreadcrumbList.Builder addItemListOrder(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/itemListOrder", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addMainEntityOfPage(CreativeWork value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BreadcrumbList.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BreadcrumbList.Builder addMainEntityOfPage(URL value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BreadcrumbList.Builder addMainEntityOfPage(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addName(Text value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BreadcrumbList.Builder addName(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addNumberOfItems(Integer value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/numberOfItems", value);
        }

        @Override
        public BreadcrumbList.Builder addNumberOfItems(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/numberOfItems", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addPotentialAction(Action value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BreadcrumbList.Builder addPotentialAction(Action.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BreadcrumbList.Builder addPotentialAction(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addSameAs(URL value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BreadcrumbList.Builder addSameAs(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addUrl(URL value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BreadcrumbList.Builder addUrl(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addDetailedDescription(Article value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BreadcrumbList.Builder addDetailedDescription(Article.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BreadcrumbList.Builder addDetailedDescription(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BreadcrumbList.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BreadcrumbList.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BreadcrumbList.Builder addPopularityScore(String value) {
            return (BreadcrumbList.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BreadcrumbList build() {
            return new BreadcrumbListImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

