/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.ApprovedIndication;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndicationImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ApprovedIndicationImpl
extends MedicalIndicationImpl
implements ApprovedIndication {
    private static final ImmutableSet<String> PROPERTY_SET = ApprovedIndicationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ApprovedIndicationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/ApprovedIndication";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<ApprovedIndication.Builder>
    implements ApprovedIndication.Builder {
        BuilderImpl() {
        }

        @Override
        public ApprovedIndication.Builder addAdditionalType(URL value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public ApprovedIndication.Builder addAdditionalType(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addAlternateName(Text value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public ApprovedIndication.Builder addAlternateName(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addCode(MedicalCode value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public ApprovedIndication.Builder addCode(MedicalCode.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public ApprovedIndication.Builder addCode(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addDescription(Text value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public ApprovedIndication.Builder addDescription(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addGuideline(MedicalGuideline value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public ApprovedIndication.Builder addGuideline(MedicalGuideline.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public ApprovedIndication.Builder addGuideline(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addImage(ImageObject value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ApprovedIndication.Builder addImage(ImageObject.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public ApprovedIndication.Builder addImage(URL value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ApprovedIndication.Builder addImage(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addMainEntityOfPage(CreativeWork value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ApprovedIndication.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public ApprovedIndication.Builder addMainEntityOfPage(URL value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ApprovedIndication.Builder addMainEntityOfPage(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addMedicineSystem(MedicineSystem value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public ApprovedIndication.Builder addMedicineSystem(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addName(Text value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public ApprovedIndication.Builder addName(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addPotentialAction(Action value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public ApprovedIndication.Builder addPotentialAction(Action.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public ApprovedIndication.Builder addPotentialAction(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addRecognizingAuthority(Organization value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public ApprovedIndication.Builder addRecognizingAuthority(Organization.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public ApprovedIndication.Builder addRecognizingAuthority(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public ApprovedIndication.Builder addRelevantSpecialty(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addSameAs(URL value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public ApprovedIndication.Builder addSameAs(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addStudy(MedicalStudy value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public ApprovedIndication.Builder addStudy(MedicalStudy.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public ApprovedIndication.Builder addStudy(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addUrl(URL value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public ApprovedIndication.Builder addUrl(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addDetailedDescription(Article value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public ApprovedIndication.Builder addDetailedDescription(Article.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public ApprovedIndication.Builder addDetailedDescription(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public ApprovedIndication.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public ApprovedIndication.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public ApprovedIndication.Builder addPopularityScore(String value) {
            return (ApprovedIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public ApprovedIndication build() {
            return new ApprovedIndicationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

