/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class AnatomicalSystemImpl
extends MedicalEntityImpl
implements AnatomicalSystem {
    private static final ImmutableSet<String> PROPERTY_SET = AnatomicalSystemImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/comprisedOf");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedStructure");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public AnatomicalSystemImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/AnatomicalSystem";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAssociatedPathophysiologyList() {
        return this.getProperty("http://schema.org/associatedPathophysiology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getComprisedOfList() {
        return this.getProperty("http://schema.org/comprisedOf");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedConditionList() {
        return this.getProperty("http://schema.org/relatedCondition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedStructureList() {
        return this.getProperty("http://schema.org/relatedStructure");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedTherapyList() {
        return this.getProperty("http://schema.org/relatedTherapy");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<AnatomicalSystem.Builder>
    implements AnatomicalSystem.Builder {
        BuilderImpl() {
        }

        @Override
        public AnatomicalSystem.Builder addAdditionalType(URL value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public AnatomicalSystem.Builder addAdditionalType(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addAlternateName(Text value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public AnatomicalSystem.Builder addAlternateName(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addAssociatedPathophysiology(Text value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public AnatomicalSystem.Builder addAssociatedPathophysiology(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addCode(MedicalCode value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public AnatomicalSystem.Builder addCode(MedicalCode.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addCode(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addComprisedOf(AnatomicalStructure value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/comprisedOf", value);
        }

        @Override
        public AnatomicalSystem.Builder addComprisedOf(AnatomicalStructure.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/comprisedOf", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addComprisedOf(AnatomicalSystem value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/comprisedOf", value);
        }

        @Override
        public AnatomicalSystem.Builder addComprisedOf(AnatomicalSystem.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/comprisedOf", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addComprisedOf(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/comprisedOf", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addDescription(Text value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public AnatomicalSystem.Builder addDescription(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addGuideline(MedicalGuideline value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public AnatomicalSystem.Builder addGuideline(MedicalGuideline.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addGuideline(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addImage(ImageObject value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AnatomicalSystem.Builder addImage(ImageObject.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addImage(URL value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AnatomicalSystem.Builder addImage(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addMainEntityOfPage(CreativeWork value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AnatomicalSystem.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addMainEntityOfPage(URL value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AnatomicalSystem.Builder addMainEntityOfPage(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addMedicineSystem(MedicineSystem value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public AnatomicalSystem.Builder addMedicineSystem(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addName(Text value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public AnatomicalSystem.Builder addName(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addPotentialAction(Action value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public AnatomicalSystem.Builder addPotentialAction(Action.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addPotentialAction(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addRecognizingAuthority(Organization value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public AnatomicalSystem.Builder addRecognizingAuthority(Organization.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addRecognizingAuthority(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addRelatedCondition(MedicalCondition value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public AnatomicalSystem.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addRelatedCondition(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addRelatedStructure(AnatomicalStructure value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedStructure", value);
        }

        @Override
        public AnatomicalSystem.Builder addRelatedStructure(AnatomicalStructure.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedStructure", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addRelatedStructure(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedStructure", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addRelatedTherapy(MedicalTherapy value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public AnatomicalSystem.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addRelatedTherapy(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public AnatomicalSystem.Builder addRelevantSpecialty(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addSameAs(URL value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public AnatomicalSystem.Builder addSameAs(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addStudy(MedicalStudy value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public AnatomicalSystem.Builder addStudy(MedicalStudy.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addStudy(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addUrl(URL value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public AnatomicalSystem.Builder addUrl(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addDetailedDescription(Article value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public AnatomicalSystem.Builder addDetailedDescription(Article.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addDetailedDescription(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public AnatomicalSystem.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public AnatomicalSystem.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public AnatomicalSystem.Builder addPopularityScore(String value) {
            return (AnatomicalSystem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public AnatomicalSystem build() {
            return new AnatomicalSystemImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

